/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.impl;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.context.ThreadMessageContext;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.node.Node;
import org.apache.tuscany.sca.node.configuration.NodeConfiguration;
import org.apache.tuscany.sca.node.impl.NodeFactoryImpl;
import org.apache.tuscany.sca.runtime.ActivationException;
import org.apache.tuscany.sca.runtime.CompositeActivator;
import org.apache.tuscany.sca.runtime.EndpointRegistry;
import org.apache.tuscany.sca.runtime.ExtensibleDomainRegistryFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.ServiceUnavailableException;

public class NodeImpl
implements Node {
    private static final Logger logger = Logger.getLogger(NodeImpl.class.getName());
    private ProxyFactory proxyFactory;
    private CompositeActivator compositeActivator;
    private CompositeContext compositeContext;
    private Composite domainComposite;
    private NodeConfiguration configuration;
    private NodeFactoryImpl nodeFactory;
    private List<Contribution> contributions;

    public NodeImpl(NodeFactoryImpl nodeFactory, NodeConfiguration configuration) {
        this.configuration = configuration;
        this.nodeFactory = nodeFactory;
    }

    public NodeImpl(NodeFactoryImpl manager, NodeConfiguration configuration, List<Contribution> contributions) {
        this.configuration = configuration;
        this.nodeFactory = manager;
        this.contributions = new ArrayList<Contribution>(contributions);
    }

    public String getURI() {
        return this.getConfiguration().getURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node start() {
        logger.log(this.nodeFactory.quietLogging ? Level.FINE : Level.INFO, "Starting node: " + this.configuration.getURI() + " domain: " + this.configuration.getDomainURI());
        this.nodeFactory.init();
        this.nodeFactory.addNode(this.configuration, this);
        this.proxyFactory = this.nodeFactory.proxyFactory;
        ExtensibleDomainRegistryFactory domainRegistryFactory = ExtensibleDomainRegistryFactory.getInstance(this.nodeFactory.registry);
        EndpointRegistry endpointRegistry = domainRegistryFactory.getEndpointRegistry(this.configuration.getDomainRegistryURI(), this.configuration.getDomainURI());
        UtilityExtensionPoint utilities = this.nodeFactory.registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.compositeActivator = utilities.getUtility(CompositeActivator.class);
        try {
            Monitor monitor = this.nodeFactory.monitorFactory.createMonitor();
            ProcessorContext context = new ProcessorContext(monitor);
            Monitor tcm = this.nodeFactory.monitorFactory.setContextMonitor(monitor);
            try {
                if (this.contributions == null) {
                    this.contributions = this.nodeFactory.loadContributions(this.configuration, context);
                }
                this.domainComposite = this.nodeFactory.configureNode(this.configuration, this.contributions, context);
                this.compositeContext = new CompositeContext(this.nodeFactory.registry, endpointRegistry, this.domainComposite, this.configuration.getDomainURI(), this.configuration.getURI(), this.nodeFactory.getDeployer().getSystemDefinitions());
            }
            finally {
                this.nodeFactory.monitorFactory.setContextMonitor(tcm);
            }
            this.compositeActivator.activate(this.compositeContext, this.domainComposite);
            this.compositeActivator.start(this.compositeContext, this.domainComposite);
            return this;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void stop() {
        logger.log(this.nodeFactory.quietLogging ? Level.FINE : Level.INFO, "Stopping node: " + this.configuration.getURI());
        try {
            if (this.compositeActivator == null) {
                return;
            }
            if (this.domainComposite != null) {
                this.compositeActivator.stop(this.compositeContext, this.domainComposite);
                this.compositeActivator.deactivate(this.domainComposite);
            }
            this.nodeFactory.removeNode(this.configuration);
            this.compositeActivator = null;
            this.proxyFactory = null;
            this.domainComposite = null;
            this.compositeContext = null;
            ThreadMessageContext.removeMessageContext();
        }
        catch (ActivationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public <B, R extends ServiceReference<B>> R cast(B target) throws IllegalArgumentException {
        return this.proxyFactory.cast(target);
    }

    @Override
    public <B> B getService(Class<B> businessInterface, String serviceName) {
        ServiceReference<B> serviceReference = this.getServiceReference(businessInterface, serviceName);
        if (serviceReference == null) {
            throw new ServiceRuntimeException("Service not found: " + serviceName);
        }
        return serviceReference.getService();
    }

    @Override
    public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, String name) {
        String serviceName;
        String componentName;
        int i = name.indexOf(47);
        if (i != -1) {
            componentName = name.substring(0, i);
            serviceName = name.substring(i + 1);
        } else {
            componentName = name;
            serviceName = null;
        }
        Component component = null;
        for (Component compositeComponent : this.domainComposite.getComponents()) {
            if (!compositeComponent.getName().equals(componentName)) continue;
            component = compositeComponent;
            break;
        }
        if (component == null) {
            throw new ServiceUnavailableException("The service " + name + " has not been contributed to the domain");
        }
        return ((RuntimeComponent)component).getServiceReference(businessInterface, serviceName);
    }

    public NodeConfiguration getConfiguration() {
        return this.configuration;
    }

    public ExtensionPointRegistry getExtensionPointRegistry() {
        return this.nodeFactory.getExtensionPointRegistry();
    }

    public List<Endpoint> getServiceEndpoints() {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        if (this.compositeActivator != null && this.domainComposite != null) {
            for (Component component : this.domainComposite.getComponents()) {
                for (ComponentService service : component.getServices()) {
                    if (!(service instanceof RuntimeComponentService)) continue;
                    endpoints.addAll(((RuntimeComponentService)service).getEndpoints());
                }
            }
        }
        return endpoints;
    }

    public Composite getDomainComposite() {
        return this.domainComposite;
    }

    public String dumpDomainComposite() {
        StAXArtifactProcessorExtensionPoint xmlProcessors = this.getExtensionPointRegistry().getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        StAXArtifactProcessor<Composite> compositeProcessor = xmlProcessors.getProcessor(Composite.class);
        return this.writeComposite(this.getDomainComposite(), compositeProcessor);
    }

    private String writeComposite(Composite composite, StAXArtifactProcessor<Composite> compositeProcessor) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLOutputFactory outputFactory = this.nodeFactory.getExtensionPointRegistry().getExtensionPoint(FactoryExtensionPoint.class).getFactory(XMLOutputFactory.class);
        try {
            compositeProcessor.write(composite, outputFactory.createXMLStreamWriter(bos), new ProcessorContext(this.nodeFactory.registry));
        }
        catch (Exception ex) {
            return ex.toString();
        }
        String result = bos.toString();
        for (Component component : composite.getComponents()) {
            if (!(component.getImplementation() instanceof Composite)) continue;
            result = result + "\n<!-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX -->\n" + this.writeComposite((Composite)component.getImplementation(), compositeProcessor);
        }
        return result;
    }

    public List<Contribution> getContributions() {
        return this.contributions;
    }
}

