/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.monitor.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;

public class MonitorImpl
extends Monitor {
    private static final Logger logger = Logger.getLogger(MonitorImpl.class.getName());
    private Stack<Object> contextStack = new Stack();
    private List<Problem> problemCache = new ArrayList<Problem>();
    private String artifactName = null;

    @Override
    public void problem(Problem problem) {
        Logger problemLogger = Logger.getLogger(problem.getSourceClassName(), problem.getResourceBundleName());
        if (problemLogger == null) {
            logger.severe("Can't get logger " + problem.getSourceClassName() + " with bundle " + problem.getResourceBundleName());
        }
        if (problem.getSeverity() == Problem.Severity.INFO) {
            this.problemCache.add(problem);
            problemLogger.logp(Level.INFO, problem.getSourceClassName(), problem.getContext(), problem.getMessageId(), problem.getMessageParams());
        } else if (problem.getSeverity() == Problem.Severity.WARNING) {
            this.problemCache.add(problem);
            problemLogger.logp(Level.WARNING, problem.getSourceClassName(), problem.getContext(), problem.getMessageId(), problem.getMessageParams());
        } else if (problem.getSeverity() == Problem.Severity.ERROR) {
            if (problem.getCause() != null) {
                this.problemCache.add(problem);
                problemLogger.logp(Level.SEVERE, problem.getSourceClassName(), problem.getContext(), problem.getMessageId(), problem.getCause());
            } else {
                this.problemCache.add(problem);
                problemLogger.logp(Level.SEVERE, problem.getSourceClassName(), problem.getContext(), problem.getMessageId(), problem.getMessageParams());
            }
        }
    }

    @Override
    public List<Problem> getProblems() {
        return this.problemCache;
    }

    @Override
    public Problem getLastProblem() {
        if (this.problemCache.isEmpty()) {
            return null;
        }
        return this.problemCache.get(this.problemCache.size() - 1);
    }

    @Override
    public Problem createProblem(String sourceClassName, String bundleName, Problem.Severity severity, Object problemObject, String messageId, Throwable cause) {
        return new ProblemImpl(sourceClassName, bundleName, severity, this.contextStack.toString(), problemObject, messageId, cause);
    }

    @Override
    public Problem createProblem(String sourceClassName, String bundleName, Problem.Severity severity, Object problemObject, String messageId, Object ... messageParams) {
        return new ProblemImpl(sourceClassName, bundleName, severity, this.contextStack.toString(), problemObject, messageId, messageParams);
    }

    public Problem createProblem(String sourceClassName, String bundleName, Problem.Severity severity, Object problemObject, String messageId, Throwable cause, Object ... messageParams) {
        return new ProblemImpl(sourceClassName, bundleName, severity, this.contextStack.toString(), problemObject, messageId, cause, messageParams);
    }

    @Override
    public String getArtifactName() {
        return this.artifactName;
    }

    @Override
    public void setArtifactName(String artifactName) {
        this.artifactName = artifactName;
    }

    @Override
    public void pushContext(Object context) {
        this.contextStack.push(context);
    }

    @Override
    public Object popContext() {
        return this.contextStack.pop();
    }

    @Override
    public void reset() {
        this.contextStack.clear();
        this.problemCache.clear();
        this.artifactName = null;
    }
}

