/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.monitor;

import java.util.List;
import java.util.logging.Logger;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.ValidationException;

public abstract class Monitor {
    private static final Logger logger = Logger.getLogger(Monitor.class.getName());

    public static void error(Monitor monitor, Object reportingObject, String messageBundle, String messageId, Object ... messageParameters) {
        String contextClassName = Monitor.getSourceClassName(reportingObject);
        if (monitor != null) {
            Problem problem = monitor.createProblem(contextClassName, messageBundle, Problem.Severity.ERROR, reportingObject, messageId, messageParameters);
            monitor.problem(problem);
        } else {
            Monitor.logNullMonitor(messageId, contextClassName);
        }
    }

    public static void error(Monitor monitor, Object reportingObject, String messageBundle, String messageId, Throwable cause) {
        String contextClassName = Monitor.getSourceClassName(reportingObject);
        if (monitor != null) {
            Problem problem = monitor.createProblem(contextClassName, messageBundle, Problem.Severity.ERROR, reportingObject, messageId, cause);
            monitor.problem(problem);
        } else {
            Monitor.logNullMonitor(messageId, contextClassName);
        }
    }

    public static void error(Monitor monitor, Object reportingObject, String messageBundle, String messageId, Throwable cause, Object ... messageParameters) {
        String contextClassName = Monitor.getSourceClassName(reportingObject);
        if (monitor != null) {
            Problem problem = monitor.createProblem(contextClassName, messageBundle, Problem.Severity.ERROR, reportingObject, messageId, cause, messageParameters);
            monitor.problem(problem);
        } else {
            Monitor.logNullMonitor(messageId, contextClassName);
        }
    }

    private static String getSourceClassName(Object reportingObject) {
        String contextClassName = null;
        contextClassName = reportingObject != null ? reportingObject.getClass().getName() : ContextFinder.getContextClass().getName();
        return contextClassName;
    }

    private static void logNullMonitor(String messageId, String contextClassName) {
        logger.warning("Attempt to report error with id " + messageId + " from class " + contextClassName + " but the monitor object was null");
    }

    public static void warning(Monitor monitor, Object reportingObject, String messageBundle, String messageId, Object ... messageParameters) {
        String contextClassName = Monitor.getSourceClassName(reportingObject);
        if (monitor != null) {
            Problem problem = monitor.createProblem(contextClassName, messageBundle, Problem.Severity.WARNING, reportingObject, messageId, messageParameters);
            monitor.problem(problem);
        } else {
            Monitor.logNullMonitor(messageId, contextClassName);
        }
    }

    public static void warning(Monitor monitor, Object reportingObject, String messageBundle, String messageId, Throwable cause) {
        String contextClassName = Monitor.getSourceClassName(reportingObject);
        if (monitor != null) {
            Problem problem = monitor.createProblem(contextClassName, messageBundle, Problem.Severity.WARNING, reportingObject, messageId, cause);
            monitor.problem(problem);
        } else {
            Monitor.logNullMonitor(messageId, contextClassName);
        }
    }

    public static void warning(Monitor monitor, Object reportingObject, String messageBundle, String messageId, Throwable cause, Object ... messageParameters) {
        String contextClassName = Monitor.getSourceClassName(reportingObject);
        if (monitor != null) {
            Problem problem = monitor.createProblem(contextClassName, messageBundle, Problem.Severity.WARNING, reportingObject, messageId, cause, messageParameters);
            monitor.problem(problem);
        } else {
            Monitor.logNullMonitor(messageId, contextClassName);
        }
    }

    public abstract Problem createProblem(String var1, String var2, Problem.Severity var3, Object var4, String var5, Object ... var6);

    public abstract Problem createProblem(String var1, String var2, Problem.Severity var3, Object var4, String var5, Throwable var6);

    public abstract String getArtifactName();

    public abstract Problem getLastProblem();

    public abstract List<Problem> getProblems();

    public abstract Object popContext();

    public abstract void problem(Problem var1);

    public abstract void pushContext(Object var1);

    public abstract void reset();

    public abstract void setArtifactName(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeProblems() throws ValidationException {
        try {
            for (Problem problem : this.getProblems()) {
                if (problem.getSeverity() != Problem.Severity.ERROR) continue;
                if (problem.getCause() != null) {
                    throw new ValidationException(problem.getCause());
                }
                throw new ValidationException(problem.toString());
            }
        }
        finally {
            this.reset();
        }
    }

    private static class ContextFinder
    extends SecurityManager {
        private static final ContextFinder instance = new ContextFinder();

        private ContextFinder() {
        }

        private static Class<?> getContextClass() {
            Class<?>[] classes = instance.getClassContext();
            return classes[4];
        }
    }
}

