/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.monitor;

import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.monitor.impl.MonitorImpl;

public class DefaultMonitorFactory
implements MonitorFactory {
    private ThreadLocal<Monitor> contextMonitor = new InheritableThreadLocal<Monitor>();

    @Override
    public Monitor createMonitor() {
        return new MonitorImpl();
    }

    @Override
    public Monitor getContextMonitor() {
        return this.contextMonitor.get();
    }

    @Override
    public Monitor getContextMonitor(boolean create) {
        Monitor monitor = this.contextMonitor.get();
        if (monitor == null) {
            monitor = new MonitorImpl();
            this.setContextMonitor(monitor);
        }
        return monitor;
    }

    @Override
    public Monitor removeContextMonitor() {
        Monitor old = this.contextMonitor.get();
        this.contextMonitor.remove();
        return old;
    }

    @Override
    public Monitor setContextMonitor(Monitor value) {
        Monitor old = this.contextMonitor.get();
        this.contextMonitor.set(value);
        return old;
    }
}

