/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.util;

import javax.xml.namespace.QName;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.TypeInfo;

public class XMLType {
    public static final XMLType UNKNOWN = new XMLType(null, null);
    protected QName element;
    protected QName type;
    protected boolean nillable = true;
    protected boolean many = false;

    public XMLType(ElementInfo element) {
        this.element = element.getQName();
        if (element.getType() != null) {
            this.type = element.getType().getQName();
        }
    }

    public XMLType(TypeInfo type) {
        this.element = null;
        this.type = type.getQName();
    }

    public XMLType(QName element, QName type) {
        this.element = element;
        this.type = type;
    }

    public QName getTypeName() {
        return this.type;
    }

    public boolean isElement() {
        return this.element != null;
    }

    public QName getElementName() {
        return this.element;
    }

    public void setElementName(QName element) {
        this.element = element;
    }

    public void setTypeName(QName type) {
        this.type = type;
    }

    public static XMLType getType(QName type) {
        return new XMLType(null, type);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLType other = (XMLType)obj;
        if (this.element == null ? other.element != null : !this.element.equals(other.element)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "Element: " + this.element + " Type: " + this.type;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public void setNillable(boolean niable) {
        this.nillable = niable;
    }

    public boolean isMany() {
        return this.many;
    }

    public void setMany(boolean many) {
        this.many = many;
    }
}

