/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.xml;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceClient;
import org.apache.tuscany.sca.assembly.xml.PolicySubjectProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.interfacedef.Compatibility;
import org.apache.tuscany.sca.interfacedef.IncompatibleInterfaceContractException;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.java.xml.JavaConstants;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.oasisopen.sca.annotation.AllowsPassByReference;
import org.oasisopen.sca.annotation.Callback;
import org.oasisopen.sca.annotation.ComponentName;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Context;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Intent;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Qualifier;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

public class JavaInterfaceProcessor
implements StAXArtifactProcessor<JavaInterfaceContract>,
JavaConstants {
    private static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
    private JavaInterfaceFactory javaFactory;
    private ExtensionPointRegistry extensionPoints;
    private PolicyFactory policyFactory;
    private PolicySubjectProcessor policyProcessor;
    private WSDLFactory wsdlFactory;
    private StAXArtifactProcessor<Object> extensionProcessor;
    private transient InterfaceContractMapper interfaceContractMapper;
    private static List<Class<?>> JCA30006_ANNOTATIONS = Arrays.asList(AllowsPassByReference.class, ComponentName.class, Constructor.class, Context.class, Destroy.class, EagerInit.class, Init.class, Intent.class, Property.class, Qualifier.class, Reference.class, Scope.class, Service.class);
    private static List<Class<?>> JCA30007_ANNOTATIONS = Arrays.asList(AllowsPassByReference.class, Callback.class, ComponentName.class, Constructor.class, Context.class, Destroy.class, EagerInit.class, Init.class, Intent.class, Property.class, Qualifier.class, Reference.class, Scope.class, Service.class);
    private static List<Class<?>> JCA30008_ANNOTATIONS = Arrays.asList(Intent.class, Qualifier.class);

    public JavaInterfaceProcessor(ExtensionPointRegistry extensionPoints, StAXArtifactProcessor<?> staxProcessor) {
        this.extensionPoints = extensionPoints;
        FactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.policyProcessor = new PolicySubjectProcessor(this.policyFactory);
        this.javaFactory = modelFactories.getFactory(JavaInterfaceFactory.class);
        this.wsdlFactory = modelFactories.getFactory(WSDLFactory.class);
        this.extensionProcessor = staxProcessor;
        UtilityExtensionPoint utilities = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        this.interfaceContractMapper = utilities.getUtility(InterfaceContractMapper.class);
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "interface-javaxml-validation-messages", Problem.Severity.ERROR, model, message, ex);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "interface-javaxml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private JavaInterface createJavaInterface(String interfaceName) {
        JavaInterface javaInterface = this.javaFactory.createJavaInterface();
        javaInterface.setUnresolved(true);
        javaInterface.setName(interfaceName);
        return javaInterface;
    }

    @Override
    public JavaInterfaceContract read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        String remotable;
        String callbackInterfaceName;
        JavaInterfaceContract javaInterfaceContract = this.javaFactory.createJavaInterfaceContract();
        String interfaceName = reader.getAttributeValue(null, "interface");
        if (interfaceName != null) {
            JavaInterface javaInterface = this.createJavaInterface(interfaceName);
            javaInterfaceContract.setInterface(javaInterface);
        }
        if ((callbackInterfaceName = reader.getAttributeValue(null, "callbackInterface")) != null) {
            JavaInterface javaCallbackInterface = this.createJavaInterface(callbackInterfaceName);
            javaInterfaceContract.setCallbackInterface(javaCallbackInterface);
        }
        if ((remotable = reader.getAttributeValue(null, "remotable")) != null) {
            javaInterfaceContract.getInterface().setRemotable(Boolean.parseBoolean(remotable));
        }
        this.policyProcessor.readPolicies(javaInterfaceContract.getInterface(), reader);
        while (reader.hasNext() && (reader.next() != 2 || !INTERFACE_JAVA_QNAME.equals(reader.getName()))) {
        }
        return javaInterfaceContract;
    }

    @Override
    public void write(JavaInterfaceContract javaInterfaceContract, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        JavaInterface javaCallbackInterface;
        writer.writeStartElement(SCA11_NS, "interface.java");
        JavaInterface javaInterface = (JavaInterface)javaInterfaceContract.getInterface();
        if (javaInterface != null && javaInterface.getName() != null) {
            writer.writeAttribute("interface", javaInterface.getName());
        }
        if (javaInterface != null && javaInterface.isRemotableSet()) {
            writer.writeAttribute("remotable", String.valueOf(javaInterface.isRemotable()));
        }
        if ((javaCallbackInterface = (JavaInterface)javaInterfaceContract.getCallbackInterface()) != null && javaCallbackInterface.getName() != null) {
            writer.writeAttribute("callbackInterface", javaCallbackInterface.getName());
        }
        this.policyProcessor.writePolicyAttributes(javaInterface, writer);
        writer.writeEndElement();
    }

    private JavaInterface resolveJavaInterface(JavaInterface javaInterface, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (javaInterface != null && javaInterface.isUnresolved()) {
            Monitor monitor = context.getMonitor();
            if ((javaInterface = resolver.resolveModel(JavaInterface.class, javaInterface, context)).isUnresolved()) {
                ClassReference classReference = new ClassReference(javaInterface.getName());
                Class<?> javaClass = (classReference = resolver.resolveModel(ClassReference.class, classReference, context)).getJavaClass();
                if (javaClass == null) {
                    this.error(monitor, "ClassNotFoundException", (Object)resolver, javaInterface.getName());
                    return javaInterface;
                }
                try {
                    this.javaFactory.createJavaInterface(javaInterface, javaClass);
                    javaInterface.setContributionContainingClass(classReference.getContributionContainingClass());
                }
                catch (InvalidInterfaceException e) {
                    ContributionResolveException ce = new ContributionResolveException("Resolving Java interface " + javaInterface.getName(), e);
                    this.error(monitor, "InvalidInterfaceException", (Object)this.javaFactory, e);
                    return javaInterface;
                }
                catch (Exception e) {
                    throw new ContributionResolveException("Resolving Java interface " + javaInterface.getName(), e);
                }
                javaInterface.setUnresolved(false);
                resolver.addModel(javaInterface, context);
            }
        }
        return javaInterface;
    }

    @Override
    public void resolve(JavaInterfaceContract javaInterfaceContract, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        try {
            Monitor monitor = context.getMonitor();
            JavaInterface javaInterface = this.resolveJavaInterface((JavaInterface)javaInterfaceContract.getInterface(), resolver, context);
            javaInterfaceContract.setInterface(javaInterface);
            JavaInterface javaCallbackInterface = this.resolveJavaInterface((JavaInterface)javaInterfaceContract.getCallbackInterface(), resolver, context);
            javaInterfaceContract.setCallbackInterface(javaCallbackInterface);
            this.postJAXWSProcessorResolve(javaInterfaceContract, resolver, context);
            this.checkForbiddenAnnotations(monitor, javaInterfaceContract);
        }
        catch (Exception e) {
            throw new ContributionResolveException("Resolving Java Interface " + javaInterfaceContract.getInterface().toString(), e);
        }
    }

    private void checkForbiddenAnnotations(Monitor monitor, JavaInterfaceContract javaInterfaceContract) {
        if (javaInterfaceContract.getInterface() == null) {
            return;
        }
        Class<?> ifc = ((JavaInterface)javaInterfaceContract.getInterface()).getJavaClass();
        if (ifc == null) {
            return;
        }
        for (Annotation annotation : ifc.getAnnotations()) {
            if (ifc.isInterface()) {
                if (JCA30006_ANNOTATIONS.contains(annotation.annotationType())) {
                    this.error(monitor, "ForbiddenAnnotationJCA30006", (Object)javaInterfaceContract, annotation.annotationType(), ifc.getName());
                }
            } else if (JCA30008_ANNOTATIONS.contains(annotation.annotationType())) {
                this.error(monitor, "ForbiddenAnnotationJCA30008", (Object)javaInterfaceContract, annotation.annotationType(), ifc.getName());
            }
            if (!annotation.annotationType().equals(WebServiceClient.class)) continue;
            this.error(monitor, "ForbiddenAnnotationJCA100018", (Object)javaInterfaceContract, annotation.annotationType(), ifc.getName());
        }
        for (Method method : ifc.getMethods()) {
            for (Annotation a : method.getAnnotations()) {
                if (ifc.isInterface()) {
                    if (!JCA30006_ANNOTATIONS.contains(a.annotationType())) continue;
                    this.error(monitor, "ForbiddenAnnotationJCA30006", (Object)javaInterfaceContract, a.annotationType(), ifc.getName());
                    continue;
                }
                if (!JCA30008_ANNOTATIONS.contains(a.annotationType())) continue;
                this.error(monitor, "ForbiddenAnnotationJCA30008", (Object)javaInterfaceContract, a.annotationType(), ifc.getName());
            }
        }
        for (Field field : ifc.getFields()) {
            for (Annotation a : field.getAnnotations()) {
                if (ifc.isInterface()) {
                    if (!JCA30006_ANNOTATIONS.contains(a.annotationType())) continue;
                    this.error(monitor, "ForbiddenAnnotationJCA30006", (Object)javaInterfaceContract, a.annotationType(), ifc.getName());
                    continue;
                }
                if (!JCA30008_ANNOTATIONS.contains(a.annotationType())) continue;
                this.error(monitor, "ForbiddenAnnotationJCA30008", (Object)javaInterfaceContract, a.annotationType(), ifc.getName());
            }
        }
        if (javaInterfaceContract.getCallbackInterface() == null) {
            return;
        }
        ifc = ((JavaInterface)javaInterfaceContract.getCallbackInterface()).getJavaClass();
        if (ifc == null) {
            return;
        }
        for (Annotation annotation : ifc.getAnnotations()) {
            if (ifc.isInterface()) {
                if (!JCA30007_ANNOTATIONS.contains(annotation.annotationType())) continue;
                this.error(monitor, "ForbiddenAnnotationJCA30007", (Object)javaInterfaceContract, annotation.annotationType(), ifc.getName());
                continue;
            }
            if (!JCA30008_ANNOTATIONS.contains(annotation.annotationType())) continue;
            this.error(monitor, "ForbiddenAnnotationJCA30008", (Object)javaInterfaceContract, annotation.annotationType(), ifc.getName());
        }
        for (Method method : ifc.getMethods()) {
            for (Annotation a : method.getAnnotations()) {
                if (ifc.isInterface()) {
                    if (!JCA30007_ANNOTATIONS.contains(a.annotationType())) continue;
                    this.error(monitor, "ForbiddenAnnotationJCA30007", (Object)javaInterfaceContract, a.annotationType(), ifc.getName());
                    continue;
                }
                if (!JCA30008_ANNOTATIONS.contains(a.annotationType())) continue;
                this.error(monitor, "ForbiddenAnnotationJCA30008", (Object)javaInterfaceContract, a.annotationType(), ifc.getName());
            }
        }
        for (Field field : ifc.getFields()) {
            for (Annotation a : field.getAnnotations()) {
                if (ifc.isInterface()) {
                    if (!JCA30007_ANNOTATIONS.contains(a.annotationType())) continue;
                    this.error(monitor, "ForbiddenAnnotationJCA30007", (Object)javaInterfaceContract, a.annotationType(), ifc.getName());
                    continue;
                }
                if (!JCA30008_ANNOTATIONS.contains(a.annotationType())) continue;
                this.error(monitor, "ForbiddenAnnotationJCA30008", (Object)javaInterfaceContract, a.annotationType(), ifc.getName());
            }
        }
    }

    @Override
    public QName getArtifactType() {
        return INTERFACE_JAVA_QNAME;
    }

    @Override
    public Class<JavaInterfaceContract> getModelType() {
        return JavaInterfaceContract.class;
    }

    private void postJAXWSProcessorResolve(JavaInterfaceContract javaInterfaceContract, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException, IncompatibleInterfaceContractException {
        JavaInterface javaCallbackInterface;
        JavaInterface javaInterface = (JavaInterface)javaInterfaceContract.getInterface();
        if (javaInterface != null && javaInterface.isUnresolved()) {
            javaInterface = this.resolveJavaInterface(javaInterface, resolver, context);
            javaInterfaceContract.setInterface(javaInterface);
        }
        if ((javaCallbackInterface = (JavaInterface)javaInterfaceContract.getCallbackInterface()) != null && javaCallbackInterface.isUnresolved()) {
            javaCallbackInterface = this.resolveJavaInterface(javaCallbackInterface, resolver, context);
            javaInterfaceContract.setCallbackInterface(javaCallbackInterface);
        }
        if (javaInterface != null && javaInterface.getJAXWSWSDLLocation() != null) {
            WSDLInterface wsdlInterface = this.wsdlFactory.createWSDLInterface();
            wsdlInterface.setUnresolved(true);
            wsdlInterface.setRemotable(true);
            WSDLInterfaceContract wsdlInterfaceContract = this.wsdlFactory.createWSDLInterfaceContract();
            wsdlInterfaceContract.setInterface(wsdlInterface);
            wsdlInterfaceContract.setLocation(javaInterface.getJAXWSWSDLLocation());
            javaInterfaceContract.setNormailizedWSDLContract(wsdlInterfaceContract);
            ProcessorContext wsdlContext = new ProcessorContext(javaInterface.getContributionContainingClass(), context.getMonitor());
            this.extensionProcessor.resolve(wsdlInterfaceContract, resolver, wsdlContext);
            this.interfaceContractMapper.checkCompatibility(wsdlInterfaceContract, javaInterfaceContract, Compatibility.SUBSET, false, false);
            javaInterface.getPolicySets().addAll(wsdlInterface.getPolicySets());
            javaInterface.getRequiredIntents().addAll(wsdlInterface.getRequiredIntents());
        }
    }
}

