/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.jaxws;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.jaxb.JAXBDataBinding;
import org.apache.tuscany.sca.databinding.jaxb.XMLAdapterExtensionPoint;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.FaultExceptionMapper;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.ParameterMode;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;
import org.apache.tuscany.sca.interfacedef.java.jaxws.CodeGenerationHelper;
import org.apache.tuscany.sca.interfacedef.java.jaxws.GeneratedClassLoader;
import org.apache.tuscany.sca.interfacedef.java.jaxws.GeneratedDataTypeImpl;
import org.apache.tuscany.sca.interfacedef.java.jaxws.JAXWSFaultExceptionMapper;
import org.apache.tuscany.sca.interfacedef.java.jaxws.JAXWSUtils;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.TypeInfo;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;

public class JAXWSJavaInterfaceProcessor
implements JavaInterfaceVisitor {
    private static final String JAXB_DATABINDING = JAXBDataBinding.NAME;
    private static final String GET = "get";
    private DataBindingExtensionPoint dataBindingExtensionPoint;
    private FaultExceptionMapper faultExceptionMapper;
    private XMLAdapterExtensionPoint xmlAdapterExtensionPoint;
    protected JavaInterfaceFactory javaInterfaceFactory;
    private WSDLFactory wsdlFactory;

    public JAXWSJavaInterfaceProcessor(ExtensionPointRegistry registry) {
        this.dataBindingExtensionPoint = registry.getExtensionPoint(DataBindingExtensionPoint.class);
        this.faultExceptionMapper = registry.getExtensionPoint(UtilityExtensionPoint.class).getUtility(FaultExceptionMapper.class);
        this.xmlAdapterExtensionPoint = registry.getExtensionPoint(XMLAdapterExtensionPoint.class);
        FactoryExtensionPoint factories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.javaInterfaceFactory = factories.getFactory(JavaInterfaceFactory.class);
        this.wsdlFactory = factories.getFactory(WSDLFactory.class);
    }

    public JAXWSJavaInterfaceProcessor() {
    }

    private ParameterMode getParameterMode(WebParam.Mode mode) {
        if (mode == WebParam.Mode.INOUT) {
            return ParameterMode.INOUT;
        }
        if (mode == WebParam.Mode.OUT) {
            return ParameterMode.OUT;
        }
        return ParameterMode.IN;
    }

    private static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    @Override
    public void visitInterface(JavaInterface contract) throws InvalidInterfaceException {
        final Class<?> clazz = contract.getJavaClass();
        contract = JAXWSUtils.configureJavaInterface(contract, clazz);
        String tns = contract.getQName().getNamespaceURI();
        if (!contract.isRemotable()) {
            return;
        }
        SOAPBinding soapBinding = clazz.getAnnotation(SOAPBinding.class);
        Iterator<Operation> it = contract.getOperations().iterator();
        while (it.hasNext()) {
            String ns;
            Oneway oneway;
            final JavaOperation operation = (JavaOperation)it.next();
            final Method method = operation.getJavaMethod();
            this.introspectFaultTypes(operation);
            SOAPBinding methodSOAPBinding = method.getAnnotation(SOAPBinding.class);
            if (methodSOAPBinding == null) {
                methodSOAPBinding = soapBinding;
            }
            boolean documentStyle = true;
            boolean bare = false;
            if (methodSOAPBinding != null) {
                boolean bl = bare = methodSOAPBinding.parameterStyle() == SOAPBinding.ParameterStyle.BARE;
                if (bare) {
                    operation.setWrapperStyle(false);
                }
                documentStyle = methodSOAPBinding.style() == SOAPBinding.Style.DOCUMENT;
            }
            String operationName = operation.getName();
            WebMethod webMethod = method.getAnnotation(WebMethod.class);
            if (webMethod != null) {
                if (webMethod.exclude()) {
                    it.remove();
                    continue;
                }
                operationName = JAXWSJavaInterfaceProcessor.getValue(webMethod.operationName(), operationName);
                operation.setName(operationName);
                operation.setAction(webMethod.action());
            }
            if ((oneway = method.getAnnotation(Oneway.class)) != null) {
                assert (method.getReturnType() == Void.TYPE);
                operation.setNonBlocking(true);
            }
            if (bare) {
                for (int i = 0; i < method.getParameterTypes().length; ++i) {
                    WebParam param = this.getAnnotation(method, i, WebParam.class);
                    if (param != null) {
                        String ns2 = JAXWSJavaInterfaceProcessor.getValue(param.targetNamespace(), tns);
                        String name = JAXWSJavaInterfaceProcessor.getValue(param.name(), documentStyle ? operationName : "arg" + i);
                        QName element = new QName(ns2, name);
                        Object logical = operation.getInputType().getLogical().get(i).getLogical();
                        if (logical instanceof XMLType) {
                            ((XMLType)logical).setElementName(element);
                        }
                        operation.getParameterModes().set(i, this.getParameterMode(param.mode()));
                    }
                    ParameterMode mode = operation.getParameterModes().get(i);
                }
                WebResult result = method.getAnnotation(WebResult.class);
                if (result != null) {
                    List<DataType> outputDataTypes;
                    DataType returnDataType;
                    ns = JAXWSJavaInterfaceProcessor.getValue(result.targetNamespace(), tns);
                    String name = JAXWSJavaInterfaceProcessor.getValue(result.name(), documentStyle ? operationName + "Response" : "return");
                    QName element = new QName(ns, name);
                    if (!operation.hasReturnTypeVoid() && (returnDataType = (outputDataTypes = operation.getOutputType().getLogical()).get(0)) instanceof XMLType) {
                        ((XMLType)((Object)returnDataType)).setElementName(element);
                    }
                }
            } else {
                String wrapperBeanName;
                RequestWrapper requestWrapper = method.getAnnotation(RequestWrapper.class);
                ns = requestWrapper == null ? tns : JAXWSJavaInterfaceProcessor.getValue(requestWrapper.targetNamespace(), tns);
                String name = requestWrapper == null ? operationName : JAXWSJavaInterfaceProcessor.getValue(requestWrapper.localName(), operationName);
                String string = wrapperBeanName = requestWrapper == null ? "" : requestWrapper.className();
                if ("".equals(wrapperBeanName)) {
                    wrapperBeanName = CodeGenerationHelper.getPackagePrefix(clazz) + JAXWSJavaInterfaceProcessor.capitalize(method.getName());
                }
                DataType<XMLType> inputWrapperDT = null;
                final String inputWrapperClassName = wrapperBeanName;
                final String inputNS = ns;
                final String inputName = name;
                inputWrapperDT = AccessController.doPrivileged(new PrivilegedAction<DataType<XMLType>>(){

                    @Override
                    public DataType<XMLType> run() {
                        try {
                            Class<?> wrapperClass = Class.forName(inputWrapperClassName, false, clazz.getClassLoader());
                            QName qname = new QName(inputNS, inputName);
                            DataTypeImpl<XMLType> dt = new DataTypeImpl<XMLType>(wrapperClass, new XMLType(qname, qname));
                            JAXWSJavaInterfaceProcessor.this.dataBindingExtensionPoint.introspectType(dt, (Operation)operation);
                            if (dt.getLogical() instanceof XMLType) {
                                XMLType xmlType = (XMLType)dt.getLogical();
                                xmlType.setElementName(qname);
                            }
                            return dt;
                        }
                        catch (ClassNotFoundException e) {
                            GeneratedClassLoader cl = new GeneratedClassLoader(clazz.getClassLoader());
                            return new GeneratedDataTypeImpl(JAXWSJavaInterfaceProcessor.this.xmlAdapterExtensionPoint, method, inputWrapperClassName, inputNS, inputName, true, cl);
                        }
                    }
                });
                QName inputWrapper = inputWrapperDT.getLogical().getElementName();
                ResponseWrapper responseWrapper = method.getAnnotation(ResponseWrapper.class);
                ns = responseWrapper == null ? tns : JAXWSJavaInterfaceProcessor.getValue(responseWrapper.targetNamespace(), tns);
                name = responseWrapper == null ? operationName + "Response" : JAXWSJavaInterfaceProcessor.getValue(responseWrapper.localName(), operationName + "Response");
                String string2 = wrapperBeanName = responseWrapper == null ? "" : responseWrapper.className();
                if ("".equals(wrapperBeanName)) {
                    wrapperBeanName = CodeGenerationHelper.getPackagePrefix(clazz) + JAXWSJavaInterfaceProcessor.capitalize(method.getName()) + "Response";
                }
                DataType<XMLType> outputWrapperDT = null;
                final String outputWrapperClassName = wrapperBeanName;
                final String outputNS = ns;
                final String outputName = name;
                outputWrapperDT = AccessController.doPrivileged(new PrivilegedAction<DataType<XMLType>>(){

                    @Override
                    public DataType<XMLType> run() {
                        try {
                            Class<?> wrapperClass = Class.forName(outputWrapperClassName, false, clazz.getClassLoader());
                            QName qname = new QName(outputNS, outputName);
                            DataTypeImpl<XMLType> dt = new DataTypeImpl<XMLType>(wrapperClass, new XMLType(qname, qname));
                            JAXWSJavaInterfaceProcessor.this.dataBindingExtensionPoint.introspectType(dt, (Operation)operation);
                            if (dt.getLogical() instanceof XMLType) {
                                XMLType xmlType = (XMLType)dt.getLogical();
                                xmlType.setElementName(qname);
                            }
                            return dt;
                        }
                        catch (ClassNotFoundException e) {
                            GeneratedClassLoader cl = new GeneratedClassLoader(clazz.getClassLoader());
                            return new GeneratedDataTypeImpl(JAXWSJavaInterfaceProcessor.this.xmlAdapterExtensionPoint, method, outputWrapperClassName, outputNS, outputName, false, cl);
                        }
                    }
                });
                QName outputWrapper = outputWrapperDT.getLogical().getElementName();
                ArrayList<ElementInfo> outputElements = new ArrayList<ElementInfo>();
                WebResult result = method.getAnnotation(WebResult.class);
                ns = result != null ? result.targetNamespace() : "";
                ns = JAXWSJavaInterfaceProcessor.getValue(ns, documentStyle && (result == null || !result.header()) ? "" : tns);
                name = result != null ? result.name() : "";
                name = JAXWSJavaInterfaceProcessor.getValue(name, "return");
                QName element = new QName(ns, name);
                if (!operation.hasReturnTypeVoid()) {
                    Object logical = operation.getOutputType().getLogical().get(0).getLogical();
                    QName type = null;
                    if (logical instanceof XMLType) {
                        ((XMLType)logical).setElementName(element);
                        type = ((XMLType)logical).getTypeName();
                    }
                    outputElements.add(new ElementInfo(element, new TypeInfo(type, false, null)));
                }
                ArrayList<ElementInfo> inputElements = new ArrayList<ElementInfo>();
                for (int i = 0; i < method.getParameterTypes().length; ++i) {
                    ParameterMode mode;
                    WebParam param = this.getAnnotation(method, i, WebParam.class);
                    ns = param != null ? param.targetNamespace() : "";
                    ns = JAXWSJavaInterfaceProcessor.getValue(ns, documentStyle && (param == null || !param.header()) ? "" : tns);
                    name = param != null ? param.name() : "";
                    name = JAXWSJavaInterfaceProcessor.getValue(name, "arg" + i);
                    element = new QName(ns, name);
                    Object logical = operation.getInputType().getLogical().get(i).getLogical();
                    QName type = null;
                    if (logical instanceof XMLType) {
                        ((XMLType)logical).setElementName(element);
                        type = ((XMLType)logical).getTypeName();
                    }
                    if (param != null) {
                        mode = this.getParameterMode(param.mode());
                        operation.getParameterModes().set(i, mode);
                    }
                    if ((mode = operation.getParameterModes().get(i)).equals((Object)ParameterMode.INOUT)) {
                        inputElements.add(new ElementInfo(element, new TypeInfo(type, false, null)));
                        outputElements.add(new ElementInfo(element, new TypeInfo(type, false, null)));
                        continue;
                    }
                    if (mode.equals((Object)ParameterMode.OUT)) {
                        outputElements.add(new ElementInfo(element, new TypeInfo(type, false, null)));
                        continue;
                    }
                    inputElements.add(new ElementInfo(element, new TypeInfo(type, false, null)));
                }
                String db = inputWrapperDT != null ? inputWrapperDT.getDataBinding() : JAXB_DATABINDING;
                WrapperInfo wrapperInfo = new WrapperInfo(db, new ElementInfo(inputWrapper, null), new ElementInfo(outputWrapper, null), inputElements, outputElements);
                wrapperInfo.setInputWrapperType(inputWrapperDT);
                wrapperInfo.setOutputWrapperType(outputWrapperDT);
                operation.setWrapper(wrapperInfo);
            }
            List<ParameterMode> parmModes = operation.getParameterModes();
            List<DataType> inputDTs = operation.getInputType().getLogical();
            for (int i = parmModes.size() - 1; i >= 0; --i) {
                if (!parmModes.get(i).equals((Object)ParameterMode.OUT)) continue;
                inputDTs.remove(i);
            }
        }
    }

    private void introspectFaultTypes(Operation operation) {
        if (operation != null && operation.getFaultTypes() != null) {
            for (DataType exceptionType : operation.getFaultTypes()) {
                this.faultExceptionMapper.introspectFaultDataType(exceptionType, operation, true);
                DataType faultType = (DataType)exceptionType.getLogical();
                if (!"java:exception".equals(faultType.getDataBinding())) continue;
                this.createSyntheticBean(operation, exceptionType);
            }
        }
    }

    private void createSyntheticBean(Operation operation, DataType exceptionType) {
        DataType faultType = (DataType)exceptionType.getLogical();
        QName faultBeanName = ((XMLType)faultType.getLogical()).getElementName();
        ArrayList<DataTypeImpl<XMLType>> beanDataTypes = new ArrayList<DataTypeImpl<XMLType>>();
        for (Method aMethod : exceptionType.getPhysical().getMethods()) {
            int i;
            if (!Modifier.isPublic(aMethod.getModifiers()) || !aMethod.getName().startsWith(GET) || aMethod.getParameterTypes().length != 0 || !JAXWSFaultExceptionMapper.isMappedGetter(aMethod.getName())) continue;
            String propName = this.resolvePropertyFromMethod(aMethod.getName());
            QName propQName = new QName(faultBeanName.getNamespaceURI(), propName);
            Class<?> propType = aMethod.getReturnType();
            XMLType xmlPropType = new XMLType(propQName, null);
            DataTypeImpl<XMLType> propDT = new DataTypeImpl<XMLType>(propType, xmlPropType);
            org.apache.tuscany.sca.databinding.annotation.DataType dt = aMethod.getAnnotation(org.apache.tuscany.sca.databinding.annotation.DataType.class);
            if (dt != null) {
                propDT.setDataBinding(dt.value());
            }
            this.dataBindingExtensionPoint.introspectType(propDT, operation);
            for (i = 0; i < beanDataTypes.size() && ((XMLType)((DataType)beanDataTypes.get(i)).getLogical()).getElementName().getLocalPart().compareTo(propName) <= 0; ++i) {
            }
            beanDataTypes.add(i, propDT);
        }
        operation.getFaultBeans().put(faultBeanName, beanDataTypes);
    }

    private String resolvePropertyFromMethod(String methodName) {
        StringBuffer propName = new StringBuffer();
        propName.append(Character.toLowerCase(methodName.charAt(GET.length())));
        propName.append(methodName.substring(GET.length() + 1));
        return propName.toString();
    }

    private <T extends Annotation> T getAnnotation(Method method, int index, Class<T> annotationType) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getParameterAnnotations()[index]) {
            if (annotation.annotationType() != annotationType) continue;
            return (T)((Annotation)annotationType.cast(annotation));
        }
        return null;
    }

    private static String getValue(String value, String defaultValue) {
        return "".equals(value) ? defaultValue : value;
    }
}

