/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.xml.namespace.QName;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Holder;
import javax.xml.ws.Response;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InvalidAnnotationException;
import org.apache.tuscany.sca.interfacedef.InvalidCallbackException;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.InvalidOperationException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.OverloadedOperationException;
import org.apache.tuscany.sca.interfacedef.ParameterMode;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaIntrospectionHelper;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaOperationImpl;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;
import org.apache.tuscany.sca.interfacedef.util.JavaXMLMapper;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.oasisopen.sca.annotation.AsyncFault;
import org.oasisopen.sca.annotation.Callback;
import org.oasisopen.sca.annotation.OneWay;
import org.oasisopen.sca.annotation.Remotable;

public class JavaInterfaceIntrospectorImpl {
    private static final String UNKNOWN_DATABINDING = null;
    private JavaInterfaceFactory javaFactory = null;
    private List<JavaInterfaceVisitor> visitors = new ArrayList<JavaInterfaceVisitor>();
    private boolean loadedVisitors;

    public JavaInterfaceIntrospectorImpl(JavaInterfaceFactory javaFactory) {
        this.javaFactory = javaFactory;
    }

    public void introspectInterface(JavaInterface javaInterface, Class<?> clazz) throws InvalidInterfaceException {
        if (!this.loadedVisitors) {
            this.visitors = this.javaFactory.getInterfaceVisitors();
        }
        javaInterface.setJavaClass(clazz);
        boolean remotable = clazz.isAnnotationPresent(Remotable.class);
        if (!remotable) {
            for (Annotation annotation : clazz.getAnnotations()) {
                if (!"javax.ejb.Remote".equals(annotation.annotationType().getName())) continue;
                remotable = true;
                break;
            }
        }
        if (!remotable) {
            for (Class<?> superInterface : clazz.getInterfaces()) {
                if (Remote.class != superInterface && !"javax.ejb.EJBObject".equals(superInterface.getName())) continue;
                remotable = true;
                break;
            }
        }
        if (remotable) {
            if (javaInterface.isRemotableSet() && !javaInterface.isRemotable()) {
                throw new InvalidAnnotationException("[JCA30005] @Remotable annotation present in a interface marked as not remotable in the SCDL", Remotable.class);
            }
        } else if (javaInterface.isRemotableSet()) {
            remotable = javaInterface.isRemotable();
        }
        javaInterface.setRemotable(remotable);
        Class<?> callbackClass = null;
        Callback callback = clazz.getAnnotation(Callback.class);
        if (callback != null && !Void.class.equals(callback.value())) {
            callbackClass = callback.value();
            if (remotable && !callbackClass.isAnnotationPresent(Remotable.class)) {
                throw new InvalidCallbackException("Callback " + callbackClass.getName() + " must be remotable on remotable interface " + clazz.getName());
            }
            if (!remotable && callbackClass.isAnnotationPresent(Remotable.class)) {
                throw new InvalidCallbackException("Callback" + callbackClass.getName() + " must not be remotable on local interface " + clazz.getName());
            }
        } else if (callback != null && Void.class.equals(callback.value())) {
            throw new InvalidCallbackException("No callback interface specified on callback annotation in " + clazz.getName());
        }
        javaInterface.setCallbackClass(callbackClass);
        String ns = JavaXMLMapper.getNamespace(clazz);
        javaInterface.getOperations().addAll(this.getOperations(clazz, remotable, ns));
        for (JavaInterfaceVisitor extension : this.visitors) {
            extension.visitInterface(javaInterface);
        }
        Set<Method> methods = JavaIntrospectionHelper.getMethods(clazz);
        for (Method method : methods) {
            this.checkMethodAnnotations(method, javaInterface);
        }
    }

    private void checkMethodAnnotations(Method method, JavaInterface javaInterface) throws InvalidAnnotationException {
        for (Annotation a : method.getAnnotations()) {
            if (!(a instanceof Remotable) || JavaIntrospectionHelper.isSetter(method)) continue;
            throw new InvalidAnnotationException("[JCA90053] @Remotable annotation present on an interface method which is not a Setter method: " + javaInterface.getName() + "/" + method.getName(), Remotable.class);
        }
        Annotation[] arr$ = method.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation parmAnnotations;
            for (Annotation annotation : parmAnnotations = arr$[i$]) {
                if (!(annotation instanceof Remotable)) continue;
                throw new InvalidAnnotationException("[JCA90053] @Remotable annotation present on an interface method parameter: " + javaInterface.getName() + "/" + method.getName(), Remotable.class);
            }
        }
        method.getParameterAnnotations();
    }

    private Class<?>[] getActualTypes(Type[] types, Class<?>[] rawTypes, Map<String, Type> typeBindings) {
        Class[] actualTypes = new Class[types.length];
        for (int i = 0; i < actualTypes.length; ++i) {
            actualTypes[i] = this.getActualType(types[i], rawTypes[i], typeBindings);
        }
        return actualTypes;
    }

    private Class<?> getActualType(Type type, Class<?> rawType, Map<String, Type> typeBindings) {
        TypeVariable typeVariable;
        if (type instanceof TypeVariable && (type = typeBindings.get((typeVariable = (TypeVariable)type).getName())) instanceof Class) {
            return (Class)type;
        }
        return rawType;
    }

    private <T> List<Operation> getOperations(Class<T> clazz, boolean remotable, String ns) throws InvalidInterfaceException {
        HashSet<Type> genericInterfaces = new HashSet<Type>();
        for (Type t : clazz.getGenericInterfaces()) {
            genericInterfaces.add(t);
        }
        HashMap<String, Type> typeBindings = new HashMap<String, Type>();
        for (Type genericInterface : genericInterfaces) {
            if (!(genericInterface instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
            TypeVariable<Class<T>>[] typeVariables = ((Class)parameterizedType.getRawType()).getTypeParameters();
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeArguments.length; ++i) {
                typeBindings.put(typeVariables[i].getName(), typeArguments[i]);
            }
        }
        Method[] methods = clazz.getMethods();
        ArrayList<Operation> operations = new ArrayList<Operation>(methods.length);
        HashSet<String> names = remotable ? new HashSet<String>() : null;
        for (Method method : methods) {
            boolean nonBlocking;
            boolean hasMultipleOutputs = false;
            if (method.getDeclaringClass() == Object.class) continue;
            String name = method.getName();
            if (remotable && names.contains(name)) {
                throw new OverloadedOperationException(method);
            }
            if (remotable && !this.jaxwsAsyncMethod(method)) {
                names.add(name);
            }
            Class<?> returnType = this.getActualType(method.getGenericReturnType(), method.getReturnType(), typeBindings);
            Class<?>[] parameterTypes = this.getActualTypes(method.getGenericParameterTypes(), method.getParameterTypes(), typeBindings);
            Class<?>[] faultTypes = this.getActualTypes(method.getGenericExceptionTypes(), method.getExceptionTypes(), typeBindings);
            Class<?>[] allOutputTypes = this.getOutputTypes(returnType, parameterTypes);
            if (method.isAnnotationPresent(AsyncFault.class)) {
                faultTypes = this.readAsyncFaultTypes(method);
            }
            if (nonBlocking = method.isAnnotationPresent(OneWay.class)) {
                if (returnType != Void.TYPE) {
                    throw new InvalidOperationException("Method should return 'void' when declared with an @OneWay annotation. " + method, method);
                }
                if (faultTypes.length != 0) {
                    throw new InvalidOperationException("Method should not declare exceptions with an @OneWay annotation. " + method, method);
                }
            }
            JavaOperationImpl operation = new JavaOperationImpl();
            operation.setName(name);
            ArrayList<DataTypeImpl<XMLType>> outputDataTypes = new ArrayList<DataTypeImpl<XMLType>>();
            XMLType xmlReturnType = new XMLType(new QName(ns, "return"), null);
            DataTypeImpl<XMLType> returnDataType = null;
            if (returnType == Void.TYPE) {
                operation.setReturnTypeVoid(true);
            } else {
                returnDataType = new DataTypeImpl<XMLType>(UNKNOWN_DATABINDING, returnType, method.getGenericReturnType(), xmlReturnType);
                operation.setReturnTypeVoid(false);
                outputDataTypes.add(returnDataType);
            }
            ArrayList<DataTypeImpl<XMLType>> paramDataTypes = new ArrayList<DataTypeImpl<XMLType>>(parameterTypes.length);
            Type[] genericParamTypes = method.getGenericParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> paramType = parameterTypes[i];
                XMLType xmlParamType = new XMLType(new QName(ns, "arg" + i), null);
                DataTypeImpl<XMLType> xmlDataType = new DataTypeImpl<XMLType>(UNKNOWN_DATABINDING, paramType, genericParamTypes[i], xmlParamType);
                ParameterMode mode = ParameterMode.IN;
                if (Holder.class == paramType) {
                    hasMultipleOutputs = true;
                    Type firstActual = JavaInterfaceIntrospectorImpl.getFirstActualType(genericParamTypes[i]);
                    if (firstActual != null) {
                        xmlDataType.setPhysical((Class)firstActual);
                        mode = ParameterMode.INOUT;
                    }
                    outputDataTypes.add(xmlDataType);
                }
                paramDataTypes.add(xmlDataType);
                operation.getParameterModes().add(mode);
            }
            ArrayList<DataType> faultDataTypes = new ArrayList<DataType>(faultTypes.length);
            Type[] genericFaultTypes = method.getGenericExceptionTypes();
            if (method.isAnnotationPresent(AsyncFault.class)) {
                genericFaultTypes = this.readAsyncGenericFaultTypes(method);
            }
            for (int i = 0; i < faultTypes.length; ++i) {
                Class<?> faultType = faultTypes[i];
                if (!Exception.class.isAssignableFrom(faultType) || RuntimeException.class.isAssignableFrom(faultType) || RemoteException.class.isAssignableFrom(faultType)) continue;
                XMLType xmlFaultType = new XMLType(new QName(ns, faultType.getSimpleName()), null);
                DataTypeImpl<XMLType> faultDataType = new DataTypeImpl<XMLType>(UNKNOWN_DATABINDING, faultType, genericFaultTypes[i], xmlFaultType);
                faultDataTypes.add(new DataTypeImpl<DataTypeImpl<XMLType>>(UNKNOWN_DATABINDING, faultType, genericFaultTypes[i], faultDataType));
            }
            DataTypeImpl<List<DataType>> inputType = new DataTypeImpl<List<DataType>>("idl:input", Object[].class, paramDataTypes);
            DataTypeImpl<List<DataType>> outputType = new DataTypeImpl<List<DataType>>("idl:output", Object[].class, outputDataTypes);
            operation.setOutputType(outputType);
            operation.setInputType(inputType);
            operation.setFaultTypes(faultDataTypes);
            operation.setNonBlocking(nonBlocking);
            operation.setJavaMethod(method);
            operation.setHasArrayWrappedOutput(hasMultipleOutputs);
            operations.add(operation);
        }
        return operations;
    }

    private Class<?>[] getOutputTypes(Class<?> returnType, Class<?>[] parameterTypes) {
        ArrayList returnTypes = new ArrayList();
        returnTypes.add(returnType);
        for (Class<?> clazz : parameterTypes) {
            if (Holder.class != clazz) continue;
            returnTypes.add(clazz);
        }
        Class[] arrayType = new Class[]{};
        return returnTypes.toArray(arrayType);
    }

    private Class<?>[] readAsyncFaultTypes(Method method) {
        AsyncFault theFaults = method.getAnnotation(AsyncFault.class);
        if (theFaults == null) {
            return null;
        }
        return theFaults.value();
    }

    private Type[] readAsyncGenericFaultTypes(Method method) {
        AsyncFault theFaults = method.getAnnotation(AsyncFault.class);
        if (theFaults == null) {
            return null;
        }
        return theFaults.value();
    }

    private boolean jaxwsAsyncMethod(Method method) {
        if (method.getName().endsWith("Async")) {
            if (method.getReturnType().isAssignableFrom(Future.class) && method.getParameterTypes().length > 0 && method.getParameterTypes()[method.getParameterTypes().length - 1].isAssignableFrom(AsyncHandler.class)) {
                return true;
            }
            if (method.getReturnType().isAssignableFrom(Response.class)) {
                return true;
            }
        }
        return false;
    }

    protected static Type getFirstActualType(Type genericType) {
        ParameterizedType pType;
        Type[] actualTypes;
        if (genericType instanceof ParameterizedType && (actualTypes = (pType = (ParameterizedType)genericType).getActualTypeArguments()) != null && actualTypes.length > 0) {
            return actualTypes[0];
        }
        return null;
    }
}

