/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.widget.impl;

import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.impl.ImplementationImpl;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.implementation.widget.Widget;
import org.apache.tuscany.sca.implementation.widget.WidgetImplementation;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;

public class WidgetImplementationImpl
extends ImplementationImpl
implements WidgetImplementation {
    private Service widgetService;
    private String location;
    private URL locationUrl;

    WidgetImplementationImpl(ExtensionPointRegistry registry) {
        super(TYPE);
        JavaInterface javaInterface;
        FactoryExtensionPoint modelFactories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        AssemblyFactory assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        JavaInterfaceFactory javaFactory = modelFactories.getFactory(JavaInterfaceFactory.class);
        this.widgetService = assemblyFactory.createService();
        this.widgetService.setName("Widget");
        try {
            javaInterface = javaFactory.createJavaInterface(Widget.class);
        }
        catch (InvalidInterfaceException e) {
            throw new IllegalArgumentException(e);
        }
        JavaInterfaceContract interfaceContract = javaFactory.createJavaInterfaceContract();
        interfaceContract.setInterface(javaInterface);
        this.widgetService.setInterfaceContract(interfaceContract);
        this.getServices().add(this.widgetService);
    }

    @Override
    public QName getType() {
        return TYPE;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public URL getLocationURL() {
        return this.locationUrl;
    }

    @Override
    public void setLocationURL(URL url) {
        this.locationUrl = url;
    }

    @Override
    public String toString() {
        return "Widget : " + this.getLocation();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof WidgetImplementationImpl)) {
            return false;
        }
        WidgetImplementationImpl other = (WidgetImplementationImpl)obj;
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }
}

