/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.widget;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.implementation.widget.WidgetImplementation;
import org.apache.tuscany.sca.implementation.widget.WidgetImplementationFactory;
import org.apache.tuscany.sca.implementation.widget.WidgetImplementationIntrospector;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class WidgetImplementationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<WidgetImplementation> {
    private ExtensionPointRegistry registry;
    private ContributionFactory contributionFactory;
    private WidgetImplementationFactory implementationFactory;

    public WidgetImplementationProcessor(ExtensionPointRegistry registry) {
        this.registry = registry;
        FactoryExtensionPoint modelFactories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.contributionFactory = modelFactories.getFactory(ContributionFactory.class);
        this.implementationFactory = modelFactories.getFactory(WidgetImplementationFactory.class);
    }

    @Override
    public QName getArtifactType() {
        return WidgetImplementation.TYPE;
    }

    @Override
    public Class<WidgetImplementation> getModelType() {
        return WidgetImplementation.class;
    }

    @Override
    public WidgetImplementation read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        WidgetImplementation implementation = null;
        String location = this.getURIString(reader, "location");
        if (location != null) {
            implementation = this.implementationFactory.createWidgetImplementation();
            implementation.setLocation(location);
            implementation.setUnresolved(true);
        } else {
            this.error(context.getMonitor(), "LocationAttributeMissing", (Object)reader, new Object[0]);
        }
        while (reader.hasNext() && (reader.next() != 2 || !WidgetImplementation.TYPE.equals(reader.getName()))) {
        }
        return implementation;
    }

    @Override
    public void resolve(WidgetImplementation implementation, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (implementation != null) {
            Artifact artifact = this.contributionFactory.createArtifact();
            artifact.setURI(implementation.getLocation());
            Artifact resolved = resolver.resolveModel(Artifact.class, artifact, context);
            if (resolved.getLocation() == null) {
                URI base;
                URL resource = null;
                URI uri = URI.create(implementation.getLocation());
                Artifact parent = context.getArtifact();
                if (!uri.isAbsolute() && parent != null && parent.getURI() != null && (uri = (base = URI.create("/" + parent.getURI())).resolve(uri)).toString().startsWith("/")) {
                    uri = URI.create(uri.toString().substring(1));
                }
                if (parent != null && parent.getLocation() != null) {
                    try {
                        resource = new URL(new URL(parent.getLocation()), implementation.getLocation());
                        implementation.setLocationURL(resource);
                    }
                    catch (MalformedURLException e) {
                        ContributionResolveException ce = new ContributionResolveException(e);
                        this.error(context.getMonitor(), "ContributionResolveException", (Object)resolver, ce);
                    }
                }
            } else {
                try {
                    implementation.setLocationURL(new URL(resolved.getLocation()));
                }
                catch (MalformedURLException e) {
                    ContributionResolveException ce = new ContributionResolveException(e);
                    this.error(context.getMonitor(), "ContributionResolveException", (Object)resolver, ce);
                }
            }
            WidgetImplementationIntrospector widgetIntrospector = new WidgetImplementationIntrospector(this.registry, implementation);
            widgetIntrospector.introspectImplementation();
            implementation.setUnresolved(false);
            if (implementation.isUnresolved()) {
                this.error(context.getMonitor(), "CouldNotResolveLocation", (Object)resolver, implementation.getLocation());
            }
        }
    }

    @Override
    public void write(WidgetImplementation implementation, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        this.writeStart(writer, WidgetImplementation.TYPE.getNamespaceURI(), WidgetImplementation.TYPE.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
        if (implementation.getLocation() != null) {
            writer.writeAttribute("location", implementation.getLocation());
        }
        this.writeEnd(writer);
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "impl-widget-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "impl-widget-validation-messages", Problem.Severity.ERROR, model, message, ex);
            monitor.problem(problem);
        }
    }
}

