/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.web.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.impl.ImplementationImpl;
import org.apache.tuscany.sca.implementation.web.WebImplementation;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

class WebImplementationImpl
extends ImplementationImpl
implements WebImplementation {
    private List<Property> properties = new ArrayList<Property>();
    private List<Reference> references = new ArrayList<Reference>();
    private String webURI;
    private boolean jsClient = true;

    WebImplementationImpl() {
        super(TYPE);
    }

    @Override
    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public List<Service> getServices() {
        return Collections.emptyList();
    }

    @Override
    public List<Reference> getReferences() {
        return this.references;
    }

    @Override
    public String getWebURI() {
        return this.webURI;
    }

    @Override
    public void setWebURI(String webURI) {
        this.webURI = webURI;
    }

    public void build(Component component) {
        if (!(component instanceof RuntimeComponent)) {
            return;
        }
        RuntimeComponent rtc = (RuntimeComponent)component;
        for (ComponentReference reference : rtc.getReferences()) {
            if (this.getReference(reference.getName()) != null) continue;
            this.getReferences().add(this.createReference(reference));
        }
        for (ComponentProperty property : rtc.getProperties()) {
            if (this.getProperty(property.getName()) != null) continue;
            this.getProperties().add(this.createProperty(property));
        }
    }

    protected Reference createReference(Reference reference) {
        Reference newReference;
        try {
            newReference = (Reference)reference.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        return newReference;
    }

    protected Property createProperty(Property property) {
        Property newProperty;
        try {
            newProperty = (Property)property.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        return newProperty;
    }

    @Override
    public boolean getJSClient() {
        return this.jsClient;
    }

    @Override
    public void setJSClient(boolean jsClient) {
        this.jsClient = jsClient;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.webURI == null ? 0 : this.webURI.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof WebImplementationImpl)) {
            return false;
        }
        WebImplementationImpl other = (WebImplementationImpl)obj;
        return !(this.webURI == null ? other.webURI != null : !this.webURI.equals(other.webURI));
    }
}

