/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.xml.PolicySubjectProcessor;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.implementation.spring.SpringImplementation;
import org.apache.tuscany.sca.implementation.spring.introspect.SpringXMLComponentTypeLoader;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class SpringImplementationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<SpringImplementation> {
    private static final String LOCATION = "location";
    private static final String IMPLEMENTATION_SPRING = "implementation.spring";
    private static final QName IMPLEMENTATION_SPRING_QNAME = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "implementation.spring");
    private static final String MSG_LOCATION_MISSING = "Reading implementation.spring - location attribute missing";
    private ExtensionPointRegistry registry;
    private AssemblyFactory assemblyFactory;
    private PolicySubjectProcessor policyProcessor;
    private FactoryExtensionPoint factories;

    public SpringImplementationProcessor(ExtensionPointRegistry registry) {
        this.registry = registry;
        this.factories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = this.factories.getFactory(AssemblyFactory.class);
        this.policyProcessor = new PolicySubjectProcessor(registry);
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "impl-spring-validation-messages", Problem.Severity.ERROR, model, message, ex);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "impl-spring-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    @Override
    public SpringImplementation read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        SpringImplementation springImplementation = null;
        String springLocation = this.getURIString(reader, LOCATION);
        if (springLocation != null) {
            springImplementation = new SpringImplementation();
            springImplementation.setLocation(springLocation);
            springImplementation.setUnresolved(true);
            this.processComponentType(springImplementation);
        } else {
            this.error(context.getMonitor(), "LocationAttributeMissing", (Object)reader, new Object[0]);
        }
        this.policyProcessor.readPolicies(springImplementation, reader);
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_SPRING_QNAME.equals(reader.getName()))) {
        }
        return springImplementation;
    }

    private void processComponentType(SpringImplementation springImplementation) {
        ComponentType componentType = this.assemblyFactory.createComponentType();
        componentType.setUnresolved(true);
        springImplementation.setComponentType(componentType);
    }

    @Override
    public void write(SpringImplementation springImplementation, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", IMPLEMENTATION_SPRING);
        this.policyProcessor.writePolicyAttributes(springImplementation, writer);
        if (springImplementation.getLocation() != null) {
            writer.writeAttribute(LOCATION, springImplementation.getLocation());
        }
        writer.writeEndElement();
    }

    @Override
    public void resolve(SpringImplementation springImplementation, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (springImplementation == null) {
            return;
        }
        Monitor monitor = context.getMonitor();
        SpringXMLComponentTypeLoader springLoader = new SpringXMLComponentTypeLoader(this.registry);
        try {
            springLoader.load(springImplementation, resolver, context);
        }
        catch (ContributionReadException e) {
            ContributionResolveException ce = new ContributionResolveException(e);
            this.error(monitor, "ContributionResolveException", (Object)resolver, ce);
            throw ce;
        }
        ComponentType ct = springImplementation.getComponentType();
        if (ct.isUnresolved()) {
            ComponentType componentType = resolver.resolveModel(ComponentType.class, ct, context);
            if (componentType.isUnresolved()) {
                this.error(monitor, "UnableToResolveComponentType", (Object)resolver, new Object[0]);
            } else {
                springImplementation.setComponentType(componentType);
                springImplementation.setUnresolved(false);
            }
        }
    }

    @Override
    public QName getArtifactType() {
        return IMPLEMENTATION_SPRING_QNAME;
    }

    @Override
    public Class<SpringImplementation> getModelType() {
        return SpringImplementation.class;
    }
}

