/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring.introspect;

import java.util.List;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaImplementationFactory;
import org.apache.tuscany.sca.implementation.spring.SpringConstructorArgElement;
import org.apache.tuscany.sca.implementation.spring.SpringImplementation;

public class SpringBeanIntrospector {
    private JavaImplementationFactory javaImplementationFactory;

    public SpringBeanIntrospector(ExtensionPointRegistry registry, List<SpringConstructorArgElement> conArgs) {
        FactoryExtensionPoint factories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.javaImplementationFactory = factories.getFactory(JavaImplementationFactory.class);
    }

    public JavaImplementation introspectBean(Class<?> beanClass, ComponentType componentType) throws ContributionResolveException {
        if (componentType == null) {
            throw new ContributionResolveException("Introspect Spring bean: supplied componentType is null");
        }
        JavaImplementation javaImplementation = this.javaImplementationFactory.createJavaImplementation();
        javaImplementation.setType(SpringImplementation.TYPE);
        try {
            this.javaImplementationFactory.createJavaImplementation(javaImplementation, beanClass);
            componentType.getServices().addAll(javaImplementation.getServices());
            componentType.getReferences().addAll(javaImplementation.getReferences());
            componentType.getProperties().addAll(javaImplementation.getProperties());
        }
        catch (IntrospectionException e) {
            throw new ContributionResolveException(e);
        }
        return javaImplementation;
    }
}

