/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.xml.ws.Holder;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.ScopeContainer;
import org.apache.tuscany.sca.core.scope.ScopedRuntimeComponent;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.context.ReflectiveInstanceWrapper;
import org.apache.tuscany.sca.implementation.java.injection.Injector;
import org.apache.tuscany.sca.implementation.java.introspect.JavaIntrospectionHelper;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.ParameterMode;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class JavaImplementationInvoker
implements Invoker,
DataExchangeSemantics {
    protected Operation operation;
    protected Method method;
    protected boolean allowsPBR;
    protected final ScopeContainer scopeContainer;
    private final InterfaceContract interfaze;

    public JavaImplementationInvoker(Operation operation, Method method, RuntimeComponent component, InterfaceContract intf) {
        assert (method != null) : "Operation method cannot be null";
        this.method = method;
        this.operation = operation;
        this.scopeContainer = ((ScopedRuntimeComponent)component).getScopeContainer();
        this.allowsPBR = ((JavaImplementation)component.getImplementation()).isAllowsPassByReference(method);
        this.interfaze = intf;
    }

    public JavaImplementationInvoker(Operation operation, RuntimeComponent component, InterfaceContract intf) {
        this.operation = operation;
        this.scopeContainer = ((ScopedRuntimeComponent)component).getScopeContainer();
        this.interfaze = intf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message invoke(Message msg) {
        Operation op = msg.getOperation();
        if (op == null) {
            op = this.operation;
        }
        Object payload = msg.getBody();
        Object contextId = null;
        EndpointReference from = msg.getFrom();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            ReflectiveInstanceWrapper wrapper = (ReflectiveInstanceWrapper)this.scopeContainer.getWrapper(contextId);
            if (this.interfaze.getCallbackInterface() != null && this.scopeContainer.getScope().equals(Scope.STATELESS)) {
                this.injectCallbacks(wrapper, (JavaInterface)this.interfaze.getCallbackInterface());
            }
            Object instance = wrapper.getInstance();
            Method imethod = this.method;
            if (imethod == null || !imethod.getDeclaringClass().isInstance(instance)) {
                try {
                    imethod = JavaInterfaceUtil.findMethod(instance.getClass(), this.operation);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Callback object does not provide method " + e.getMessage());
                }
            }
            Thread.currentThread().setContextClassLoader(instance.getClass().getClassLoader());
            int argumentHolderCount = 0;
            if (imethod != null && op.getInterface().isRemotable()) {
                Object[] payloadArray = (Object[])payload;
                ArrayList<Object> payloadList = new ArrayList<Object>();
                int nextIndex = 0;
                for (ParameterMode mode : op.getParameterModes()) {
                    if (mode.equals((Object)ParameterMode.IN)) {
                        payloadList.add(payloadArray[nextIndex++]);
                        continue;
                    }
                    if (mode.equals((Object)ParameterMode.INOUT)) {
                        Object item = payloadArray[nextIndex++];
                        Holder itemHolder = new Holder(item);
                        payloadList.add(itemHolder);
                        ++argumentHolderCount;
                        continue;
                    }
                    payloadList.add(new Holder());
                    ++argumentHolderCount;
                }
                payload = payloadList.toArray();
            }
            Object ret = payload != null && !payload.getClass().isArray() ? imethod.invoke(instance, payload) : imethod.invoke(instance, (Object[])payload);
            this.scopeContainer.returnWrapper(wrapper, contextId);
            if (argumentHolderCount > 0) {
                Object[] payloadArray = (Object[])payload;
                ArrayList<Object> holderOutputs = new ArrayList<Object>();
                ArrayList<Object> result = new ArrayList<Object>();
                if (imethod != null) {
                    int numberOperationOutputs;
                    int size = op.getParameterModes().size();
                    for (int i = 0; i < size; ++i) {
                        if (ParameterMode.IN == op.getParameterModes().get(i)) continue;
                        Holder item = (Holder)payloadArray[i];
                        payloadArray[i] = item.value;
                        holderOutputs.add(payloadArray[i]);
                    }
                    int holderOutputSize = holderOutputs.size();
                    if (holderOutputSize == (numberOperationOutputs = op.getOutputType().getLogical().size())) {
                        if (ret != null) {
                            throw new IllegalStateException("Number of holder outputs equal to number of operations outputs.\nNum = " + holderOutputSize + ", but non-null return value seen: " + ret);
                        }
                        result = holderOutputs;
                    } else if (holderOutputSize == numberOperationOutputs - 1) {
                        result.add(ret);
                        result.addAll(1, holderOutputs);
                    } else {
                        throw new IllegalStateException("Number of holder outputs seen: " + holderOutputSize + "\nNumber of operation outputs: " + numberOperationOutputs);
                    }
                }
                msg.setBody(result.toArray());
            } else {
                msg.setBody(ret);
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            boolean isChecked = false;
            for (DataType d : this.operation.getFaultTypes()) {
                if (!d.getPhysical().isInstance(cause)) continue;
                isChecked = true;
                msg.setFaultBody(cause);
                break;
            }
            if (!isChecked) {
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new ServiceRuntimeException(cause.getMessage(), cause);
            }
        }
        catch (ObjectCreationException e) {
            throw new ServiceRuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            msg.setFaultBody(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        return msg;
    }

    private void injectCallbacks(ReflectiveInstanceWrapper wrapper, JavaInterface callbackInterface) {
        for (Injector injector : wrapper.getCallbackInjectors()) {
            if (injector == null) continue;
            try {
                if (ServiceReference.class.isAssignableFrom(injector.getType())) {
                    Class<?> intf = JavaIntrospectionHelper.getBusinessInterface(injector.getType(), injector.getGenericType());
                    if (!intf.isAssignableFrom(callbackInterface.getJavaClass())) continue;
                    injector.inject(wrapper.getInstance());
                    continue;
                }
                if (injector.getType().isAssignableFrom(callbackInterface.getJavaClass())) {
                    injector.inject(wrapper.getInstance());
                    continue;
                }
                injector.injectNull(wrapper.getInstance());
            }
            catch (Exception e) {
                throw new ObjectCreationException("Exception invoking injector - " + e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean allowsPassByReference() {
        return this.allowsPBR;
    }
}

