/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.invocation;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.invocation.CallbackInterfaceInterceptor;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessor;

public class JavaCallbackRuntimeWireProcessor
implements RuntimeWireProcessor {
    private static final Logger logger = Logger.getLogger(JavaCallbackRuntimeWireProcessor.class.getName());
    private InterfaceContractMapper interfaceContractMapper;
    private JavaInterfaceFactory javaInterfaceFactory;

    public JavaCallbackRuntimeWireProcessor(ExtensionPointRegistry registry) {
        FactoryExtensionPoint factories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.javaInterfaceFactory = factories.getFactory(JavaInterfaceFactory.class);
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.interfaceContractMapper = utilities.getUtility(InterfaceContractMapper.class);
    }

    protected JavaCallbackRuntimeWireProcessor(InterfaceContractMapper interfaceContractMapper, JavaInterfaceFactory javaInterfaceFactory) {
        this.interfaceContractMapper = interfaceContractMapper;
        this.javaInterfaceFactory = javaInterfaceFactory;
    }

    private boolean supportsCallbackInterface(Interface iface, JavaImplementation impl) {
        Class<?> ifaceClass;
        if (iface instanceof JavaInterface && (ifaceClass = ((JavaInterface)iface).getJavaClass()).isAssignableFrom(impl.getJavaClass())) {
            return true;
        }
        try {
            JavaInterface implType = this.javaInterfaceFactory.createJavaInterface(impl.getJavaClass());
            implType.setRemotable(iface.isRemotable());
            return this.interfaceContractMapper.isCompatibleSubset(iface, implType);
        }
        catch (InvalidInterfaceException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return false;
        }
    }

    @Override
    public void process(RuntimeEndpoint endpoint) {
    }

    @Override
    public void process(RuntimeEndpointReference endpointReference) {
        Interface iface;
        if (!(endpointReference instanceof RuntimeEndpointReference)) {
            return;
        }
        RuntimeEndpointReference epr = endpointReference;
        ComponentReference contract = epr.getReference();
        if (!(contract instanceof RuntimeComponentReference)) {
            return;
        }
        RuntimeComponent component = (RuntimeComponent)epr.getComponent();
        if (component == null) {
            return;
        }
        Implementation implementation = component.getImplementation();
        if (!(implementation instanceof JavaImplementation)) {
            return;
        }
        JavaImplementation javaImpl = (JavaImplementation)implementation;
        Endpoint callbackEndpoint = epr.getCallbackEndpoint();
        if (callbackEndpoint != null && !this.supportsCallbackInterface(iface = callbackEndpoint.getService().getInterfaceContract().getInterface(), javaImpl)) {
            for (InvocationChain chain : epr.getInvocationChains()) {
                chain.addInterceptor("component.reference", new CallbackInterfaceInterceptor());
            }
        }
    }
}

