/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.BindingType;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceProvider;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBindingFactory;
import org.apache.tuscany.sca.binding.ws.xml.WebServiceConstants;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.introspect.BaseJavaClassVisitor;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.oasisopen.sca.annotation.Service;

public class JAXWSProcessor
extends BaseJavaClassVisitor {
    private PolicyFactory policyFactory;
    private WSDLFactory wsdlFactory;
    private WebServiceBindingFactory wsBindingFactory;

    public JAXWSProcessor(ExtensionPointRegistry registry) {
        super(registry);
        FactoryExtensionPoint factories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.wsdlFactory = factories.getFactory(WSDLFactory.class);
        this.assemblyFactory = factories.getFactory(AssemblyFactory.class);
        this.policyFactory = factories.getFactory(PolicyFactory.class);
        this.javaInterfaceFactory = factories.getFactory(JavaInterfaceFactory.class);
        this.wsBindingFactory = factories.getFactory(WebServiceBindingFactory.class);
    }

    @Override
    public <T> void visitClass(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
        BindingType bindingType;
        WebServiceProvider webServiceProviderAnnotation;
        String wsdlLocation;
        boolean hasJaxwsAnnotation = false;
        if (clazz.getAnnotation(ServiceMode.class) != null) {
            this.addSOAPIntent(type);
            hasJaxwsAnnotation = true;
        }
        WebService webServiceAnnotation = clazz.getAnnotation(WebService.class);
        Service serviceAnnotation = clazz.getAnnotation(Service.class);
        if (webServiceAnnotation != null && serviceAnnotation == null) {
            String serviceName = clazz.getSimpleName();
            serviceName = JAXWSProcessor.getValue(webServiceAnnotation.name(), serviceName);
            String serviceInterfaceClassName = webServiceAnnotation.endpointInterface();
            wsdlLocation = webServiceAnnotation.wsdlLocation();
            try {
                this.createService(type, clazz, serviceName, serviceInterfaceClassName, wsdlLocation, false);
            }
            catch (InvalidInterfaceException e) {
                throw new IntrospectionException(e);
            }
            hasJaxwsAnnotation = true;
        }
        if ((webServiceProviderAnnotation = clazz.getAnnotation(WebServiceProvider.class)) != null) {
            String serviceName = clazz.getSimpleName();
            if (type.getServices().size() > 0) {
                serviceName = type.getServices().get(0).getName();
            }
            serviceName = JAXWSProcessor.getValue(webServiceProviderAnnotation.serviceName(), serviceName);
            wsdlLocation = webServiceProviderAnnotation.wsdlLocation();
            try {
                this.createService(type, clazz, serviceName, null, wsdlLocation, true);
            }
            catch (InvalidInterfaceException e) {
                throw new IntrospectionException(e);
            }
            for (org.apache.tuscany.sca.assembly.Service service : type.getServices()) {
                service.getInterfaceContract().getInterface().setRemotable(true);
            }
            hasJaxwsAnnotation = true;
        }
        Class<Object> interfaze = clazz;
        Method[] implMethods = interfaze.getDeclaredMethods();
        for (org.apache.tuscany.sca.assembly.Service service : type.getServices()) {
            JavaInterface javaInterface = (JavaInterface)service.getInterfaceContract().getInterface();
            interfaze = javaInterface.getJavaClass();
            if (interfaze == null) {
                interfaze = clazz;
            }
            boolean hasHeaderParam = false;
            block6: for (Method method : interfaze.getDeclaredMethods()) {
                for (int i = 0; i < implMethods.length; ++i) {
                    WebResult webResultAnnotation;
                    Method implMethod = implMethods[i];
                    if (!implMethod.getName().equals(method.getName())) continue;
                    for (int j = 0; j < implMethod.getParameterTypes().length; ++j) {
                        WebParam webParamAnnotation = this.getParameterAnnotation(implMethod, j, WebParam.class);
                        if (webParamAnnotation == null || !webParamAnnotation.header()) continue;
                        hasHeaderParam = true;
                        break;
                    }
                    if ((webResultAnnotation = implMethod.getAnnotation(WebResult.class)) == null || !webResultAnnotation.header()) continue;
                    hasHeaderParam = true;
                    continue block6;
                }
            }
            if (!hasHeaderParam) continue;
            this.addSOAPIntent(service);
            hasJaxwsAnnotation = true;
        }
        if (clazz.getAnnotation(SOAPBinding.class) != null) {
            for (org.apache.tuscany.sca.assembly.Service service : type.getServices()) {
                this.addSOAPIntent(service);
            }
            hasJaxwsAnnotation = true;
        }
        if ((bindingType = clazz.getAnnotation(BindingType.class)) != null) {
            String bindingTypeValue = bindingType.value();
            for (org.apache.tuscany.sca.assembly.Service service : type.getServices()) {
                this.addBindingTypeIntent(service, bindingTypeValue);
            }
            hasJaxwsAnnotation = true;
        }
        if (hasJaxwsAnnotation) {
            for (org.apache.tuscany.sca.assembly.Service service : type.getServices()) {
                service.setJAXWSService(true);
                this.createWSBinding(type, service);
            }
        }
    }

    private void addBindingTypeIntent(PolicySubject subject, String bindingTypeValue) {
        Intent soapIntent = this.policyFactory.createIntent();
        if ("http://schemas.xmlsoap.org/wsdl/soap/http".equals(bindingTypeValue)) {
            soapIntent.setName(Constants.SOAP11_INTENT);
        } else if ("http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(bindingTypeValue)) {
            soapIntent.setName(Constants.SOAP12_INTENT);
        } else {
            soapIntent.setName(Constants.SOAP11_INTENT);
        }
        subject.getRequiredIntents().add(soapIntent);
    }

    private static String getValue(String value, String defaultValue) {
        return "".equals(value) ? defaultValue : value;
    }

    private org.apache.tuscany.sca.assembly.Service createService(JavaImplementation type, Class<?> clazz, String serviceName, String javaInterfaceName, String wsdlFileName, boolean replace) throws InvalidInterfaceException, IntrospectionException {
        Interface callInterface;
        org.apache.tuscany.sca.assembly.Service service = this.assemblyFactory.createService();
        if (serviceName != null) {
            service.setName(serviceName);
        } else if (javaInterfaceName != null) {
            service.setName(javaInterfaceName.substring(javaInterfaceName.lastIndexOf(46)));
        }
        JavaInterfaceContract javaInterfaceContract = this.javaInterfaceFactory.createJavaInterfaceContract();
        service.setInterfaceContract(javaInterfaceContract);
        if (javaInterfaceName != null && javaInterfaceName.length() > 0) {
            callInterface = this.javaInterfaceFactory.createJavaInterface();
            callInterface.setName(javaInterfaceName);
            callInterface.setRemotable(true);
            callInterface.setUnresolved(true);
            javaInterfaceContract.setInterface(callInterface);
        } else {
            callInterface = this.javaInterfaceFactory.createJavaInterface(clazz);
            callInterface.setRemotable(true);
            callInterface.setUnresolved(false);
            javaInterfaceContract.setInterface(callInterface);
        }
        if (wsdlFileName != null && wsdlFileName.length() > 0) {
            callInterface = this.wsdlFactory.createWSDLInterface();
            callInterface.setUnresolved(true);
            callInterface.setRemotable(true);
            WSDLInterfaceContract wsdlInterfaceContract = this.wsdlFactory.createWSDLInterfaceContract();
            wsdlInterfaceContract.setInterface(callInterface);
            wsdlInterfaceContract.setLocation(wsdlFileName);
            javaInterfaceContract.setNormailizedWSDLContract(wsdlInterfaceContract);
        }
        org.apache.tuscany.sca.assembly.Service serviceAlreadyPresent = null;
        for (org.apache.tuscany.sca.assembly.Service typeService : type.getServices()) {
            if (!typeService.getName().equals(service.getName())) continue;
            serviceAlreadyPresent = typeService;
            break;
        }
        if (replace) {
            type.getServices().remove(serviceAlreadyPresent);
            type.getServices().add(service);
        } else if (serviceAlreadyPresent == null) {
            type.getServices().add(service);
        }
        return service;
    }

    private <T extends Annotation> T getParameterAnnotation(Method method, int index, Class<T> annotationType) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getParameterAnnotations()[index]) {
            if (annotation.annotationType() != annotationType) continue;
            return (T)((Annotation)annotationType.cast(annotation));
        }
        return null;
    }

    private void addSOAPIntent(PolicySubject policySubject) {
        Intent soapIntent = this.policyFactory.createIntent();
        soapIntent.setName(Constants.SOAP_INTENT);
        policySubject.getRequiredIntents().add(soapIntent);
    }

    private void createWSBinding(JavaImplementation javaImplementation, org.apache.tuscany.sca.assembly.Service service) {
        if (service.getBindings().size() == 0) {
            WebServiceBinding wsBinding = this.wsBindingFactory.createWebServiceBinding();
            wsBinding.setName(service.getName());
            org.apache.tuscany.sca.policy.BindingType bindingType = this.policyFactory.createBindingType();
            bindingType.setType(WebServiceConstants.BINDING_WS_QNAME);
            bindingType.setUnresolved(true);
            ((PolicySubject)((Object)wsBinding)).setExtensionType(bindingType);
            service.getBindings().add(wsBinding);
        }
    }
}

