/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaResourceImpl;
import org.apache.tuscany.sca.implementation.java.introspect.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.JavaIntrospectionHelper;
import org.apache.tuscany.sca.implementation.java.introspect.impl.IllegalContextException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.Resource;
import org.apache.tuscany.sca.implementation.java.introspect.impl.UnknownContextTypeException;
import org.oasisopen.sca.ComponentContext;
import org.oasisopen.sca.RequestContext;
import org.oasisopen.sca.annotation.Context;

public class ContextProcessor
extends BaseJavaClassVisitor {
    public ContextProcessor(AssemblyFactory factory) {
        super(factory);
    }

    public ContextProcessor(ExtensionPointRegistry registry) {
        super(registry);
    }

    @Override
    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        if (method.getAnnotation(Context.class) == null) {
            return;
        }
        if (method.getParameterTypes().length != 1) {
            throw new IllegalContextException("Context setter must have one parameter", method);
        }
        Class<?> paramType = method.getParameterTypes()[0];
        String name = JavaIntrospectionHelper.toPropertyName(method.getName());
        if (!ComponentContext.class.equals(paramType) && !RequestContext.class.equals(paramType)) {
            throw new UnknownContextTypeException(paramType.getName());
        }
        JavaElementImpl element = new JavaElementImpl(method, 0);
        element.setName(name);
        element.setClassifer(Resource.class);
        JavaResourceImpl resource = new JavaResourceImpl(element);
        type.getResources().put(resource.getName(), resource);
    }

    @Override
    public void visitField(Field field, JavaImplementation type) throws IntrospectionException {
        if (field.getAnnotation(Context.class) == null) {
            return;
        }
        Class<?> paramType = field.getType();
        if (!ComponentContext.class.equals(paramType) && !RequestContext.class.equals(paramType)) {
            throw new UnknownContextTypeException(paramType.getName());
        }
        JavaElementImpl element = new JavaElementImpl(field);
        element.setClassifer(Resource.class);
        JavaResourceImpl resource = new JavaResourceImpl(element);
        type.getResources().put(resource.getName(), resource);
    }
}

