/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.impl;

import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.tuscany.sca.Node;
import org.apache.tuscany.sca.TuscanyRuntime;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.common.java.io.IOHelper;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionMetadata;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.invocation.ExtensibleProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactoryExtensionPoint;
import org.apache.tuscany.sca.deployment.Deployer;
import org.apache.tuscany.sca.impl.DeployedComposite;
import org.apache.tuscany.sca.impl.InstalledContribution;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.ValidationException;
import org.apache.tuscany.sca.runtime.ActivationException;
import org.apache.tuscany.sca.runtime.CompositeActivator;
import org.apache.tuscany.sca.runtime.EndpointRegistry;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.NoSuchServiceException;
import org.oasisopen.sca.ServiceRuntimeException;

public class NodeImpl
implements Node {
    private String domainName;
    private Deployer deployer;
    private Map<String, InstalledContribution> installedContributions = new HashMap<String, InstalledContribution>();
    private CompositeActivator compositeActivator;
    private EndpointRegistry endpointRegistry;
    private ExtensionPointRegistry extensionPointRegistry;
    private TuscanyRuntime tuscanyRuntime;
    private static Map<String, Node> allNodes = new HashMap<String, Node>();

    public NodeImpl(String domainName, Deployer deployer, CompositeActivator compositeActivator, EndpointRegistry endpointRegistry, ExtensionPointRegistry extensionPointRegistry, TuscanyRuntime tuscanyRuntime) {
        this.domainName = domainName;
        this.deployer = deployer;
        this.compositeActivator = compositeActivator;
        this.endpointRegistry = endpointRegistry;
        this.extensionPointRegistry = extensionPointRegistry;
        this.tuscanyRuntime = tuscanyRuntime;
        allNodes.put(domainName, this);
    }

    @Override
    public String installContribution(String contributionURL) throws ContributionReadException, ActivationException, ValidationException {
        return this.installContribution(null, contributionURL, null, null, true);
    }

    @Override
    public String installContribution(String uri, String contributionURL, String metaDataURL, List<String> dependentContributionURIs, boolean startDeployables) throws ContributionReadException, ActivationException, ValidationException {
        if (uri == null) {
            uri = this.getDefaultContributionURI(contributionURL);
        }
        Monitor monitor = this.deployer.createMonitor();
        Contribution contribution = this.deployer.loadContribution(IOHelper.createURI(uri), IOHelper.getLocationAsURL(contributionURL), monitor);
        monitor.analyzeProblems();
        if (metaDataURL != null) {
            this.mergeContributionMetaData(metaDataURL, contribution);
        }
        this.installContribution(contribution, dependentContributionURIs, startDeployables);
        return uri;
    }

    private void mergeContributionMetaData(String metaDataURL, Contribution contribution) throws ValidationException {
        ContributionMetadata metaData;
        Monitor monitor = this.deployer.createMonitor();
        try {
            metaData = (ContributionMetadata)this.deployer.loadXMLDocument(IOHelper.getLocationAsURL(metaDataURL), monitor);
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
        monitor.analyzeProblems();
        contribution.getDeployables().addAll(metaData.getDeployables());
        contribution.getImports().addAll(metaData.getImports());
        contribution.getExports().addAll(metaData.getExports());
    }

    @Override
    public String installContribution(Contribution contribution, List<String> dependentContributionURIs, boolean startDeployables) throws ContributionReadException, ActivationException, ValidationException {
        InstalledContribution ic = new InstalledContribution(contribution.getURI(), contribution.getLocation(), contribution, dependentContributionURIs);
        this.installedContributions.put(contribution.getURI(), ic);
        if (startDeployables) {
            for (Composite c : ic.getDefaultDeployables()) {
                this.startComposite(c, ic);
            }
        } else {
            contribution.getDeployables().clear();
            List<Contribution> dependentContributions = this.calculateDependentContributions(ic);
            Monitor monitor = this.deployer.createMonitor();
            try {
                this.deployer.resolve(contribution, dependentContributions, monitor);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            monitor.analyzeProblems();
        }
        return ic.getURI();
    }

    protected List<Contribution> calculateDependentContributions(InstalledContribution ic) {
        ArrayList<Contribution> dependentContributions = new ArrayList<Contribution>();
        if (ic.getDependentContributionURIs() != null) {
            for (String uri : ic.getDependentContributionURIs()) {
                InstalledContribution dependee = this.installedContributions.get(uri);
                if (dependee == null) continue;
                dependentContributions.add(dependee.getContribution());
            }
        } else {
            for (InstalledContribution ics : this.installedContributions.values()) {
                dependentContributions.add(ics.getContribution());
            }
        }
        return dependentContributions;
    }

    @Override
    public String start(String contributionURI, Reader compositeXML) throws ContributionReadException, XMLStreamException, ActivationException, ValidationException {
        Monitor monitor = this.deployer.createMonitor();
        Composite composite = (Composite)this.deployer.loadXMLDocument(compositeXML, monitor);
        monitor.analyzeProblems();
        return this.start(contributionURI, composite);
    }

    @Override
    public String start(String contributionURI, Composite composite) throws ActivationException, ValidationException {
        InstalledContribution ic = this.installedContributions.get(contributionURI);
        if (ic == null) {
            throw new IllegalArgumentException("contribution not installed: " + contributionURI);
        }
        String compositeArtifcatURI = this.deployer.attachDeploymentComposite(ic.getContribution(), composite, true);
        this.startComposite(composite, ic);
        return compositeArtifcatURI;
    }

    @Override
    public void start(String contributionURI, String compositeURI) throws ActivationException, ValidationException {
        InstalledContribution ic = this.installedContributions.get(contributionURI);
        if (ic == null) {
            throw new IllegalArgumentException("Contribution not installed: " + contributionURI);
        }
        for (Artifact a : ic.getContribution().getArtifacts()) {
            if (!a.getURI().equals(compositeURI)) continue;
            this.startComposite((Composite)a.getModel(), ic);
            return;
        }
        throw new IllegalArgumentException("composite not found: " + compositeURI);
    }

    @Override
    public void stop(String contributionURI, String compositeURI) throws ActivationException {
        InstalledContribution ic = this.installedContributions.get(contributionURI);
        if (ic == null) {
            throw new IllegalArgumentException("Contribution not installed: " + contributionURI);
        }
        for (DeployedComposite dc : ic.getDeployedComposites()) {
            if (!compositeURI.equals(dc.getURI())) continue;
            ic.getDeployedComposites().remove(dc);
            dc.unDeploy();
            return;
        }
        throw new IllegalStateException("composite not deployed: " + compositeURI);
    }

    @Override
    public Composite getDomainLevelComposite() {
        return null;
    }

    @Override
    public String getDomainLevelCompositeAsString() {
        return null;
    }

    @Override
    public Object getQNameDefinition(String contributionURI, QName definition, QName symbolSpace) {
        return null;
    }

    @Override
    public List<String> removeContribution(String contributionURI) throws ActivationException {
        ArrayList<String> removedContributionURIs = new ArrayList<String>();
        InstalledContribution ic = this.installedContributions.get(contributionURI);
        if (ic != null) {
            removedContributionURIs.add(ic.getURI());
            for (String dependent : this.getDependentContributions(contributionURI)) {
                removedContributionURIs.addAll(this.removeContribution(dependent));
            }
            this.installedContributions.remove(contributionURI);
            for (DeployedComposite dc : ic.getDeployedComposites()) {
                dc.unDeploy();
            }
            ic.getDeployedComposites().clear();
        }
        return removedContributionURIs;
    }

    public void updateContribution(String uri, String contributionURL) {
    }

    public void updateContribution(Contribution contribution) {
    }

    public String updateDeploymentComposite(String uri, Reader compositeXML) {
        return null;
    }

    public String updateDeploymentComposite(String uri, Composite composite) {
        return null;
    }

    @Override
    public void stop() {
        ArrayList<String> ics = new ArrayList<String>(this.installedContributions.keySet());
        for (String uri : ics) {
            try {
                this.removeContribution(uri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.tuscanyRuntime != null) {
            this.tuscanyRuntime.stop();
        }
        allNodes.remove(this.domainName);
    }

    @Override
    public <T> T getService(Class<T> interfaze, String serviceURI) throws NoSuchServiceException {
        Endpoint ep;
        int i;
        List<Endpoint> endpoints = this.endpointRegistry.findEndpoint(serviceURI);
        if (endpoints.size() < 1) {
            throw new NoSuchServiceException(serviceURI);
        }
        String serviceName = null;
        if (serviceURI.contains("/") && (i = serviceURI.indexOf("/")) < serviceURI.length() - 1) {
            serviceName = serviceURI.substring(i + 1);
        }
        if (((RuntimeComponent)(ep = endpoints.get(0)).getComponent()).getComponentContext() != null) {
            return ((RuntimeComponent)ep.getComponent()).getServiceReference(interfaze, serviceName).getService();
        }
        return this.getRemoteProxy(interfaze, ep);
    }

    private <T> T getRemoteProxy(Class<T> serviceInterface, Endpoint endpoint) throws NoSuchServiceException {
        RuntimeEndpointReference epr;
        FactoryExtensionPoint factories = this.extensionPointRegistry.getExtensionPoint(FactoryExtensionPoint.class);
        AssemblyFactory assemblyFactory = factories.getFactory(AssemblyFactory.class);
        JavaInterfaceFactory javaInterfaceFactory = factories.getFactory(JavaInterfaceFactory.class);
        ExtensibleProxyFactory proxyFactory = new ExtensibleProxyFactory(this.extensionPointRegistry.getExtensionPoint(ProxyFactoryExtensionPoint.class));
        CompositeContext compositeContext = new CompositeContext(this.extensionPointRegistry, this.endpointRegistry, null, null, null, this.deployer.getSystemDefinitions());
        try {
            epr = this.createEndpointReference(javaInterfaceFactory, compositeContext, assemblyFactory, endpoint, serviceInterface);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
        return proxyFactory.createProxy(serviceInterface, epr);
    }

    private RuntimeEndpointReference createEndpointReference(JavaInterfaceFactory javaInterfaceFactory, CompositeContext compositeContext, AssemblyFactory assemblyFactory, Endpoint endpoint, Class<?> businessInterface) throws CloneNotSupportedException, InvalidInterfaceException {
        Component component = endpoint.getComponent();
        ComponentService service = endpoint.getService();
        ComponentReference componentReference = assemblyFactory.createComponentReference();
        componentReference.setName("sca.client." + service.getName());
        componentReference.setCallback(service.getCallback());
        componentReference.getTargets().add(service);
        componentReference.getPolicySets().addAll(service.getPolicySets());
        componentReference.getRequiredIntents().addAll(service.getRequiredIntents());
        componentReference.getBindings().add(endpoint.getBinding());
        InterfaceContract interfaceContract = service.getInterfaceContract();
        Service componentTypeService = service.getService();
        if (componentTypeService != null && componentTypeService.getInterfaceContract() != null) {
            interfaceContract = componentTypeService.getInterfaceContract();
        }
        interfaceContract = this.getInterfaceContract(javaInterfaceFactory, interfaceContract, businessInterface);
        componentReference.setInterfaceContract(interfaceContract);
        componentReference.setMultiplicity(Multiplicity.ONE_ONE);
        EndpointReference endpointReference = assemblyFactory.createEndpointReference();
        endpointReference.setComponent(component);
        endpointReference.setReference(componentReference);
        endpointReference.setBinding(endpoint.getBinding());
        endpointReference.setUnresolved(false);
        endpointReference.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED);
        endpointReference.setTargetEndpoint(endpoint);
        componentReference.getEndpointReferences().add(endpointReference);
        ((RuntimeComponentReference)componentReference).setComponent((RuntimeComponent)component);
        ((RuntimeEndpointReference)endpointReference).bind(compositeContext);
        return (RuntimeEndpointReference)endpointReference;
    }

    private InterfaceContract getInterfaceContract(JavaInterfaceFactory javaInterfaceFactory, InterfaceContract interfaceContract, Class<?> businessInterface) throws CloneNotSupportedException, InvalidInterfaceException {
        Class<?> cls;
        Interface interfaze;
        if (businessInterface == null) {
            return interfaceContract;
        }
        boolean compatible = false;
        if (interfaceContract != null && interfaceContract.getInterface() != null && (interfaze = interfaceContract.getInterface()) instanceof JavaInterface && (cls = ((JavaInterface)interfaze).getJavaClass()) != null && businessInterface.isAssignableFrom(cls)) {
            compatible = true;
        }
        if (!compatible) {
            interfaceContract = javaInterfaceFactory.createJavaInterfaceContract();
            JavaInterface callInterface = javaInterfaceFactory.createJavaInterface(businessInterface);
            interfaceContract.setInterface(callInterface);
            if (callInterface.getCallbackClass() != null) {
                interfaceContract.setCallbackInterface(javaInterfaceFactory.createJavaInterface(callInterface.getCallbackClass()));
            }
        }
        return interfaceContract;
    }

    @Override
    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public List<String> getStartedCompositeURIs(String contributionURI) {
        ArrayList<String> compositeURIs = new ArrayList<String>();
        InstalledContribution ic = this.installedContributions.get(contributionURI);
        if (ic == null) {
            throw new IllegalArgumentException("no contribution found for: " + contributionURI);
        }
        for (DeployedComposite dc : ic.getDeployedComposites()) {
            compositeURIs.add(dc.getURI());
        }
        return compositeURIs;
    }

    @Override
    public List<String> getInstalledContributionURIs() {
        return new ArrayList<String>(this.installedContributions.keySet());
    }

    @Override
    public Contribution getInstalledContribution(String uri) {
        if (this.installedContributions.containsKey(uri)) {
            return this.installedContributions.get(uri).getContribution();
        }
        throw new IllegalArgumentException("no contribution found for: " + uri);
    }

    protected String getContributionUriForArtifact(String artifactURI) {
        String contributionURI = null;
        for (String uri : this.installedContributions.keySet()) {
            if (!artifactURI.startsWith(uri)) continue;
            contributionURI = uri;
            break;
        }
        if (contributionURI == null) {
            throw new IllegalArgumentException("no contribution found for: " + artifactURI);
        }
        return contributionURI;
    }

    protected void startComposite(Composite c, InstalledContribution ic) throws ActivationException, ValidationException {
        List<Contribution> dependentContributions = this.calculateDependentContributions(ic);
        DeployedComposite dc = new DeployedComposite(c, ic, dependentContributions, this.deployer, this.compositeActivator, this.endpointRegistry, this.extensionPointRegistry);
        ic.getDeployedComposites().add(dc);
    }

    public Set<String> getDependentContributions(String contributionURI) {
        InstalledContribution ic = this.installedContributions.get(contributionURI);
        if (ic == null) {
            throw new IllegalArgumentException("Contribution not installed: " + contributionURI);
        }
        HashSet<String> dependentContributionURIs = new HashSet<String>();
        for (InstalledContribution icx : this.installedContributions.values()) {
            List<Contribution> dependencies;
            if (ic == icx || (dependencies = icx.getContribution().getDependencies()) == null || !dependencies.contains(ic.getContribution())) continue;
            dependentContributionURIs.addAll(this.getDependentContributions(icx.getURI()));
        }
        return dependentContributionURIs;
    }

    protected String getDefaultContributionURI(String contributionURL) {
        String uri = null;
        try {
            File f = new File(contributionURL);
            uri = "classes".equals(f.getName()) && "target".equals(f.getParentFile().getName()) ? f.getParentFile().getParentFile().getName() : f.getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uri == null) {
            uri = contributionURL;
        }
        if (uri.endsWith(".zip") || uri.endsWith(".jar")) {
            uri = uri.substring(0, uri.length() - 4);
        }
        return uri;
    }

    public EndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    public static Node nodeExists(String domainName) {
        return allNodes.get(domainName);
    }
}

