/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.deployment.Deployer;
import org.apache.tuscany.sca.impl.InstalledContribution;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.ValidationException;
import org.apache.tuscany.sca.runtime.ActivationException;
import org.apache.tuscany.sca.runtime.CompositeActivator;
import org.apache.tuscany.sca.runtime.EndpointRegistry;

public class DeployedComposite {
    private String uri;
    private Composite composite;
    private InstalledContribution installedContribution;
    private List<Contribution> dependedOnContributions;
    private Composite domainComposite;
    private CompositeActivator compositeActivator;
    private CompositeContext compositeContext;
    private Deployer deployer;
    private EndpointRegistry endpointRegistry;
    private ExtensionPointRegistry extensionPointRegistry;

    public DeployedComposite(Composite composite, InstalledContribution ic, List<Contribution> dependedOnContributions, Deployer deployer, CompositeActivator compositeActivator, EndpointRegistry endpointRegistry, ExtensionPointRegistry extensionPointRegistry) throws ValidationException, ActivationException {
        this.composite = composite;
        this.installedContribution = ic;
        this.dependedOnContributions = dependedOnContributions;
        this.deployer = deployer;
        this.compositeActivator = compositeActivator;
        this.endpointRegistry = endpointRegistry;
        this.extensionPointRegistry = extensionPointRegistry;
        try {
            this.init();
        }
        catch (ContributionResolveException e) {
            throw new ActivationException(e);
        }
        catch (CompositeBuilderException e) {
            throw new ActivationException(e);
        }
    }

    protected void init() throws ValidationException, ActivationException, ContributionResolveException, CompositeBuilderException {
        ArrayList<Contribution> contribution = new ArrayList<Contribution>();
        contribution.add(this.installedContribution.getContribution());
        ((Contribution)contribution.get(0)).getDeployables().clear();
        ((Contribution)contribution.get(0)).getDeployables().add(this.composite);
        Monitor monitor = this.deployer.createMonitor();
        this.domainComposite = this.deployer.build(contribution, this.dependedOnContributions, new HashMap<QName, List<String>>(), monitor);
        monitor.analyzeProblems();
        this.compositeContext = new CompositeContext(this.extensionPointRegistry, this.endpointRegistry, this.domainComposite, null, null, this.deployer.getSystemDefinitions());
        this.compositeActivator.activate(this.compositeContext, this.domainComposite);
        this.compositeActivator.start(this.compositeContext, this.domainComposite);
        this.uri = this.getCompositeURI(this.composite, this.installedContribution);
    }

    public void unDeploy() throws ActivationException {
        this.compositeActivator.stop(this.compositeContext, this.domainComposite);
        this.compositeActivator.deactivate(this.domainComposite);
    }

    public String getURI() {
        return this.uri;
    }

    protected String getCompositeURI(Composite c, InstalledContribution ic) {
        for (Artifact a : ic.getContribution().getArtifacts()) {
            if (a.getModel() == null || !(a.getModel() instanceof Composite)) continue;
            Composite cm = (Composite)a.getModel();
            if (!c.getName().equals(cm.getName())) continue;
            return cm.getURI();
        }
        throw new IllegalStateException("can't determine composte uri");
    }
}

