/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.webapp;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.tuscany.sca.host.http.SecurityContext;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletMappingException;
import org.apache.tuscany.sca.host.webapp.WebAppHelper;
import org.apache.tuscany.sca.host.webapp.WebAppRequestDispatcher;
import org.apache.tuscany.sca.node.Node;

public class WebAppServletHost
implements ServletHost {
    private static final Logger logger = Logger.getLogger(WebAppServletHost.class.getName());
    public static final String SCA_NODE_ATTRIBUTE = Node.class.getName();
    private Map<String, Servlet> servlets;
    private String contextPath = "/";
    private int defaultPortNumber = 8080;
    private String contributionRoot;
    private ServletConfig servletConfig;
    private ServletContext servletContext;
    private Map<String, Object> tempAttributes = new HashMap<String, Object>();

    public WebAppServletHost() {
        this.servlets = new HashMap<String, Servlet>();
    }

    @Override
    public void setDefaultPort(int port) {
        this.defaultPortNumber = port;
    }

    @Override
    public int getDefaultPort() {
        return this.defaultPortNumber;
    }

    @Override
    public String getName() {
        return "webapp";
    }

    @Override
    public String addServletMapping(String suri, Servlet servlet) throws ServletMappingException {
        return this.addServletMapping(suri, servlet, null);
    }

    @Override
    public String addServletMapping(String suri, Servlet servlet, SecurityContext securityContext) throws ServletMappingException {
        URI pathURI = URI.create(suri);
        if (!(suri = pathURI.getPath()).startsWith("/")) {
            suri = '/' + suri;
        }
        if (!suri.startsWith(this.contextPath + "/")) {
            suri = this.contextPath + suri;
        }
        if (!this.servlets.values().contains(servlet)) {
            try {
                servlet.init(this.servletConfig);
            }
            catch (ServletException e) {
                throw new ServletMappingException(e);
            }
        }
        this.servlets.put(suri, servlet);
        URL url = this.getURLMapping(pathURI.toString(), securityContext);
        logger.info("Added Servlet mapping: " + url);
        return url.toString();
    }

    @Override
    public Servlet removeServletMapping(String suri) throws ServletMappingException {
        URI pathURI = URI.create(suri);
        if (!(suri = pathURI.getPath()).startsWith("/")) {
            suri = '/' + suri;
        }
        if (!suri.startsWith(this.contextPath)) {
            suri = this.contextPath + suri;
        }
        Servlet servlet = this.servlets.remove(suri);
        return servlet;
    }

    @Override
    public Servlet getServletMapping(String suri) throws ServletMappingException {
        if (!suri.startsWith("/")) {
            suri = '/' + suri;
        }
        if (!suri.startsWith(this.contextPath)) {
            suri = this.contextPath + suri;
        }
        Servlet servlet = this.servlets.get(suri);
        return servlet;
    }

    @Override
    public URL getURLMapping(String suri, SecurityContext securityContext) throws ServletMappingException {
        URL url;
        String path;
        String host;
        int portNumber;
        URI uri = URI.create(suri);
        String scheme = uri.getScheme();
        if (scheme == null) {
            scheme = "http";
        }
        if ((portNumber = uri.getPort()) == -1 && uri.getScheme() == null) {
            portNumber = this.defaultPortNumber;
        }
        if ((host = uri.getHost()) == null) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Error retrieving host information : " + t.getMessage());
                host = "localhost";
            }
        }
        if (!(path = uri.getPath()).startsWith("/")) {
            path = '/' + path;
        }
        if (this.contextPath != null && !path.startsWith(this.contextPath)) {
            path = this.contextPath + path;
        }
        try {
            url = new URL(scheme, host, portNumber, path);
        }
        catch (MalformedURLException e) {
            throw new ServletMappingException(e);
        }
        return url;
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String suri) throws ServletMappingException {
        Servlet servlet;
        if (!suri.startsWith("/")) {
            suri = '/' + suri;
        }
        if (this.contextPath != null && this.contextPath.length() > 0 && !"/".equals(this.contextPath)) {
            suri = this.contextPath + suri;
        }
        if ((servlet = this.servlets.get(suri)) != null) {
            return new WebAppRequestDispatcher(suri, servlet);
        }
        for (Map.Entry<String, Servlet> entry : this.servlets.entrySet()) {
            String servletPath = entry.getKey();
            if (!servletPath.endsWith("*")) continue;
            if (suri.startsWith(servletPath = servletPath.substring(0, servletPath.length() - 1))) {
                return new WebAppRequestDispatcher(entry.getKey().substring(this.contextPath.length()), entry.getValue());
            }
            if (!(suri + "/").startsWith(servletPath)) continue;
            return new WebAppRequestDispatcher(entry.getKey().substring(this.contextPath.length()), entry.getValue());
        }
        return null;
    }

    public void init(ServletConfig config) throws ServletException {
        this.servletConfig = config;
        this.servletContext = config.getServletContext();
        for (String name : this.tempAttributes.keySet()) {
            this.servletContext.setAttribute(name, this.tempAttributes.get(name));
        }
        this.initContextPath(config);
        for (Servlet servlet : this.servlets.values()) {
            servlet.init(config);
        }
    }

    public void initContextPath(ServletConfig config) {
        String oldContextPath = this.contextPath;
        if (Collections.list(config.getInitParameterNames()).contains("contextPath")) {
            this.contextPath = config.getInitParameter("contextPath");
        } else {
            ServletContext context = config.getServletContext();
            try {
                Method m = context.getClass().getMethod("getContextPath", new Class[0]);
                this.contextPath = (String)m.invoke((Object)context, new Object[0]);
            }
            catch (Exception e) {
                logger.warning("Servlet level is: " + context.getMajorVersion() + "." + context.getMinorVersion());
                throw new IllegalStateException("'contextPath' init parameter must be set for pre-2.5 servlet container");
            }
        }
        logger.info("ContextPath: " + this.contextPath);
        if (!oldContextPath.endsWith(this.contextPath)) {
            ArrayList<String> oldServletURIs = new ArrayList<String>();
            for (String oldServletURI : this.servlets.keySet()) {
                if (!oldServletURI.startsWith(oldContextPath) || oldServletURI.startsWith(this.contextPath)) continue;
                oldServletURIs.add(oldServletURI);
            }
            for (String oldURI : oldServletURIs) {
                String ns = this.contextPath + "/" + oldURI.substring(oldContextPath.length());
                this.servlets.put(ns, this.servlets.remove(oldURI));
            }
        }
    }

    void destroy() {
        for (Servlet servlet : this.servlets.values()) {
            servlet.destroy();
        }
        WebAppHelper.stop(this.servletContext);
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public void setContextPath(String path) {
    }

    public void setContextPath2(String path) {
        if (path != null && path.length() > 0) {
            this.contextPath = path;
        }
    }

    public String getContributionRoot() {
        return this.contributionRoot;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.servletContext != null) {
            this.servletContext.setAttribute(name, value);
        } else {
            this.tempAttributes.put(name, value);
        }
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

