/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.webapp;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletHostHelper;
import org.apache.tuscany.sca.host.webapp.WebAppServletHost;
import org.apache.tuscany.sca.node.Node;
import org.apache.tuscany.sca.node.NodeFactory;
import org.apache.tuscany.sca.node.configuration.NodeConfiguration;

public class WebAppHelper {
    private static final String ROOT = "/";
    private static final String CONTRIBUTIONS = "contributions";
    private static final String DEFAULT_CONTRIBUTIONS = "/WEB-INF/sca-contributions";
    private static final String CONTRIBUTION = "contribution";
    private static final String NODE_CONFIGURATION = "node.configuration";
    private static final String WEB_COMPOSITE = "/WEB-INF/web.composite";
    private static final String DOMAIN_URI = "domain.uri";
    private static final String NODE_URI = "node.uri";
    public static final String DOMAIN_NAME_ATTR = "org.apache.tuscany.sca.domain.name";
    public static final String SCA_NODE_ATTRIBUTE = Node.class.getName();
    private static NodeFactory factory;
    private static WebAppServletHost host;

    private static URL getResource(ServletContext servletContext, String location) throws IOException {
        URL url;
        URI uri = URI.create(location);
        if (uri.isAbsolute()) {
            return uri.toURL();
        }
        String path = location;
        if (!path.startsWith(ROOT)) {
            path = ROOT + path;
        }
        if ((url = servletContext.getResource(path)) != null && url.getProtocol().equals("jndi")) {
            File warRootFile = new File(servletContext.getRealPath(path));
            return warRootFile.toURI().toURL();
        }
        return url;
    }

    private static String[] parse(String listOfValues) {
        if (listOfValues == null) {
            return null;
        }
        return listOfValues.split("(\\s|,)+");
    }

    private static NodeConfiguration getNodeConfiguration(ServletContext servletContext) throws IOException, URISyntaxException {
        NodeConfiguration configuration = null;
        String nodeConfigURI = (String)servletContext.getAttribute(NODE_CONFIGURATION);
        if (nodeConfigURI != null) {
            URL url = WebAppHelper.getResource(servletContext, nodeConfigURI);
            configuration = factory.loadConfiguration(url.openStream(), url);
        } else {
            String nodeURI;
            File f;
            URL url;
            configuration = factory.createNodeConfiguration();
            boolean explicitContributions = false;
            Enumeration names = servletContext.getAttributeNames();
            while (names.hasMoreElements()) {
                File f2;
                String listOfValues;
                String name = (String)names.nextElement();
                if (name.equals(CONTRIBUTION) || name.startsWith("contribution.")) {
                    explicitContributions = true;
                    listOfValues = (String)servletContext.getAttribute(name);
                    if (listOfValues == null) continue;
                    for (String path : WebAppHelper.parse(listOfValues)) {
                        if ("".equals(path)) continue;
                        f2 = new File(WebAppHelper.getResource(servletContext, path).toURI());
                        configuration.addContribution(f2.toURI().toURL());
                    }
                    continue;
                }
                if (!name.equals(CONTRIBUTIONS) && !name.startsWith("contributions.")) continue;
                explicitContributions = true;
                listOfValues = (String)servletContext.getAttribute(name);
                if (listOfValues == null) continue;
                for (String path : WebAppHelper.parse(listOfValues)) {
                    if ("".equals(path)) continue;
                    f2 = new File(WebAppHelper.getResource(servletContext, path).toURI());
                    if (f2.isDirectory()) {
                        for (File n : f2.listFiles()) {
                            configuration.addContribution(n.toURI().toURL());
                        }
                        continue;
                    }
                    configuration.addContribution(f2.toURI().toURL());
                }
            }
            URL composite = WebAppHelper.getResource(servletContext, WEB_COMPOSITE);
            if (configuration.getContributions().isEmpty() || !explicitContributions && composite != null) {
                configuration.addContribution(WebAppHelper.getResource(servletContext, ROOT));
            }
            if (composite != null) {
                configuration.getContributions().get(0).addDeploymentComposite(composite);
            }
            if (!explicitContributions && (url = WebAppHelper.getResource(servletContext, DEFAULT_CONTRIBUTIONS)) != null && (f = new File(url.toURI())).isDirectory()) {
                for (File n : f.listFiles()) {
                    configuration.addContribution(n.toURI().toURL());
                }
            }
            if ((nodeURI = (String)servletContext.getAttribute(NODE_URI)) == null) {
                nodeURI = new File(servletContext.getRealPath(ROOT)).getName();
            }
            configuration.setURI(nodeURI);
            String domainURI = (String)servletContext.getAttribute(DOMAIN_URI);
            if (domainURI != null) {
                configuration.setDomainURI(domainURI);
            } else {
                domainURI = servletContext.getInitParameter("org.apache.tuscany.sca.defaultDomainURI");
                if (domainURI != null) {
                    configuration.setDomainURI(WebAppHelper.getDomainName(domainURI));
                    configuration.setDomainRegistryURI(domainURI);
                }
            }
        }
        return configuration;
    }

    private static String getDomainName(String configURI) {
        int i;
        String domainName = configURI.startsWith("tuscany:vm:") ? configURI.substring("tuscany:vm:".length()) : (configURI.startsWith("tuscany:") ? ((i = configURI.indexOf(63)) == -1 ? configURI.substring("tuscany:".length()) : configURI.substring("tuscany:".length(), i)) : configURI);
        return domainName;
    }

    public static synchronized ServletHost init(ServletContext servletContext) {
        Node node;
        if (host == null) {
            try {
                String configValue = servletContext.getInitParameter("org.apache.tuscany.sca.config");
                factory = configValue != null ? NodeFactory.newInstance(configValue) : NodeFactory.newInstance();
                ExtensionPointRegistry registry = (ExtensionPointRegistry)factory.getExtensionPointRegistry();
                UtilityExtensionPoint utilityExtensionPoint = registry.getExtensionPoint(UtilityExtensionPoint.class);
                utilityExtensionPoint.addUtility(ServletContext.class, servletContext);
                ServletHostExtensionPoint servletHosts = registry.getExtensionPoint(ServletHostExtensionPoint.class);
                servletHosts.setWebApp(true);
                Enumeration e = servletContext.getInitParameterNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    String value = servletContext.getInitParameter(name);
                    servletContext.setAttribute(name, (Object)value);
                }
                host = WebAppHelper.getServletHost(servletContext);
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
        }
        if ((node = (Node)servletContext.getAttribute(SCA_NODE_ATTRIBUTE)) == null) {
            try {
                node = WebAppHelper.createAndStartNode(servletContext);
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
            servletContext.setAttribute(SCA_NODE_ATTRIBUTE, (Object)node);
        }
        return host;
    }

    private static WebAppServletHost getServletHost(final ServletContext servletContext) throws ServletException {
        WebAppServletHost host = WebAppHelper.getServletHost(factory);
        host.init(new ServletConfig(){

            public String getInitParameter(String name) {
                return servletContext.getInitParameter(name);
            }

            public Enumeration<?> getInitParameterNames() {
                return servletContext.getInitParameterNames();
            }

            public ServletContext getServletContext() {
                return servletContext;
            }

            public String getServletName() {
                return servletContext.getServletContextName();
            }
        });
        return host;
    }

    private static WebAppServletHost getServletHost(NodeFactory factory) {
        ExtensionPointRegistry registry = (ExtensionPointRegistry)factory.getExtensionPointRegistry();
        return (WebAppServletHost)ServletHostHelper.getServletHost(registry);
    }

    private static Node createAndStartNode(ServletContext servletContext) throws ServletException {
        NodeConfiguration configuration;
        try {
            configuration = WebAppHelper.getNodeConfiguration(servletContext);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ServletException((Throwable)e);
        }
        Node node = factory.createNode(configuration).start();
        return node;
    }

    public static void stop(ServletContext servletContext) {
        Node node = (Node)servletContext.getAttribute(SCA_NODE_ATTRIBUTE);
        if (node != null) {
            node.stop();
            servletContext.setAttribute(SCA_NODE_ATTRIBUTE, null);
        }
    }

    public static NodeFactory getNodeFactory() {
        return factory;
    }
}

