/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.webapp;

import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.webapp.WebAppHelper;

public class TuscanyServletFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger(TuscanyServletFilter.class.getName());
    private transient ServletContext context;
    private transient ServletHost servletHost;

    public void init(FilterConfig config) throws ServletException {
        try {
            this.context = config.getServletContext();
            Enumeration e = config.getInitParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = config.getInitParameter(name);
                this.context.setAttribute(name, (Object)value);
            }
            this.servletHost = WebAppHelper.init(this.context);
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            this.context.log(e.getMessage(), e);
            throw new ServletException(e);
        }
    }

    public void destroy() {
        WebAppHelper.stop(this.context);
        this.servletHost = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            RequestDispatcher dispatcher;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String path = httpRequest.getPathInfo();
            if (path == null) {
                path = httpRequest.getServletPath();
            }
            if (path == null) {
                path = "/";
            }
            if ((dispatcher = this.servletHost.getRequestDispatcher(path)) != null) {
                dispatcher.forward(request, response);
            } else {
                chain.doFilter(request, response);
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            this.context.log(e.getMessage(), e);
            throw new ServletException(e);
        }
    }
}

