/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.http;

import java.net.URL;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.host.http.DefaultServletHostExtensionPoint;
import org.apache.tuscany.sca.host.http.SecurityContext;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletMappingException;

public class ExtensibleServletHost
implements ServletHost {
    private ServletHostExtensionPoint servletHosts;

    public ExtensibleServletHost(ExtensionPointRegistry registry) {
        this.servletHosts = registry.getExtensionPoint(ServletHostExtensionPoint.class);
    }

    public static ExtensibleServletHost getInstance(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilityExtensionPoint = registry.getExtensionPoint(UtilityExtensionPoint.class);
        return utilityExtensionPoint.getUtility(ExtensibleServletHost.class);
    }

    public ExtensibleServletHost(ServletHostExtensionPoint servletHosts) {
        this.servletHosts = servletHosts;
    }

    @Override
    public void setDefaultPort(int port) {
        for (ServletHost servletHost : this.servletHosts.getServletHosts()) {
            servletHost.setDefaultPort(port);
        }
    }

    public ServletHost getDefaultServletHost() {
        List<ServletHost> hosts = this.servletHosts.getServletHosts();
        if (hosts.isEmpty()) {
            throw new ServletMappingException("No servlet host is available.");
        }
        if (this.servletHosts.isWebApp()) {
            for (ServletHost servletHost : hosts) {
                if (!"webapp".equals(servletHost.getName())) continue;
                if (servletHost instanceof DefaultServletHostExtensionPoint.LazyServletHost) {
                    return ((DefaultServletHostExtensionPoint.LazyServletHost)servletHost).getServletHost();
                }
                return servletHost;
            }
        }
        return hosts.get(0);
    }

    @Override
    public int getDefaultPort() {
        return this.getDefaultServletHost().getDefaultPort();
    }

    @Override
    public String addServletMapping(String uri, Servlet servlet) throws ServletMappingException {
        return this.getDefaultServletHost().addServletMapping(uri, servlet);
    }

    @Override
    public String addServletMapping(String uri, Servlet servlet, SecurityContext securityContext) throws ServletMappingException {
        return this.getDefaultServletHost().addServletMapping(uri, servlet, securityContext);
    }

    @Override
    public Servlet getServletMapping(String uri) throws ServletMappingException {
        return this.getDefaultServletHost().getServletMapping(uri);
    }

    @Override
    public Servlet removeServletMapping(String uri) throws ServletMappingException {
        return this.getDefaultServletHost().removeServletMapping(uri);
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String uri) throws ServletMappingException {
        return this.getDefaultServletHost().getRequestDispatcher(uri);
    }

    @Override
    public String getContextPath() {
        return this.getDefaultServletHost().getContextPath();
    }

    @Override
    public URL getURLMapping(String uri, SecurityContext securityContext) {
        return this.getDefaultServletHost().getURLMapping(uri, securityContext);
    }

    @Override
    public void setContextPath(String path) {
        this.getDefaultServletHost().setContextPath(path);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.getDefaultServletHost().setAttribute(name, value);
    }

    @Override
    public String getName() {
        return this.getDefaultServletHost().getName();
    }

    @Override
    public ServletContext getServletContext() {
        return this.getDefaultServletHost().getServletContext();
    }
}

