/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extensibility;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.extensibility.ContextClassLoaderServiceDiscoverer;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscoverer;
import org.apache.tuscany.sca.extensibility.impl.LDAPFilter;

public final class ServiceDiscovery
implements ServiceDiscoverer {
    private static final Logger logger = Logger.getLogger(ServiceDiscovery.class.getName());
    private static final ServiceDiscovery INSTANCE = new ServiceDiscovery();
    private final Map<String, Map<String, String>> serviceAttributes = new HashMap<String, Map<String, String>>();
    private ServiceDiscoverer discoverer;

    private ServiceDiscovery() {
    }

    private ServiceDiscovery(ServiceDiscoverer discoverer) {
        this.discoverer = discoverer;
    }

    public static ServiceDiscovery getInstance() {
        return INSTANCE;
    }

    public static ServiceDiscovery getInstance(ServiceDiscoverer discoverer) {
        return new ServiceDiscovery(discoverer);
    }

    public ServiceDiscoverer getServiceDiscoverer() {
        if (this.discoverer != null) {
            return this.discoverer;
        }
        try {
            Class.forName("org.apache.tuscany.sca.extensibility.equinox.EquinoxServiceDiscoverer");
            if (this.discoverer != null) {
                return this.discoverer;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.discoverer = new ContextClassLoaderServiceDiscoverer(this.getClass().getClassLoader());
        return this.discoverer;
    }

    public void setServiceDiscoverer(ServiceDiscoverer sd) {
        if (this.discoverer != null && sd != null) {
            logger.warning("ServiceDiscoverer is reset to " + sd);
        }
        this.discoverer = sd;
    }

    @Override
    public Collection<ServiceDeclaration> getServiceDeclarations(String name) throws IOException {
        return this.getServiceDeclarations(name, false);
    }

    public Collection<ServiceDeclaration> getServiceDeclarations(String name, boolean byRanking) throws IOException {
        Collection<ServiceDeclaration> declarations = this.getServiceDiscoverer().getServiceDeclarations(name);
        if (!this.serviceAttributes.isEmpty()) {
            for (ServiceDeclaration declaration : declarations) {
                Map<String, String> attrs = this.getAttributes(name);
                if (attrs == null) continue;
                declaration.getAttributes().putAll(attrs);
            }
        }
        if (!byRanking) {
            return declarations;
        }
        if (!declarations.isEmpty()) {
            ArrayList<ServiceDeclaration> declarationList = new ArrayList<ServiceDeclaration>(declarations);
            Collections.sort(declarationList, ServiceComparator.DESCENDING_ORDER);
            return declarationList;
        }
        return Collections.emptyList();
    }

    @Override
    public ServiceDeclaration getServiceDeclaration(String name) throws IOException {
        Collection<ServiceDeclaration> declarations = this.getServiceDeclarations(name, true);
        if (!declarations.isEmpty()) {
            return declarations.iterator().next();
        }
        return null;
    }

    public Collection<ServiceDeclaration> getServiceDeclarations(Class<?> serviceType, boolean byRanking) throws IOException {
        Collection<ServiceDeclaration> sds = this.getServiceDeclarations(serviceType.getName(), byRanking);
        Iterator<ServiceDeclaration> i = sds.iterator();
        while (i.hasNext()) {
            ServiceDeclaration sd = i.next();
            if (sd.isAssignableTo(serviceType)) continue;
            logger.log(Level.WARNING, "Service provider {0} is not a type of {1}", new Object[]{sd, serviceType.getName()});
            i.remove();
        }
        return sds;
    }

    public Collection<ServiceDeclaration> getServiceDeclarations(Class<?> serviceType) throws IOException {
        return this.getServiceDeclarations(serviceType, false);
    }

    public Collection<ServiceDeclaration> getServiceDeclarations(Class<?> serviceType, String filter) throws IOException {
        Collection<ServiceDeclaration> sds = this.getServiceDeclarations(serviceType, false);
        ArrayList<ServiceDeclaration> filtered = new ArrayList<ServiceDeclaration>();
        LDAPFilter filterImpl = LDAPFilter.newInstance(filter);
        for (ServiceDeclaration sd : sds) {
            if (!filterImpl.match(sd.getAttributes())) continue;
            filtered.add(sd);
        }
        return filtered;
    }

    public Collection<ServiceDeclaration> getServiceDeclarations(String serviceName, String filter) throws IOException {
        Collection<ServiceDeclaration> sds = this.getServiceDeclarations(serviceName, false);
        ArrayList<ServiceDeclaration> filtered = new ArrayList<ServiceDeclaration>();
        LDAPFilter filterImpl = LDAPFilter.newInstance(filter);
        for (ServiceDeclaration sd : sds) {
            if (!filterImpl.match(sd.getAttributes())) continue;
            filtered.add(sd);
        }
        return filtered;
    }

    public ServiceDeclaration getServiceDeclaration(Class<?> serviceType) throws IOException {
        Collection<ServiceDeclaration> sds = this.getServiceDeclarations(serviceType, true);
        if (sds.isEmpty()) {
            return null;
        }
        return sds.iterator().next();
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.discoverer.getContextClassLoader();
    }

    public void setAttribute(String serviceType, Map<String, String> attributes) {
        this.serviceAttributes.put(serviceType, attributes);
    }

    public void setAttribute(String serviceType, String attribute, String value) {
        Map<String, String> attributes = this.serviceAttributes.get(serviceType);
        if (attributes == null) {
            attributes = new HashMap<String, String>();
            this.serviceAttributes.put(serviceType, attributes);
        }
        attributes.put(attribute, value);
    }

    public Map<String, String> getAttributes(String serviceType) {
        return this.serviceAttributes.get(serviceType);
    }

    public static Collection<ServiceDeclaration> removeDuplicateDeclarations(Collection<ServiceDeclaration> declarations) {
        LinkedHashMap<String, ServiceDeclaration> map = new LinkedHashMap<String, ServiceDeclaration>();
        for (ServiceDeclaration sd : declarations) {
            ServiceDeclaration existed = map.put(sd.getClassName(), sd);
            if (existed == null) continue;
            logger.warning("Duplicate service declaration is ignored: " + existed + " <-> " + sd);
        }
        return map.values();
    }

    private static class ServiceComparator
    implements Comparator<ServiceDeclaration> {
        private static final Comparator<ServiceDeclaration> DESCENDING_ORDER = new ServiceComparator();

        private ServiceComparator() {
        }

        @Override
        public int compare(ServiceDeclaration o1, ServiceDeclaration o2) {
            int rank1 = 0;
            String r1 = o1.getAttributes().get("ranking");
            if (r1 != null) {
                rank1 = Integer.parseInt(r1);
            }
            int rank2 = 0;
            String r2 = o2.getAttributes().get("ranking");
            if (r2 != null) {
                rank2 = Integer.parseInt(r2);
            }
            return rank2 - rank1;
        }
    }
}

