/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extensibility;

import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.extensibility.impl.ClassLoaderDelegate;

public class ClassLoaderContext {
    private ClassLoader classLoader;

    public ClassLoaderContext(ClassLoader parent, ServiceDiscovery discovery, Class<?> ... serviceTypes) {
        this(parent, ClassLoaderContext.getClassLoaders(discovery, serviceTypes));
    }

    private ClassLoaderContext(ClassLoader parent, List<ClassLoader> delegates) {
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>(delegates);
        loaders.remove(parent);
        this.classLoader = delegates.isEmpty() ? parent : new ClassLoaderDelegate(parent, loaders);
    }

    public ClassLoaderContext(ClassLoader parent, ClassLoader ... delegates) {
        this(parent, Arrays.asList(delegates));
    }

    public ClassLoaderContext(ClassLoader parent, ServiceDiscovery discovery, String ... serviceTypes) {
        this(parent, ClassLoaderContext.getClassLoaders(discovery, serviceTypes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doPrivileged(PrivilegedAction<T> action) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != this.classLoader) {
            Thread.currentThread().setContextClassLoader(this.classLoader);
        }
        try {
            T t = action.run();
            return t;
        }
        finally {
            if (tccl != this.classLoader) {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
    }

    public <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != this.classLoader) {
            Thread.currentThread().setContextClassLoader(this.classLoader);
        }
        try {
            T t = action.run();
            return t;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            if (tccl != this.classLoader) {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
    }

    public static ClassLoader setContextClassLoader(ClassLoader parent, ClassLoader ... delegates) {
        ClassLoaderContext context = new ClassLoaderContext(parent, delegates);
        return context.setContextClassLoader();
    }

    public static ClassLoader setContextClassLoader(ClassLoader parent, ServiceDiscovery discovery, String ... serviceNames) {
        ClassLoaderContext context = new ClassLoaderContext(parent, discovery, serviceNames);
        return context.setContextClassLoader();
    }

    public static ClassLoader setContextClassLoader(ClassLoader parent, ServiceDiscovery discovery, Class<?> ... serviceTypes) {
        ClassLoaderContext context = new ClassLoaderContext(parent, discovery, serviceTypes);
        return context.setContextClassLoader();
    }

    public ClassLoader setContextClassLoader() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != this.classLoader) {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            return tccl;
        }
        return null;
    }

    private static ClassLoader getClassLoader(ServiceDiscovery discovery, String serviceProvider) {
        try {
            ServiceDeclaration sd = discovery.getServiceDeclaration(serviceProvider);
            if (sd != null) {
                try {
                    if (sd.loadClass() != null) {
                        return sd.loadClass().getClassLoader();
                    }
                    return new ClassLoaderImpl(sd);
                }
                catch (ClassNotFoundException e) {
                    return new ClassLoaderImpl(sd);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static List<ClassLoader> getClassLoaders(ServiceDiscovery discovery, String ... serviceNames) {
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        for (String sp : serviceNames) {
            ClassLoader loader = ClassLoaderContext.getClassLoader(discovery, sp);
            if (loader == null || loaders.contains(loader)) continue;
            loaders.add(loader);
        }
        ClassLoader tccl = discovery.getContextClassLoader();
        if (!loaders.contains(tccl)) {
            loaders.add(tccl);
        }
        return loaders;
    }

    private static ClassLoader getClassLoader(ServiceDiscovery discovery, Class<?> serviceType) {
        try {
            ServiceDeclaration sd = discovery.getServiceDeclaration(serviceType);
            if (sd != null) {
                return sd.loadClass().getClassLoader();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static List<ClassLoader> getClassLoaders(ServiceDiscovery discovery, Class<?> ... serviceTypes) {
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        for (Class<?> serviceType : serviceTypes) {
            ClassLoader classLoader = ClassLoaderContext.getClassLoader(discovery, serviceType);
            if (classLoader == null || loaders.contains(classLoader)) continue;
            loaders.add(classLoader);
        }
        ClassLoader tccl = discovery.getContextClassLoader();
        if (!loaders.contains(tccl)) {
            loaders.add(tccl);
        }
        return loaders;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private static class ClassLoaderImpl
    extends ClassLoader {
        private final ServiceDeclaration sd;

        public ClassLoaderImpl(ServiceDeclaration sd) {
            this.sd = sd;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            return this.sd.loadClass(name);
        }

        @Override
        protected URL findResource(String name) {
            return this.sd.getResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return this.sd.getResources(name);
        }
    }
}

