/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.node;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.node.Node;
import org.apache.tuscany.sca.node.NodeFactory;
import org.apache.tuscany.sca.node.configuration.NodeConfiguration;
import org.apache.tuscany.sca.node.impl.NodeImpl;
import org.apache.tuscany.sca.runtime.EndpointRegistry;
import org.apache.tuscany.sca.runtime.ExtensibleDomainRegistryFactory;
import org.oasisopen.sca.NoSuchDomainException;
import org.oasisopen.sca.NoSuchServiceException;
import org.oasisopen.sca.client.SCAClientFactory;

public class DomainNode {
    private static final String DEFAULT_DOMAIN_SCHEME = "vm";
    private static final String DEFAULT_DOMAIN_NAME = "defaultDomain";
    private static final String DEFAULT_CONFIG_URI = "vm://defaultDomain";
    private String domainName;
    private String domainRegistryURI;
    private Map<String, Node> nodes = new HashMap<String, Node>();

    public DomainNode() {
        this(DEFAULT_CONFIG_URI, new String[0]);
    }

    public DomainNode(String ... contributionLocations) {
        this(DEFAULT_CONFIG_URI, contributionLocations);
    }

    public DomainNode(String configURI, String[] contributionLocations) {
        this.domainRegistryURI = configURI;
        this.initDomainName(configURI);
        if (contributionLocations == null || contributionLocations.length == 0) {
            this.addContribution(null, "_null");
        } else {
            for (String loc : contributionLocations) {
                this.addContribution(loc);
            }
        }
    }

    public void stop() {
        for (Node node : this.nodes.values()) {
            node.stop();
        }
    }

    public String addContribution(String location) {
        String uri = location;
        this.addContribution(uri, location);
        return uri;
    }

    public void addContribution(String location, String uri) {
        if (this.nodes.containsKey(uri)) {
            throw new IllegalArgumentException("contribution already added: " + uri);
        }
        NodeConfiguration configuration = NodeFactory.getInstance().createNodeConfiguration();
        if (location != null) {
            configuration.addContribution(uri, location);
        }
        configuration.setDomainRegistryURI(this.domainRegistryURI);
        configuration.setDomainURI(this.domainName);
        configuration.setURI(uri);
        Node node = NodeFactory.getInstance().createNode(configuration).start();
        this.nodes.put(uri, node);
    }

    public void removeContribution(String uri) {
        if (!this.nodes.containsKey(uri)) {
            throw new IllegalArgumentException("contribution not found: " + uri);
        }
        Node node = this.nodes.remove(uri);
        node.stop();
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getDomainConfigURI() {
        return this.domainRegistryURI;
    }

    public List<String> getServiceNames() {
        ArrayList<String> serviceNames = new ArrayList<String>();
        if (this.nodes.size() > 0) {
            ExtensionPointRegistry extensionsRegistry = ((NodeImpl)this.nodes.values().iterator().next()).getExtensionPointRegistry();
            ExtensibleDomainRegistryFactory domainRegistryFactory = ExtensibleDomainRegistryFactory.getInstance(extensionsRegistry);
            EndpointRegistry endpointRegistry = domainRegistryFactory.getEndpointRegistry(this.getDomainConfigURI(), this.getDomainName());
            for (Endpoint endpoint : endpointRegistry.getEndpoints()) {
                String name = endpoint.getComponent().getName() + "/" + endpoint.getService().getName();
                if (endpoint.getBinding() != null && !endpoint.getService().getName().equals(endpoint.getBinding().getName())) {
                    name = name + "/" + endpoint.getBinding().getName();
                }
                serviceNames.add(name);
            }
        }
        return serviceNames;
    }

    public <T> T getService(Class<T> interfaze, String uri) throws NoSuchServiceException {
        try {
            return SCAClientFactory.newInstance(URI.create(this.getDomainName())).getService(interfaze, uri);
        }
        catch (NoSuchDomainException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void initDomainName(String configURI) {
        int i;
        this.domainName = configURI.startsWith("tuscany:vm:") ? configURI.substring("tuscany:vm:".length()) : (configURI.startsWith("tuscany:") ? ((i = configURI.indexOf(63)) == -1 ? configURI.substring("tuscany:".length()) : configURI.substring("tuscany:".length(), i)) : configURI);
    }

    protected String fixScheme(String uri) {
        int i = uri.indexOf(":");
        if (i > -1 && uri.charAt(i + 1) != '/') {
            uri = uri.replaceFirst(":", ":/");
        }
        if (i > -1 && uri.charAt(i + 2) != '/') {
            uri = uri.replaceFirst(":/", "://");
        }
        return uri;
    }
}

