/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.xml;

import javax.xml.transform.Source;
import org.apache.tuscany.sca.common.xml.dom.DOMHelper;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.xml.DOMDataBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Source2NodeTransformer
extends BaseTransformer<Source, Node>
implements PullTransformer<Source, Node> {
    private DOMHelper helper;

    public Source2NodeTransformer(ExtensionPointRegistry registry) {
        this.helper = DOMHelper.getInstance(registry);
    }

    @Override
    public Node transform(Source source, TransformationContext context) {
        try {
            Document doc = this.helper.load(source);
            return DOMDataBinding.adjustElementName(context, doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }

    @Override
    protected Class<Source> getSourceType() {
        return Source.class;
    }

    @Override
    protected Class<Node> getTargetType() {
        return Node.class;
    }

    @Override
    public int getWeight() {
        return 40;
    }
}

