/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.xml;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.common.xml.stax.reader.SimpleXmlNodeImpl;
import org.apache.tuscany.sca.common.xml.stax.reader.XmlNode;
import org.apache.tuscany.sca.common.xml.stax.reader.XmlTreeStreamReaderImpl;
import org.apache.tuscany.sca.databinding.SimpleTypeMapper;
import org.apache.tuscany.sca.databinding.impl.SimpleTypeMapperImpl;
import org.apache.tuscany.sca.interfacedef.util.TypeInfo;

public class BeanXMLStreamReaderImpl
extends XmlTreeStreamReaderImpl {
    private static final Comparator<Accessor> COMPARATOR = new Comparator<Accessor>(){

        @Override
        public int compare(Accessor o1, Accessor o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public BeanXMLStreamReaderImpl(QName name, Object bean) {
        super(BeanXMLStreamReaderImpl.getXmlNode(name, bean));
    }

    private static BeanXmlNodeImpl getXmlNode(QName name, Object bean) {
        BeanXmlNodeImpl root = null;
        root = name != null ? new BeanXmlNodeImpl(name, bean) : new BeanXmlNodeImpl(bean);
        return root;
    }

    private static Map<String, Accessor> getAccessors(Object target) throws Exception {
        if (target == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Accessor> map = new HashMap<String, Accessor>();
        Class<?> type = target.getClass();
        for (Field f : type.getFields()) {
            map.put(f.getName(), new FieldAccessor(target, f));
        }
        BeanInfo info = Introspector.getBeanInfo(type, Object.class);
        for (PropertyDescriptor p : info.getPropertyDescriptors()) {
            map.put(p.getName(), new PropertyAccessor(target, p));
        }
        return map;
    }

    private static class PropertyAccessor
    implements Accessor {
        private Object target;
        private PropertyDescriptor prop;

        public PropertyAccessor(Object target, PropertyDescriptor prop) {
            this.target = target;
            this.prop = prop;
        }

        @Override
        public String getName() {
            return this.prop.getName();
        }

        @Override
        public Class<?> getType() {
            return this.prop.getPropertyType();
        }

        @Override
        public Object getValue() throws Exception {
            Method getter = this.prop.getReadMethod();
            if (getter != null) {
                getter.setAccessible(true);
                return getter.invoke(this.target, new Object[0]);
            }
            throw new IllegalAccessException("The property cannot be read: " + this.getName());
        }

        @Override
        public void setValue(Object value) throws Exception {
            Method setter = this.prop.getWriteMethod();
            if (setter != null) {
                setter.setAccessible(true);
                setter.invoke(this.target, new Object[0]);
            }
            throw new IllegalAccessException("The property cannot be written: " + this.getName());
        }
    }

    private static class FieldAccessor
    implements Accessor {
        private Object target;
        private Field field;

        public FieldAccessor(Object target, Field field) {
            this.target = target;
            this.field = field;
            this.field.setAccessible(true);
        }

        @Override
        public String getName() {
            return this.field.getName();
        }

        @Override
        public Object getValue() throws Exception {
            return this.field.get(this.target);
        }

        @Override
        public void setValue(Object value) throws Exception {
            this.field.set(this.target, value);
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }
    }

    public static interface Accessor {
        public String getName();

        public Class<?> getType();

        public Object getValue() throws Exception;

        public void setValue(Object var1) throws Exception;
    }

    public static class BeanXmlNodeImpl
    extends SimpleXmlNodeImpl
    implements XmlNode {
        private static final Object[] NULL = null;
        private static final SimpleTypeMapper MAPPER = new SimpleTypeMapperImpl();

        public BeanXmlNodeImpl(Object bean) {
            super(BeanXmlNodeImpl.getName(bean == null ? null : bean.getClass()), bean);
        }

        public BeanXmlNodeImpl(QName name, Object bean) {
            super(name, bean);
        }

        private static boolean isSimpleType(Class<?> javaType) {
            return MAPPER.getXMLType(javaType) != null;
        }

        private static String getStringValue(Object o) {
            if (o == null) {
                return null;
            }
            TypeInfo info = MAPPER.getXMLType(o.getClass());
            if (info != null) {
                return MAPPER.toXMLLiteral(info.getQName(), o, null);
            }
            return String.valueOf(o);
        }

        @Override
        public Iterator<XmlNode> children() {
            if (this.name == null) {
                return null;
            }
            if (this.value == null) {
                return super.children();
            }
            if (BeanXmlNodeImpl.isSimpleType(this.value.getClass())) {
                BeanXmlNodeImpl textNode = new BeanXmlNodeImpl(null, this.value);
                return Arrays.asList(textNode).iterator();
            }
            if (Map.class.isAssignableFrom(this.value.getClass())) {
                ArrayList<BeanXmlNodeImpl> entries = new ArrayList<BeanXmlNodeImpl>();
                QName entryName = new QName(this.name.getNamespaceURI(), "entry");
                Map map = (Map)this.value;
                if (map != null) {
                    Iterator i$ = map.entrySet().iterator();
                    while (i$.hasNext()) {
                        Map.Entry e;
                        Map.Entry entry = e = i$.next();
                        entries.add(new BeanXmlNodeImpl(entryName, entry));
                    }
                }
                return entries.iterator();
            }
            try {
                Map accessorMap = BeanXMLStreamReaderImpl.getAccessors(this.value);
                ArrayList accessorList = new ArrayList(accessorMap.values());
                Collections.sort(accessorList, COMPARATOR);
                ArrayList<BeanXmlNodeImpl> props = new ArrayList<BeanXmlNodeImpl>();
                for (Accessor accessor : accessorList) {
                    Class<?> pType = accessor.getType();
                    QName pName = new QName(this.name.getNamespaceURI(), accessor.getName());
                    Object pValue = accessor.getValue();
                    if (pType.isArray()) {
                        if (pValue == null) continue;
                        int i1 = Array.getLength(pValue);
                        for (int j = 0; j < i1; ++j) {
                            Object o = Array.get(pValue, j);
                            props.add(new BeanXmlNodeImpl(pName, o));
                        }
                        continue;
                    }
                    if (Collection.class.isAssignableFrom(pType)) {
                        Collection objList = (Collection)pValue;
                        if (objList == null || objList.size() <= 0) continue;
                        for (Object o : objList) {
                            props.add(new BeanXmlNodeImpl(pName, o));
                        }
                        continue;
                    }
                    props.add(new BeanXmlNodeImpl(pName, pValue));
                }
                return props.iterator();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public QName getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return BeanXmlNodeImpl.getStringValue(this.value);
        }

        private static String getPackageName(Class<?> cls) {
            String name = cls.getName();
            int index = name.lastIndexOf(46);
            return index == -1 ? "" : name.substring(0, index);
        }

        public static QName getName(Class<?> cls) {
            if (cls == null) {
                return null;
            }
            String packageName = BeanXmlNodeImpl.getPackageName(cls);
            if ("".equals(packageName)) {
                return new QName("", cls.getSimpleName());
            }
            StringBuffer ns = new StringBuffer("http://");
            String[] names = packageName.split("\\.");
            for (int i = names.length - 1; i >= 0; --i) {
                ns.append(names[i]);
                if (i == 0) continue;
                ns.append('.');
            }
            ns.append('/');
            return new QName(ns.toString(), cls.getSimpleName());
        }
    }
}

