/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.PushTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBDataBinding;
import org.xml.sax.ContentHandler;

public class JAXB2SAX
extends BaseTransformer<Object, ContentHandler>
implements PushTransformer<Object, ContentHandler> {
    private JAXBContextHelper contextHelper;

    public JAXB2SAX(ExtensionPointRegistry registry) {
        this.contextHelper = JAXBContextHelper.getInstance(registry);
    }

    @Override
    protected Class<Object> getSourceType() {
        return Object.class;
    }

    @Override
    protected Class<ContentHandler> getTargetType() {
        return ContentHandler.class;
    }

    @Override
    public void transform(Object source, ContentHandler target, TransformationContext tContext) {
        try {
            JAXBContext context = this.contextHelper.createJAXBContext(tContext, true);
            Marshaller marshaller = context.createMarshaller();
            Object jaxbElement = JAXBContextHelper.createJAXBElement(context, tContext.getSourceDataType(), source);
            marshaller.marshal(jaxbElement, target);
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }

    @Override
    public int getWeight() {
        return 20;
    }

    @Override
    public String getSourceDataBinding() {
        return JAXBDataBinding.NAME;
    }
}

