/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.tuscany.sca.common.xml.dom.DOMHelper;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBDataBinding;
import org.apache.tuscany.sca.databinding.xml.DOMDataBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JAXB2Node
extends BaseTransformer<Object, Node>
implements PullTransformer<Object, Node> {
    private DOMHelper helper;
    private JAXBContextHelper contextHelper;

    public JAXB2Node(ExtensionPointRegistry registry) {
        this.helper = DOMHelper.getInstance(registry);
        this.contextHelper = JAXBContextHelper.getInstance(registry);
    }

    @Override
    public Node transform(Object source, TransformationContext tContext) {
        try {
            JAXBContext context = this.contextHelper.createJAXBContext(tContext, true);
            Marshaller marshaller = context.createMarshaller();
            Document document = this.helper.newDocument();
            Object jaxbElement = JAXBContextHelper.createJAXBElement(context, tContext.getSourceDataType(), source);
            marshaller.marshal(jaxbElement, (Node)document);
            return DOMDataBinding.adjustElementName(tContext, document.getDocumentElement());
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }

    @Override
    protected Class<Object> getSourceType() {
        return Object.class;
    }

    @Override
    protected Class<Node> getTargetType() {
        return Node.class;
    }

    @Override
    public int getWeight() {
        return 30;
    }

    @Override
    public String getSourceDataBinding() {
        return JAXBDataBinding.NAME;
    }
}

