/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.javabeans;

import javax.xml.namespace.QName;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.BaseDataBinding;
import org.apache.tuscany.sca.databinding.SimpleTypeMapper;
import org.apache.tuscany.sca.databinding.impl.SimpleTypeMapperImpl;
import org.apache.tuscany.sca.databinding.xml.XMLStringDataBinding;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.TypeInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

public class SimpleJavaDataBinding
extends BaseDataBinding {
    public static final String NAME = "java:simpleType";
    private SimpleTypeMapper simpleTypeMapper = new SimpleTypeMapperImpl();

    public SimpleJavaDataBinding(ExtensionPointRegistry registry) {
        super(NAME, Object.class);
    }

    @Override
    public Object copy(Object arg, DataType sourceDataType, DataType targetDataType, Operation sourceOperation, Operation targetOperation) {
        if (arg instanceof byte[]) {
            return ((byte[])arg).clone();
        }
        return arg;
    }

    @Override
    public boolean introspect(DataType type, Operation operation) {
        Class<?> cls = type.getPhysical();
        if (cls == Object.class) {
            return false;
        }
        String db = type.getDataBinding();
        if (db != null && XMLStringDataBinding.NAME.equals(db)) {
            return false;
        }
        if (SimpleTypeMapperImpl.JAVA2XML.keySet().contains(cls)) {
            TypeInfo typeInfo;
            type.setDataBinding(NAME);
            QName elementName = null;
            Object logical = type.getLogical();
            if (logical instanceof XMLType) {
                elementName = ((XMLType)logical).getElementName();
            }
            type.setLogical(new XMLType(elementName, (typeInfo = this.simpleTypeMapper.getXMLType(cls)) == null ? null : typeInfo.getQName()));
            return true;
        }
        return false;
    }
}

