/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.impl;

import java.awt.Image;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.tuscany.sca.databinding.SimpleTypeMapper;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.impl.XSDDataTypeConverter;
import org.apache.tuscany.sca.interfacedef.util.TypeInfo;

public class SimpleTypeMapperImpl
extends XSDDataTypeConverter
implements SimpleTypeMapper {
    public static final Map<Class, String> JAVA2XML = new HashMap<Class, String>();
    public static final String URI_2001_SCHEMA_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final Map<String, Class> XML2JAVA = new HashMap<String, Class>();
    public static final QName XSD_ANY = new QName("http://www.w3.org/2001/XMLSchema", "any");
    public static final QName XSD_ANYSIMPLETYPE = new QName("http://www.w3.org/2001/XMLSchema", "anySimpleType");
    public static final QName XSD_ANYTYPE = new QName("http://www.w3.org/2001/XMLSchema", "anyType");
    public static final QName XSD_ANYURI = new QName("http://www.w3.org/2001/XMLSchema", "anyURI");
    public static final QName XSD_BASE64 = new QName("http://www.w3.org/2001/XMLSchema", "base64Binary");
    public static final QName XSD_BOOLEAN = new QName("http://www.w3.org/2001/XMLSchema", "boolean");
    public static final QName XSD_BYTE = new QName("http://www.w3.org/2001/XMLSchema", "byte");
    public static final QName XSD_DATE = new QName("http://www.w3.org/2001/XMLSchema", "date");
    public static final QName XSD_DATETIME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime");
    public static final QName XSD_DAY = new QName("http://www.w3.org/2001/XMLSchema", "gDay");
    public static final QName XSD_DECIMAL = new QName("http://www.w3.org/2001/XMLSchema", "decimal");
    public static final QName XSD_DOUBLE = new QName("http://www.w3.org/2001/XMLSchema", "double");
    public static final QName XSD_DURATION = new QName("http://www.w3.org/2001/XMLSchema", "duration");
    public static final QName XSD_ENTITIES = new QName("http://www.w3.org/2001/XMLSchema", "ENTITIES");
    public static final QName XSD_ENTITY = new QName("http://www.w3.org/2001/XMLSchema", "ENTITY");
    public static final QName XSD_FLOAT = new QName("http://www.w3.org/2001/XMLSchema", "float");
    public static final QName XSD_HEXBIN = new QName("http://www.w3.org/2001/XMLSchema", "hexBinary");
    public static final QName XSD_IDREF = new QName("http://www.w3.org/2001/XMLSchema", "IDREF");
    public static final QName XSD_IDREFS = new QName("http://www.w3.org/2001/XMLSchema", "IDREFS");
    public static final QName XSD_INT = new QName("http://www.w3.org/2001/XMLSchema", "int");
    public static final QName XSD_INTEGER = new QName("http://www.w3.org/2001/XMLSchema", "integer");
    public static final QName XSD_LONG = new QName("http://www.w3.org/2001/XMLSchema", "long");
    public static final QName XSD_MONTH = new QName("http://www.w3.org/2001/XMLSchema", "gMonth");
    public static final QName XSD_MONTHDAY = new QName("http://www.w3.org/2001/XMLSchema", "gMonthDay");
    public static final QName XSD_NAME = new QName("http://www.w3.org/2001/XMLSchema", "Name");
    public static final QName XSD_NCNAME = new QName("http://www.w3.org/2001/XMLSchema", "NCName");
    public static final QName XSD_NEGATIVEINTEGER = new QName("http://www.w3.org/2001/XMLSchema", "negativeInteger");
    public static final QName XSD_NMTOKEN = new QName("http://www.w3.org/2001/XMLSchema", "NMTOKEN");
    public static final QName XSD_NMTOKENS = new QName("http://www.w3.org/2001/XMLSchema", "NMTOKENS");
    public static final QName XSD_NONNEGATIVEINTEGER = new QName("http://www.w3.org/2001/XMLSchema", "nonNegativeInteger");
    public static final QName XSD_NONPOSITIVEINTEGER = new QName("http://www.w3.org/2001/XMLSchema", "nonPositiveInteger");
    public static final QName XSD_NORMALIZEDSTRING = new QName("http://www.w3.org/2001/XMLSchema", "normalizedString");
    public static final QName XSD_NOTATION = new QName("http://www.w3.org/2001/XMLSchema", "NOTATION");
    public static final QName XSD_POSITIVEINTEGER = new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger");
    public static final QName XSD_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "QName");
    public static final QName XSD_SHORT = new QName("http://www.w3.org/2001/XMLSchema", "short");
    public static final Map<String, TypeInfo> XSD_SIMPLE_TYPES = new HashMap<String, TypeInfo>();
    public static final QName XSD_STRING = new QName("http://www.w3.org/2001/XMLSchema", "string");
    public static final QName XSD_TIME = new QName("http://www.w3.org/2001/XMLSchema", "time");
    public static final QName XSD_TOKEN = new QName("http://www.w3.org/2001/XMLSchema", "token");
    public static final QName XSD_UNSIGNEDBYTE = new QName("http://www.w3.org/2001/XMLSchema", "unsignedByte");
    public static final QName XSD_UNSIGNEDINT = new QName("http://www.w3.org/2001/XMLSchema", "unsignedInt");
    public static final QName XSD_UNSIGNEDLONG = new QName("http://www.w3.org/2001/XMLSchema", "unsignedLong");
    public static final QName XSD_UNSIGNEDSHORT = new QName("http://www.w3.org/2001/XMLSchema", "unsignedShort");
    public static final QName XSD_YEAR = new QName("http://www.w3.org/2001/XMLSchema", "gYear");
    public static final QName XSD_YEARMONTH = new QName("http://www.w3.org/2001/XMLSchema", "gYearMonth");
    private static final String[] XSD_TYPE_NAMES;
    private DatatypeFactory factory;

    public SimpleTypeMapperImpl() {
        try {
            this.factory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Class<?> getJavaType(QName xmlType) {
        if (xmlType != null && URI_2001_SCHEMA_XSD.equals(xmlType.getNamespaceURI())) {
            return XML2JAVA.get(xmlType.getLocalPart());
        }
        return null;
    }

    public TypeInfo getXMLType(Class javaType) {
        return XSD_SIMPLE_TYPES.get(JAVA2XML.get(javaType));
    }

    @Override
    public Object toJavaObject(QName simpleType, String literal, TransformationContext context) {
        if (literal == null) {
            return null;
        }
        String value = literal.trim();
        QName type = simpleType;
        if (type.equals(XSD_STRING)) {
            return this.parseString(value);
        }
        if (type.equals(XSD_INT)) {
            return this.parseInt(value);
        }
        if (type.equals(XSD_INTEGER)) {
            return this.parseInteger(value);
        }
        if (type.equals(XSD_INT)) {
            return this.parseInt(value);
        }
        if (type.equals(XSD_FLOAT)) {
            return Float.valueOf(this.parseFloat(value));
        }
        if (type.equals(XSD_DOUBLE)) {
            return this.parseDouble(value);
        }
        if (type.equals(XSD_SHORT)) {
            return this.parseShort(value);
        }
        if (type.equals(XSD_DECIMAL)) {
            return this.parseDecimal(value);
        }
        if (type.equals(XSD_BOOLEAN)) {
            return this.parseBoolean(value);
        }
        if (type.equals(XSD_BYTE)) {
            return this.parseByte(value);
        }
        if (type.equals(XSD_LONG)) {
            return this.parseLong(value);
        }
        if (type.equals(XSD_UNSIGNEDBYTE)) {
            return this.parseUnsignedShort(value);
        }
        if (type.equals(XSD_UNSIGNEDSHORT)) {
            return this.parseUnsignedShort(value);
        }
        if (type.equals(XSD_UNSIGNEDINT)) {
            return this.parseUnsignedInt(value);
        }
        if (type.equals(XSD_UNSIGNEDLONG)) {
            return this.parseUnsignedInt(value);
        }
        if (type.equals(XSD_DATETIME)) {
            return this.parseDateTime(value);
        }
        if (type.equals(XSD_DATE)) {
            return this.parseDate(value);
        }
        if (type.equals(XSD_TIME)) {
            return this.parseTime(value);
        }
        if (type.equals(XSD_DURATION)) {
            return this.parseDuration(value);
        }
        if (type.equals(XSD_HEXBIN)) {
            return this.parseHexBinary(value);
        }
        if (type.equals(XSD_BASE64)) {
            return this.parseBase64Binary(value);
        }
        if (type.equals(XSD_QNAME)) {
            NamespaceContext namespaceContext = (NamespaceContext)(context != null ? context.getMetadata().get(NamespaceContext.class.getName()) : null);
            return this.parseQName(value, namespaceContext);
        }
        if (type.equals(XSD_NOTATION)) {
            NamespaceContext namespaceContext = (NamespaceContext)(context != null ? context.getMetadata().get(NamespaceContext.class.getName()) : null);
            return this.parseQName(value, namespaceContext);
        }
        if (type.equals(XSD_YEAR)) {
            return this.factory.newXMLGregorianCalendar(value);
        }
        if (type.equals(XSD_MONTH)) {
            return this.factory.newXMLGregorianCalendar(value);
        }
        if (type.equals(XSD_DAY)) {
            return this.factory.newXMLGregorianCalendar(value);
        }
        if (type.equals(XSD_YEARMONTH)) {
            return this.factory.newXMLGregorianCalendar(value);
        }
        if (type.equals(XSD_MONTHDAY)) {
            return this.factory.newXMLGregorianCalendar(value);
        }
        return value;
    }

    private XMLGregorianCalendar toXMLGregorianCalendar(Date date) {
        GregorianCalendar c = new GregorianCalendar(date.getYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds());
        return this.factory.newXMLGregorianCalendar(c);
    }

    private XMLGregorianCalendar toXMLGregorianCalendar(GregorianCalendar calendar) {
        return this.factory.newXMLGregorianCalendar(calendar);
    }

    @Override
    public String toXMLLiteral(QName simpleType, Object obj, TransformationContext context) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Float || obj instanceof Double) {
            if (obj instanceof Float) {
                return this.printDouble(((Float)obj).floatValue());
            }
            return this.printDouble((Double)obj);
        }
        if (obj instanceof GregorianCalendar) {
            GregorianCalendar calendar = (GregorianCalendar)obj;
            return this.toXMLGregorianCalendar(calendar).toXMLFormat();
        }
        if (obj instanceof Date) {
            return this.toXMLGregorianCalendar((Date)obj).toXMLFormat();
        }
        if (obj instanceof XMLGregorianCalendar) {
            return ((XMLGregorianCalendar)obj).toXMLFormat();
        }
        if (obj instanceof byte[]) {
            if (simpleType != null) {
                if (simpleType.equals(XSD_BASE64)) {
                    return this.printBase64Binary((byte[])obj);
                }
                if (simpleType.equals(XSD_HEXBIN)) {
                    return this.printHexBinary((byte[])obj);
                }
            }
        } else if (obj instanceof QName) {
            NamespaceContext namespaceContext = (NamespaceContext)(context != null ? context.getMetadata().get(NamespaceContext.class.getName()) : null);
            return this.printQName((QName)obj, namespaceContext);
        }
        return obj.toString();
    }

    @Override
    public boolean isSimpleXSDType(QName typeName) {
        if (typeName == null) {
            return false;
        }
        return typeName.getNamespaceURI().equals(URI_2001_SCHEMA_XSD) && XSD_SIMPLE_TYPES.get(typeName.getLocalPart()) != null;
    }

    static {
        for (String type : XSD_TYPE_NAMES = new String[]{"string", "boolean", "double", "float", "int", "integer", "long", "short", "byte", "decimal", "base64Binary", "hexBinary", "anySimpleType", "anyType", "any", "QName", "dateTime", "date", "time", "normalizedString", "token", "unsignedLong", "unsignedInt", "unsignedShort", "unsignedByte", "positiveInteger", "negativeInteger", "nonNegativeInteger", "nonPositiveInteger", "gYearMonth", "gMonthDay", "gYear", "gMonth", "gDay", "duration", "Name", "NCName", "NMTOKEN", "NMTOKENS", "NOTATION", "ENTITY", "ENTITIES", "IDREF", "IDREFS", "anyURI", "language", "ID"}) {
            TypeInfo simpleType = new TypeInfo(new QName(URI_2001_SCHEMA_XSD, type), true, null);
            XSD_SIMPLE_TYPES.put(type, simpleType);
        }
        JAVA2XML.put(Boolean.TYPE, "boolean");
        JAVA2XML.put(Byte.TYPE, "byte");
        JAVA2XML.put(Short.TYPE, "short");
        JAVA2XML.put(Integer.TYPE, "int");
        JAVA2XML.put(Long.TYPE, "long");
        JAVA2XML.put(Float.TYPE, "float");
        JAVA2XML.put(Double.TYPE, "double");
        JAVA2XML.put(Boolean.class, "boolean");
        JAVA2XML.put(Byte.class, "byte");
        JAVA2XML.put(Short.class, "short");
        JAVA2XML.put(Integer.class, "int");
        JAVA2XML.put(Long.class, "long");
        JAVA2XML.put(Float.class, "float");
        JAVA2XML.put(Double.class, "double");
        JAVA2XML.put(String.class, "string");
        JAVA2XML.put(BigInteger.class, "integer");
        JAVA2XML.put(BigDecimal.class, "decimal");
        JAVA2XML.put(Calendar.class, "dateTime");
        JAVA2XML.put(Date.class, "dateTime");
        JAVA2XML.put(QName.class, "QName");
        JAVA2XML.put(URI.class, "string");
        JAVA2XML.put(XMLGregorianCalendar.class, "anySimpleType");
        JAVA2XML.put(Duration.class, "duration");
        JAVA2XML.put(Object.class, "anyType");
        JAVA2XML.put(Image.class, "base64Binary");
        JAVA2XML.put(byte[].class, "base64Binary");
        JAVA2XML.put(Source.class, "base64Binary");
        JAVA2XML.put(UUID.class, "string");
        XML2JAVA.put("string", String.class);
        XML2JAVA.put("integer", BigInteger.class);
        XML2JAVA.put("int", Integer.TYPE);
        XML2JAVA.put("long", Long.TYPE);
        XML2JAVA.put("short", Short.TYPE);
        XML2JAVA.put("decimal", BigDecimal.class);
        XML2JAVA.put("float", Float.TYPE);
        XML2JAVA.put("double", Double.TYPE);
        XML2JAVA.put("boolean", Boolean.TYPE);
        XML2JAVA.put("byte", Byte.TYPE);
        XML2JAVA.put("QName", QName.class);
        XML2JAVA.put("dateTime", XMLGregorianCalendar.class);
        XML2JAVA.put("base64Binary", byte[].class);
        XML2JAVA.put("hexBinary", byte[].class);
        XML2JAVA.put("unsignedInt", Long.TYPE);
        XML2JAVA.put("unsignedShort", Integer.TYPE);
        XML2JAVA.put("unsignedByte", Short.TYPE);
        XML2JAVA.put("time", XMLGregorianCalendar.class);
        XML2JAVA.put("date", XMLGregorianCalendar.class);
        XML2JAVA.put("gDay", XMLGregorianCalendar.class);
        XML2JAVA.put("gMonth", XMLGregorianCalendar.class);
        XML2JAVA.put("gYear", XMLGregorianCalendar.class);
        XML2JAVA.put("gYearMonth", XMLGregorianCalendar.class);
        XML2JAVA.put("gMonthDay", XMLGregorianCalendar.class);
        XML2JAVA.put("anySimpleType", Object.class);
        XML2JAVA.put("duration", Duration.class);
        XML2JAVA.put("NOTATION", QName.class);
    }
}

