/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.impl;

import org.apache.tuscany.sca.databinding.DataPipe;
import org.apache.tuscany.sca.databinding.DataPipeTransformer;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.PushTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;

public class PipedTransformer<S, I, R>
implements PullTransformer<S, R> {
    private PushTransformer<S, I> pusher;
    private DataPipeTransformer<I, R> pipe;

    public PipedTransformer(PushTransformer<S, I> pumper, DataPipeTransformer<I, R> pipe) {
        this.pusher = pumper;
        this.pipe = pipe;
    }

    @Override
    public R transform(S source, TransformationContext context) {
        DataPipe<I, R> dataPipe = this.pipe.newInstance();
        this.pusher.transform(source, dataPipe.getSink(), context);
        return dataPipe.getResult();
    }

    @Override
    public String getSourceDataBinding() {
        return this.pusher.getSourceDataBinding();
    }

    @Override
    public String getTargetDataBinding() {
        return this.pipe.getTargetDataBinding();
    }

    @Override
    public int getWeight() {
        return this.pusher.getWeight() + this.pipe.getWeight();
    }
}

