/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBinding;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.DataPipe;
import org.apache.tuscany.sca.databinding.DataPipeTransformer;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.PushTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.Transformer;
import org.apache.tuscany.sca.databinding.TransformerExtensionPoint;
import org.apache.tuscany.sca.databinding.impl.TransformationContextImpl;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.FaultExceptionMapper;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.oasisopen.sca.ServiceRuntimeException;

public class MediatorImpl
implements Mediator {
    private ExtensionPointRegistry registry;
    private DataBindingExtensionPoint dataBindings;
    private TransformerExtensionPoint transformers;
    private InterfaceContractMapper interfaceContractMapper;
    private FaultExceptionMapper faultExceptionMapper;

    MediatorImpl(DataBindingExtensionPoint dataBindings, TransformerExtensionPoint transformers) {
        this.dataBindings = dataBindings;
        this.transformers = transformers;
    }

    public MediatorImpl(ExtensionPointRegistry registry) {
        this.registry = registry;
        this.dataBindings = registry.getExtensionPoint(DataBindingExtensionPoint.class);
        this.transformers = registry.getExtensionPoint(TransformerExtensionPoint.class);
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.interfaceContractMapper = utilities.getUtility(InterfaceContractMapper.class);
        this.faultExceptionMapper = utilities.getUtility(FaultExceptionMapper.class);
    }

    @Override
    public Object mediate(Object source, DataType sourceDataType, DataType targetDataType, Map<String, Object> metadata) {
        if ((sourceDataType == null || sourceDataType.getDataBinding() == null) && source != null) {
            Operation operation = (Operation)metadata.get("source.operation");
            sourceDataType = this.dataBindings.introspectType(source, operation);
        }
        if (sourceDataType == null || targetDataType == null) {
            return source;
        }
        if (sourceDataType.equals(targetDataType)) {
            return source;
        }
        List<Transformer> path = this.getTransformerChain(sourceDataType, targetDataType);
        Object result = source;
        int size = path.size();
        for (int i = 0; i < size; ++i) {
            Transformer transformer = path.get(i);
            TransformationContext context = this.createTransformationContext(sourceDataType, targetDataType, size, i, transformer, metadata);
            if (transformer instanceof PullTransformer) {
                result = ((PullTransformer)transformer).transform(result, context);
                continue;
            }
            if (!(transformer instanceof PushTransformer)) continue;
            DataPipeTransformer dataPipeFactory = i < size - 1 ? (DataPipeTransformer)path.get(++i) : null;
            DataPipe dataPipe = dataPipeFactory == null ? null : dataPipeFactory.newInstance();
            ((PushTransformer)transformer).transform(result, dataPipe.getSink(), context);
            result = dataPipe.getResult();
        }
        return result;
    }

    private TransformationContext createTransformationContext(DataType sourceDataType, DataType targetDataType, int size, int index, Transformer transformer, Map<String, Object> metadata) {
        DataType sourceType = index == 0 ? sourceDataType : new DataTypeImpl(transformer.getSourceDataBinding(), Object.class, sourceDataType.getLogical());
        DataType targetType = index == size - 1 ? targetDataType : new DataTypeImpl(transformer.getTargetDataBinding(), Object.class, targetDataType.getLogical());
        HashMap<String, Object> copy = new HashMap<String, Object>();
        if (metadata != null) {
            copy.putAll(metadata);
        }
        copy.put(ExtensionPointRegistry.class.getName(), this.registry);
        TransformationContextImpl context = new TransformationContextImpl(sourceType, targetType, copy);
        return context;
    }

    @Override
    public void mediate(Object source, Object target, DataType sourceDataType, DataType targetDataType, Map<String, Object> metadata) {
        if (source == null) {
            return;
        }
        if (sourceDataType == null || sourceDataType.getDataBinding() == null) {
            Operation operation = (Operation)metadata.get("source.operation");
            sourceDataType = this.dataBindings.introspectType(source, operation);
        }
        if (sourceDataType == null) {
            return;
        }
        if (sourceDataType.equals(targetDataType)) {
            return;
        }
        List<Transformer> path = this.getTransformerChain(sourceDataType, targetDataType);
        Object result = source;
        int size = path.size();
        for (int i = 0; i < size; ++i) {
            Transformer transformer = path.get(i);
            TransformationContext context = this.createTransformationContext(sourceDataType, targetDataType, size, i, transformer, metadata);
            if (transformer instanceof PullTransformer) {
                result = ((PullTransformer)transformer).transform(result, context);
                continue;
            }
            if (!(transformer instanceof PushTransformer)) continue;
            DataPipeTransformer dataPipeFactory = i < size - 1 ? (DataPipeTransformer)path.get(++i) : null;
            DataPipe dataPipe = dataPipeFactory == null ? null : dataPipeFactory.newInstance();
            Object sink = dataPipe != null ? dataPipe.getSink() : target;
            ((PushTransformer)transformer).transform(result, sink, context);
            result = dataPipe != null ? dataPipe.getResult() : null;
        }
    }

    private List<Transformer> getTransformerChain(DataType sourceDataType, DataType targetDataType) {
        String targetId;
        String sourceId = sourceDataType.getDataBinding();
        List<Transformer> path = this.transformers.getTransformerChain(sourceId, targetId = targetDataType.getDataBinding());
        if (path == null) {
            TransformationException ex = new TransformationException("No path found for the transformation: " + sourceId + "->" + targetId);
            ex.setSourceDataBinding(sourceId);
            ex.setTargetDataBinding(targetId);
            throw ex;
        }
        return path;
    }

    @Override
    public DataBindingExtensionPoint getDataBindings() {
        return this.dataBindings;
    }

    @Override
    public TransformerExtensionPoint getTransformers() {
        return this.transformers;
    }

    private DataType getFaultType(DataType exceptionType) {
        return exceptionType == null ? null : (DataType)exceptionType.getLogical();
    }

    private boolean matches(QName qn1, QName qn2) {
        String e2;
        if (qn1 == qn2) {
            return true;
        }
        if (qn1 == null || qn2 == null) {
            return false;
        }
        String ns1 = qn1.getNamespaceURI();
        String ns2 = qn2.getNamespaceURI();
        String e1 = qn1.getLocalPart();
        return e1.equals(e2 = qn2.getLocalPart()) && (ns1.equals(ns2) || ns1.equals(ns2 + "/") || ns2.equals(ns1 + "/"));
    }

    private Object transformException(Object source, DataType sourceExType, DataType targetExType, DataType sourceType, DataType targetType, Map<String, Object> metadata) {
        if (sourceType == targetType || sourceType != null && sourceType.equals(targetType)) {
            return source;
        }
        DataTypeImpl<DataType> eSourceDataType = new DataTypeImpl<DataType>("idl:fault", sourceExType.getPhysical(), sourceType);
        DataTypeImpl<DataType> eTargetDataType = new DataTypeImpl<DataType>("idl:fault", targetExType.getPhysical(), targetType);
        return this.mediate(source, eSourceDataType, eTargetDataType, metadata);
    }

    @Override
    public Object mediateFault(Object result, Operation sourceOperation, Operation targetOperation, Map<String, Object> metadata) {
        DataType targetDataType;
        DataType targetFaultType;
        if (result instanceof InvocationTargetException) {
            result = ((InvocationTargetException)result).getCause();
        }
        if ((targetFaultType = this.getFaultType(targetDataType = this.findFaultDataType(targetOperation, result))) == null) {
            Throwable cause = (Throwable)result;
            throw new ServiceRuntimeException(cause);
        }
        DataType sourceDataType = null;
        DataType sourceFaultType = null;
        for (DataType exType : sourceOperation.getFaultTypes()) {
            DataType faultType = this.getFaultType(exType);
            if (faultType == null || !this.typesMatch(targetFaultType.getLogical(), faultType.getLogical())) continue;
            sourceDataType = exType;
            sourceFaultType = faultType;
            break;
        }
        if (sourceFaultType == null) {
            Throwable cause = (Throwable)result;
            throw new ServiceRuntimeException(cause);
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (metadata != null) {
            context.putAll(metadata);
        }
        if (targetOperation != null) {
            context.put("source.operation", targetOperation);
        }
        if (sourceOperation != null) {
            context.put("target.operation", sourceOperation);
        }
        if (context.get("body.type") == null) {
            context.put("body.type", "fault");
        }
        Object newResult = this.transformException(result, targetDataType, sourceDataType, targetFaultType, sourceFaultType, context);
        return newResult;
    }

    private DataType findFaultDataType(Operation operation, Object faultOrException) {
        DataType targetDataType = null;
        for (DataType exType : operation.getFaultTypes()) {
            if (!exType.getPhysical().isInstance(faultOrException)) continue;
            if (faultOrException instanceof FaultException) {
                DataType faultType = (DataType)exType.getLogical();
                if (!((FaultException)faultOrException).isMatchingType(faultType.getLogical())) continue;
                targetDataType = exType;
                break;
            }
            targetDataType = exType;
            break;
        }
        return targetDataType;
    }

    private boolean typesMatch(Object first, Object second) {
        if (first.equals(second)) {
            return true;
        }
        if (first instanceof XMLType && second instanceof XMLType) {
            XMLType t1 = (XMLType)first;
            XMLType t2 = (XMLType)second;
            return this.matches(t1.getElementName(), t2.getElementName());
        }
        return false;
    }

    @Override
    public Object mediateOutput(Object output, Operation sourceOperation, Operation targetOperation, Map<String, Object> metadata) {
        DataType<List<DataType>> targetType;
        DataType<List<DataType>> sourceType = sourceOperation.getOutputType();
        if (sourceType == (targetType = targetOperation.getOutputType()) || sourceType != null && sourceType.equals(targetType)) {
            return output;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (metadata != null) {
            context.putAll(metadata);
        }
        if (targetOperation != null) {
            context.put("source.operation", targetOperation);
        }
        if (sourceOperation != null) {
            context.put("target.operation", sourceOperation);
        }
        if (context.get("body.type") == null) {
            context.put("body.type", "output");
        }
        return this.mediate(output, targetType, sourceType, context);
    }

    @Override
    public Object mediateInput(Object input, Operation sourceOperation, Operation targetOperation, Map<String, Object> metadata) {
        DataType<List<DataType>> targetType;
        DataType<List<DataType>> sourceType = sourceOperation.getInputType();
        if (sourceType == (targetType = targetOperation.getInputType()) || sourceType != null && sourceType.equals(targetType)) {
            return input;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (metadata != null) {
            context.putAll(metadata);
        }
        if (sourceOperation != null) {
            context.put("source.operation", sourceOperation);
        }
        if (targetOperation != null) {
            context.put("target.operation", targetOperation);
        }
        if (context.get("body.type") == null) {
            context.put("body.type", "input");
        }
        return this.mediate(input, sourceType, targetType, context);
    }

    @Override
    public TransformationContext createTransformationContext() {
        return new TransformationContextImpl();
    }

    @Override
    public TransformationContext createTransformationContext(DataType sourceDataType, DataType targetDataType, Map<String, Object> metadata) {
        return new TransformationContextImpl(sourceDataType, targetDataType, metadata);
    }

    @Override
    public Object copy(Object data, DataType dataType) {
        return this.copy(data, dataType, dataType, null, null);
    }

    @Override
    public Object copy(Object data, DataType sourceDataType, DataType targetDataType) {
        return this.copy(data, sourceDataType, targetDataType, null, null);
    }

    @Override
    public Object copy(Object data, DataType sourceDataType, DataType targetDataType, Operation sourceOperation, Operation targetOperation) {
        if (data == null) {
            return null;
        }
        Class<?> clazz = data.getClass();
        if (String.class == clazz || clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz) || URI.class == clazz || UUID.class == clazz || QName.class == clazz) {
            return data;
        }
        DataBinding javaBeansDataBinding = this.dataBindings.getDataBinding("java:complexType");
        DataBinding jaxbDataBinding = this.dataBindings.getDataBinding("javax.xml.bind.JAXBElement");
        DataBinding dataBinding = this.dataBindings.getDataBinding(sourceDataType.getDataBinding());
        if (dataBinding == null) {
            String db;
            if (!"java:array".equals(sourceDataType.getDataBinding()) && (sourceDataType = this.dataBindings.introspectType(data, sourceOperation)) != null && (dataBinding = this.dataBindings.getDataBinding(db = sourceDataType.getDataBinding())) == null && db != null) {
                return data;
            }
            if (dataBinding == null) {
                dataBinding = this.dataBindings.getDataBinding("java:complexType");
            }
        }
        if (dataBinding == javaBeansDataBinding) {
            clazz = data.getClass();
            if (clazz.isArray()) {
                Object element;
                if (Array.getLength(data) != 0 && (element = Array.get(data, 0)) != null && !(element instanceof Serializable)) {
                    dataBinding = jaxbDataBinding;
                }
            } else if (!(data instanceof Serializable) && !(data instanceof Cloneable)) {
                dataBinding = jaxbDataBinding;
            }
        }
        if (dataBinding == null) {
            return data;
        }
        return dataBinding.copy(data, sourceDataType, targetDataType, sourceOperation, targetOperation);
    }

    @Override
    public Object copyInput(Object input, Operation operation) {
        return this.copyInput(input, operation, operation);
    }

    @Override
    public Object copyInput(Object input, Operation sourceOperation, Operation targetOperation) {
        Object[] objectArray;
        if (input == null) {
            return null;
        }
        if (input instanceof Object[]) {
            objectArray = (Object[])input;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = input;
        }
        Object[] data = objectArray;
        List<DataType> inputTypes = sourceOperation.getInputType().getLogical();
        List<DataType> inputTypesTarget = targetOperation == null ? null : targetOperation.getInputType().getLogical();
        Object[] copy = new Object[data.length];
        IdentityHashMap map = new IdentityHashMap();
        for (int i = 0; i < inputTypes.size(); ++i) {
            Object arg = data[i];
            if (arg == null) {
                copy[i] = null;
                continue;
            }
            Object copiedArg = map.get(arg);
            if (copiedArg != null) {
                copy[i] = copiedArg;
                continue;
            }
            copiedArg = this.copy(arg, inputTypes.get(i), inputTypesTarget == null ? null : inputTypesTarget.get(i), sourceOperation, targetOperation);
            map.put(arg, copiedArg);
            copy[i] = copiedArg;
        }
        return copy;
    }

    @Override
    public Object copyOutput(Object data, Operation operation) {
        return this.copyOutput(data, operation, operation);
    }

    @Override
    public Object copyOutput(Object data, Operation sourceOperation, Operation targetOperation) {
        if (data == null) {
            return null;
        }
        Object[] output = null;
        output = !sourceOperation.hasArrayWrappedOutput() ? new Object[]{data} : (Object[])data;
        List<DataType> outputTypes = sourceOperation.getOutputType().getLogical();
        List<DataType> outputTypesTarget = targetOperation == null ? null : targetOperation.getOutputType().getLogical();
        Object[] copy = new Object[output.length];
        IdentityHashMap map = new IdentityHashMap();
        int size = output.length;
        for (int i = 0; i < size; ++i) {
            Object arg = output[i];
            if (arg == null) {
                copy[i] = null;
                continue;
            }
            Object copiedArg = map.get(arg);
            if (copiedArg != null) {
                copy[i] = copiedArg;
                continue;
            }
            copiedArg = this.copy(arg, outputTypes.get(i), outputTypesTarget == null ? null : outputTypesTarget.get(i), sourceOperation, targetOperation);
            map.put(arg, copiedArg);
            copy[i] = copiedArg;
        }
        if (!targetOperation.hasArrayWrappedOutput()) {
            return copy[0];
        }
        return copy;
    }

    @Override
    public Object copyFault(Object fault, Operation operation) {
        return this.copyFault(fault, operation, operation);
    }

    @Override
    public Object copyFault(Object fault, Operation sourceOperation, Operation targetOperation) {
        if (this.faultExceptionMapper == null) {
            return fault;
        }
        List<DataType> fts = targetOperation.getFaultTypes();
        for (int i = 0; i < fts.size(); ++i) {
            DataType et = fts.get(i);
            if (!et.getPhysical().isInstance(fault)) continue;
            Throwable ex = (Throwable)fault;
            DataType exType = this.findFaultDataType(targetOperation, fault);
            DataType faultType = this.getFaultType(exType);
            Object faultInfo = this.faultExceptionMapper.getFaultInfo(ex, faultType.getPhysical(), targetOperation);
            DataType targetExType = this.findSourceFaultDataType(sourceOperation, exType);
            DataType targetFaultType = this.getFaultType(targetExType);
            faultInfo = this.copy(faultInfo, faultType, targetFaultType, targetOperation, sourceOperation);
            fault = this.faultExceptionMapper.wrapFaultInfo(targetExType, ex.getMessage(), faultInfo, ex.getCause(), sourceOperation);
            return fault;
        }
        return fault;
    }

    private DataType findSourceFaultDataType(Operation sourceOperation, DataType targetExceptionType) {
        boolean remotable = sourceOperation.getInterface().isRemotable();
        DataType targetFaultType = this.getFaultType(targetExceptionType);
        for (DataType dt : sourceOperation.getFaultTypes()) {
            DataType sourceFaultType = this.getFaultType(dt);
            if (!this.interfaceContractMapper.isCompatible(targetFaultType, sourceFaultType, remotable)) continue;
            return dt;
        }
        return null;
    }
}

