/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.work.impl;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import org.apache.tuscany.sca.core.work.impl.Work;
import org.apache.tuscany.sca.core.work.impl.WorkEvent;
import org.apache.tuscany.sca.core.work.impl.WorkItem;
import org.apache.tuscany.sca.core.work.impl.WorkListener;
import org.apache.tuscany.sca.work.WorkSchedulerException;

public class ThreadPoolWorkManager {
    private Map<WorkItem, WorkListener> workItems = new ConcurrentHashMap<WorkItem, WorkListener>();
    protected ExecutorService executor;

    public ThreadPoolWorkManager(int threadPoolSize) {
        ThreadFactory factory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                return thread;
            }
        };
        this.executor = threadPoolSize <= 0 ? Executors.newCachedThreadPool(factory) : Executors.newFixedThreadPool(threadPoolSize, factory);
    }

    public WorkItem schedule(Work work) throws IllegalArgumentException {
        return this.schedule(work, null);
    }

    public WorkItem schedule(Work work, WorkListener workListener) throws IllegalArgumentException {
        WorkItem workItem = new WorkItem(UUID.randomUUID().toString(), work);
        if (workListener != null) {
            this.workItems.put(workItem, workListener);
        }
        this.workAccepted(workItem, work);
        if (this.scheduleWork(work, workItem)) {
            return workItem;
        }
        workItem.setStatus(2);
        if (workListener != null) {
            workListener.workRejected(new WorkEvent(workItem));
        }
        throw new IllegalArgumentException("Unable to schedule work");
    }

    public boolean waitForAll(Collection works, long timeout) {
        throw new UnsupportedOperationException("waitForAll not supported");
    }

    public Collection waitForAny(Collection works, long timeout) {
        throw new UnsupportedOperationException("waitForAny not supported");
    }

    private void workAccepted(WorkItem workItem, Work work) {
        WorkListener listener = this.workItems.get(workItem);
        if (listener != null) {
            workItem.setStatus(1);
            WorkEvent event = new WorkEvent(workItem);
            listener.workAccepted(event);
        }
    }

    private void workStarted(WorkItem workItem, Work work) {
        WorkListener listener = this.workItems.get(workItem);
        if (listener != null) {
            workItem.setStatus(3);
            WorkEvent event = new WorkEvent(workItem);
            listener.workStarted(event);
        }
    }

    private void workCompleted(WorkItem workItem, Work work) {
        this.workCompleted(workItem, work, null);
    }

    private void workCompleted(WorkItem workItem, Work work, WorkSchedulerException exception) {
        WorkListener listener = this.workItems.get(workItem);
        if (listener != null) {
            workItem.setStatus(4);
            workItem.setResult(work);
            workItem.setException(exception);
            WorkEvent event = new WorkEvent(workItem);
            listener.workCompleted(event);
            this.workItems.remove(workItem);
        }
    }

    private boolean scheduleWork(Work work, WorkItem workItem) {
        try {
            this.executor.execute(new DecoratingWork(workItem, work));
            return true;
        }
        catch (RejectedExecutionException ex) {
            return false;
        }
    }

    public void destroy() {
        this.executor.shutdown();
    }

    public ExecutorService getExecutorService() {
        return this.executor;
    }

    private final class DecoratingWork
    implements Runnable {
        private WorkItem workItem;
        private Work decoratedWork;

        private DecoratingWork(WorkItem workItem, Work decoratedWork) {
            this.workItem = workItem;
            this.decoratedWork = decoratedWork;
        }

        @Override
        public void run() {
            ThreadPoolWorkManager.this.workStarted(this.workItem, this.decoratedWork);
            try {
                this.decoratedWork.run();
                ThreadPoolWorkManager.this.workCompleted(this.workItem, this.decoratedWork);
            }
            catch (Throwable th) {
                ThreadPoolWorkManager.this.workCompleted(this.workItem, this.decoratedWork, new WorkSchedulerException(th.getMessage(), th));
            }
        }
    }
}

