/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.Future;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import org.apache.tuscany.sca.common.java.collection.LRUCache;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.core.context.ServiceReferenceExt;
import org.apache.tuscany.sca.core.context.impl.CallbackServiceReferenceImpl;
import org.apache.tuscany.sca.core.context.impl.ServiceReferenceImpl;
import org.apache.tuscany.sca.core.invocation.ProxyCreationException;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.impl.AsyncJDKInvocationHandler;
import org.apache.tuscany.sca.core.invocation.impl.JDKCallbackInvocationHandler;
import org.apache.tuscany.sca.core.invocation.impl.JDKInvocationHandler;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.Invocable;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class JDKProxyFactory
implements ProxyFactory,
LifeCycleListener {
    protected ExtensionPointRegistry registry;
    protected InterfaceContractMapper contractMapper;
    private MessageFactory messageFactory;
    private final LRUCache<Class<?>, Constructor<?>> cache = new LRUCache(512);

    public JDKProxyFactory(ExtensionPointRegistry registry, MessageFactory messageFactory, InterfaceContractMapper mapper) {
        this.registry = registry;
        this.contractMapper = mapper;
        this.messageFactory = messageFactory;
    }

    @Override
    public <T> T createProxy(final Class<T> interfaze, Invocable invocable) throws ProxyCreationException {
        if (invocable instanceof RuntimeEndpoint) {
            AsyncJDKInvocationHandler handler = new AsyncJDKInvocationHandler(this.registry, this.messageFactory, interfaze, invocable);
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return interfaze.getClassLoader();
                }
            });
            T proxy = interfaze.cast(this.newProxyInstance(cl, new Class[]{interfaze}, handler));
            return proxy;
        }
        ServiceReferenceImpl<T> serviceReference = new ServiceReferenceImpl<T>(interfaze, invocable, null);
        return this.createProxy(serviceReference);
    }

    @Override
    public <T> T createProxy(ServiceReference<T> callableReference) throws ProxyCreationException {
        assert (callableReference != null);
        final Class<T> interfaze = callableReference.getBusinessInterface();
        AsyncJDKInvocationHandler handler = new AsyncJDKInvocationHandler(this.registry, this.messageFactory, callableReference);
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return interfaze.getClassLoader();
            }
        });
        T proxy = interfaze.cast(this.newProxyInstance(cl, new Class[]{interfaze}, handler));
        ((ServiceReferenceExt)callableReference).setProxy(proxy);
        return proxy;
    }

    private boolean isAsync(Class<?> interfaze) {
        for (Method method : interfaze.getMethods()) {
            if (!method.getName().endsWith("Async")) continue;
            if (method.getReturnType().isAssignableFrom(Future.class) && method.getParameterTypes().length > 0 && method.getParameterTypes()[method.getParameterTypes().length - 1].isAssignableFrom(AsyncHandler.class)) {
                return true;
            }
            if (!method.getReturnType().isAssignableFrom(Response.class)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T createCallbackProxy(Class<T> interfaze, List<? extends Invocable> wires) throws ProxyCreationException {
        CallbackServiceReferenceImpl<T> callbackReference = null;
        try {
            callbackReference = new CallbackServiceReferenceImpl<T>(interfaze, wires);
        }
        catch (ServiceRuntimeException e) {
            callbackReference = null;
        }
        return callbackReference != null ? (T)this.createCallbackProxy(callbackReference) : null;
    }

    @Override
    public <T> T createCallbackProxy(ServiceReference<T> callbackReference) throws ProxyCreationException {
        assert (callbackReference != null);
        Class<T> interfaze = callbackReference.getBusinessInterface();
        JDKCallbackInvocationHandler handler = new JDKCallbackInvocationHandler(this.messageFactory, callbackReference);
        ClassLoader cl = interfaze.getClassLoader();
        T proxy = interfaze.cast(this.newProxyInstance(cl, new Class[]{interfaze}, handler));
        ((ServiceReferenceExt)callbackReference).setProxy(proxy);
        return proxy;
    }

    @Override
    public <B, R extends ServiceReference<B>> R cast(B target) throws IllegalArgumentException {
        InvocationHandler handler = Proxy.getInvocationHandler(target);
        if (handler instanceof JDKInvocationHandler) {
            return (R)((JDKInvocationHandler)handler).getCallableReference();
        }
        throw new IllegalArgumentException("The object is not a known proxy.");
    }

    @Override
    public boolean isProxyClass(Class<?> clazz) {
        return Proxy.isProxyClass(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object newProxyInstance(ClassLoader classloader, Class<?>[] interfaces, InvocationHandler invocationhandler) throws IllegalArgumentException {
        if (interfaces.length > 1) {
            return Proxy.newProxyInstance(classloader, interfaces, invocationhandler);
        }
        try {
            Constructor<?> proxyCTOR;
            if (invocationhandler == null) {
                throw new NullPointerException("InvocationHandler is null");
            }
            LRUCache<Class<?>, Constructor<?>> lRUCache = this.cache;
            synchronized (lRUCache) {
                proxyCTOR = (Constructor<?>)this.cache.get(interfaces[0]);
            }
            if (proxyCTOR == null) {
                Class<?> proxyClass = Proxy.getProxyClass(classloader, interfaces);
                proxyCTOR = proxyClass.getConstructor(InvocationHandler.class);
                LRUCache<Class<?>, Constructor<?>> lRUCache2 = this.cache;
                synchronized (lRUCache2) {
                    this.cache.put(interfaces[0], proxyCTOR);
                }
            }
            return proxyCTOR.newInstance(invocationhandler);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.cache.clear();
    }
}

