/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tuscany.sca.context.ThreadMessageContext;
import org.apache.tuscany.sca.core.context.impl.CallbackServiceReferenceImpl;
import org.apache.tuscany.sca.core.invocation.impl.JDKInvocationHandler;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.Invocable;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class JDKCallbackInvocationHandler
extends JDKInvocationHandler {
    private static final long serialVersionUID = -3350283555825935609L;

    public JDKCallbackInvocationHandler(MessageFactory messageFactory, ServiceReference<?> ref) {
        super(messageFactory, ref);
        this.fixedWire = false;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class == method.getDeclaringClass()) {
            return this.invokeObjectMethod(method, args);
        }
        RuntimeEndpointReference wire = ((CallbackServiceReferenceImpl)this.callableReference).getCallbackEPR();
        if (wire == null) {
            throw new ServiceRuntimeException("No callback wire found");
        }
        this.setEndpoint(((CallbackServiceReferenceImpl)this.callableReference).getResolvedEndpoint());
        InvocationChain chain = this.getInvocationChain(method, wire);
        if (chain == null) {
            throw new IllegalArgumentException("No matching operation is found: " + method);
        }
        try {
            String msgID = ((CallbackServiceReferenceImpl)this.callableReference).getMsgID();
            Object object = this.invoke(chain, args, wire, msgID);
            return object;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invoke(InvocationChain chain, Object[] args, Invocable source, String msgID) throws Throwable {
        Message msg = this.messageFactory.createMessage();
        if (source instanceof RuntimeEndpointReference) {
            msg.setFrom((RuntimeEndpointReference)source);
        }
        if (this.target != null) {
            msg.setTo(this.target);
        } else if (source instanceof RuntimeEndpointReference) {
            msg.setTo(((RuntimeEndpointReference)source).getTargetEndpoint());
        }
        Invoker headInvoker = chain.getHeadInvoker();
        Operation operation = chain.getTargetOperation();
        msg.setOperation(operation);
        msg.setBody(args);
        Message msgContext = ThreadMessageContext.getMessageContext();
        this.transferMessageHeaders(msg, msgContext);
        ThreadMessageContext.setMessageContext(msg);
        if (msgID != null) {
            msg.getHeaders().put("RELATES_TO", msgID);
        }
        try {
            Message resp = headInvoker.invoke(msg);
            Object body = resp.getBody();
            if (resp.isFault()) {
                throw (Throwable)body;
            }
            Object t = body;
            return t;
        }
        finally {
            ThreadMessageContext.setMessageContext(msgContext);
        }
    }
}

