/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation.impl;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.BindingBuilder;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.context.ThreadMessageContext;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLInputFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.assembly.RuntimeAssemblyFactory;
import org.apache.tuscany.sca.core.invocation.AsyncFaultWrapper;
import org.apache.tuscany.sca.core.invocation.AsyncResponseException;
import org.apache.tuscany.sca.core.invocation.AsyncResponseService;
import org.apache.tuscany.sca.core.invocation.JDKAsyncResponseInvoker;
import org.apache.tuscany.sca.core.invocation.impl.AsyncInvocationFutureImpl;
import org.apache.tuscany.sca.core.invocation.impl.AsyncResponseHandlerImpl;
import org.apache.tuscany.sca.core.invocation.impl.JDKInvocationHandler;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.invocation.InterceptorAsync;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.InvokerAsyncResponse;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.provider.EndpointReferenceAsyncProvider;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.Invocable;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class AsyncJDKInvocationHandler
extends JDKInvocationHandler {
    private static final long serialVersionUID = 1L;
    private static int invocationCount = 10;
    private static long maxWaitTime = 30L;
    private ExecutorService theExecutor;
    private static QName ASYNC_INVOKE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "asyncInvocation");

    public AsyncJDKInvocationHandler(ExtensionPointRegistry registry, MessageFactory messageFactory, ServiceReference<?> callableReference) {
        super(messageFactory, callableReference);
        this.initExecutorService(registry);
    }

    public AsyncJDKInvocationHandler(ExtensionPointRegistry registry, MessageFactory messageFactory, Class<?> businessInterface, Invocable source) {
        super(messageFactory, businessInterface, source);
        this.initExecutorService(registry);
    }

    private final void initExecutorService(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        WorkScheduler scheduler = utilities.getUtility(WorkScheduler.class);
        this.theExecutor = scheduler.getExecutorService();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.source.getInvocationChains();
        if (this.isAsyncCallback(method)) {
            return this.doInvokeAsyncCallback(proxy, method, args);
        }
        if (this.isAsyncPoll(method)) {
            return this.doInvokeAsyncPoll(proxy, method, args);
        }
        return this.doInvokeSync(proxy, method, args);
    }

    protected boolean isAsyncCallback(Method method) {
        if (method.getName().endsWith("Async") && method.getReturnType() == Future.class && method.getParameterTypes().length > 0) {
            return method.getParameterTypes()[method.getParameterTypes().length - 1] == AsyncHandler.class;
        }
        return false;
    }

    protected boolean isAsyncPoll(Method method) {
        return method.getName().endsWith("Async") && method.getReturnType() == Response.class;
    }

    protected Response doInvokeAsyncPoll(Object proxy, Method asyncMethod, Object[] args) {
        Method method = this.getNonAsyncMethod(asyncMethod);
        Class<?> returnType = method.getReturnType();
        AsyncInvocationFutureImpl<?> future = AsyncInvocationFutureImpl.newInstance(returnType, this.getInterfaceClassloader());
        try {
            this.invokeAsync(proxy, method, args, future, asyncMethod);
        }
        catch (Exception e) {
            future.setWrappedFault(new AsyncFaultWrapper(e));
        }
        catch (Throwable t) {
            ServiceRuntimeException e = new ServiceRuntimeException("Received Throwable: " + t.getClass().getName() + " when invoking: " + asyncMethod.getName(), t);
            future.setWrappedFault(new AsyncFaultWrapper(e));
        }
        return future;
    }

    protected Object doInvokeSync(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isAsyncInvocation(this.source)) {
            Class<?> returnType = method.getReturnType();
            AsyncInvocationFutureImpl<?> future = AsyncInvocationFutureImpl.newInstance(returnType, this.getInterfaceClassloader());
            this.invokeAsync(proxy, method, args, future, method);
            Object response = null;
            try {
                response = future.get(1000L, TimeUnit.SECONDS);
            }
            catch (ExecutionException ex) {
                throw ex.getCause();
            }
            return response;
        }
        return super.invoke(proxy, method, args);
    }

    private Object doInvokeAsyncCallback(final Object proxy, final Method asyncMethod, final Object[] args) throws Exception {
        Future<Response> future = this.theExecutor.submit(new Callable<Response>(){

            @Override
            public Response call() {
                AsyncHandler handler = (AsyncHandler)args[args.length - 1];
                Response response = AsyncJDKInvocationHandler.this.doInvokeAsyncPoll(proxy, asyncMethod, Arrays.copyOf(args, args.length - 1));
                if (handler != null) {
                    handler.handleResponse(response);
                }
                return response;
            }
        });
        return future.get();
    }

    private void invokeAsync(Object proxy, Method method, Object[] args, AsyncInvocationFutureImpl<?> future, Method asyncMethod) throws Throwable {
        InvocationChain chain;
        RuntimeEndpointReference epr;
        if (this.source == null) {
            throw new ServiceRuntimeException("No runtime source is available");
        }
        if (this.source instanceof RuntimeEndpointReference && (epr = (RuntimeEndpointReference)this.source).isOutOfDate()) {
            epr.rebuild();
            this.chains.clear();
        }
        if ((chain = this.getInvocationChain(method, this.source)) == null) {
            throw new IllegalArgumentException("No matching operation is found: " + method);
        }
        RuntimeEndpoint theEndpoint = this.getAsyncCallback(this.source);
        boolean isAsyncService = false;
        if (theEndpoint != null) {
            this.attachFuture(theEndpoint, future);
        }
        if (this.isAsyncInvocation((RuntimeEndpointReference)this.source)) {
            InvokerAsyncResponse responseInvoker;
            isAsyncService = true;
            Invoker theInvoker = chain.getHeadInvoker();
            if (theInvoker instanceof InterceptorAsync && (responseInvoker = ((InterceptorAsync)theInvoker).getPrevious()) instanceof JDKAsyncResponseInvoker) {
                ((JDKAsyncResponseInvoker)responseInvoker).registerAsyncResponse(future.getUniqueID(), future);
            }
        }
        this.theExecutor.submit(new separateThreadInvoker(chain, args, this.source, future, asyncMethod, isAsyncService));
    }

    private void attachFuture(RuntimeEndpoint endpoint, AsyncInvocationFutureImpl<?> future) {
        Implementation impl = endpoint.getComponent().getImplementation();
        AsyncResponseHandlerImpl asyncHandler = (AsyncResponseHandlerImpl)impl;
        asyncHandler.addFuture(future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAsync(InvocationChain chain, Object[] args, Invocable invocable, String msgID) {
        Message msg = this.messageFactory.createMessage();
        if (invocable instanceof RuntimeEndpointReference) {
            msg.setFrom((RuntimeEndpointReference)invocable);
        }
        if (this.target != null) {
            msg.setTo(this.target);
        } else if (this.source instanceof RuntimeEndpointReference) {
            msg.setTo(((RuntimeEndpointReference)invocable).getTargetEndpoint());
        }
        Operation operation = chain.getTargetOperation();
        msg.setOperation(operation);
        msg.setBody(args);
        Message msgContext = ThreadMessageContext.getMessageContext();
        this.transferMessageHeaders(msg, msgContext);
        ThreadMessageContext.setMessageContext(msg);
        if (msgID != null) {
            msg.getHeaders().put("MESSAGE_ID", msgID);
        }
        try {
            invocable.invokeAsync(msg);
            return;
        }
        finally {
            ThreadMessageContext.setMessageContext(msgContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuntimeEndpoint getAsyncCallback(Invocable source) {
        RuntimeEndpoint endpoint;
        if (!(source instanceof RuntimeEndpointReference)) {
            return null;
        }
        RuntimeEndpointReference epr = (RuntimeEndpointReference)source;
        if (!this.isAsyncInvocation(epr)) {
            return null;
        }
        ReferenceBindingProvider eprProvider = epr.getBindingProvider();
        if (eprProvider instanceof EndpointReferenceAsyncProvider && ((EndpointReferenceAsyncProvider)eprProvider).supportsNativeAsync()) {
            return null;
        }
        RuntimeEndpointReference runtimeEndpointReference = epr;
        synchronized (runtimeEndpointReference) {
            endpoint = (RuntimeEndpoint)epr.getCallbackEndpoint();
            if (endpoint != null) {
                return endpoint;
            }
            endpoint = this.createAsyncCallbackEndpoint(epr);
            epr.setCallbackEndpoint(endpoint);
        }
        this.startEndpoint(epr.getCompositeContext(), endpoint);
        endpoint.getInvocationChains();
        return endpoint;
    }

    private void startEndpoint(CompositeContext compositeContext, RuntimeEndpoint ep) {
        for (PolicyProvider policyProvider : ep.getPolicyProviders()) {
            policyProvider.start();
        }
        final ServiceBindingProvider bindingProvider = ep.getBindingProvider();
        if (bindingProvider != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    bindingProvider.start();
                    return null;
                }
            });
            compositeContext.getEndpointRegistry().addEndpoint(ep);
        }
    }

    private RuntimeEndpoint createAsyncCallbackEndpoint(RuntimeEndpointReference epr) {
        CompositeContext compositeContext = epr.getCompositeContext();
        RuntimeAssemblyFactory assemblyFactory = this.getAssemblyFactory(compositeContext);
        RuntimeEndpoint endpoint = (RuntimeEndpoint)assemblyFactory.createEndpoint();
        endpoint.bind(compositeContext);
        RuntimeComponent fakeComponent = null;
        try {
            fakeComponent = (RuntimeComponent)epr.getComponent().clone();
            this.applyImplementation(fakeComponent);
        }
        catch (CloneNotSupportedException e2) {
            // empty catch block
        }
        endpoint.setComponent(fakeComponent);
        ComponentService service = assemblyFactory.createComponentService();
        ExtensionPointRegistry registry = compositeContext.getExtensionPointRegistry();
        FactoryExtensionPoint modelFactories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        JavaInterfaceFactory javaInterfaceFactory = modelFactories.getFactory(JavaInterfaceFactory.class);
        JavaInterfaceContract interfaceContract = javaInterfaceFactory.createJavaInterfaceContract();
        try {
            interfaceContract.setInterface(javaInterfaceFactory.createJavaInterface(AsyncResponseService.class));
        }
        catch (InvalidInterfaceException e1) {
            // empty catch block
        }
        service.setInterfaceContract(interfaceContract);
        String serviceName = epr.getReference().getName() + "_asyncCallback";
        service.setName(serviceName);
        Service implService = assemblyFactory.createService();
        implService.setName(serviceName);
        implService.setInterfaceContract(interfaceContract);
        service.setService(implService);
        endpoint.setService(service);
        List<ComponentService> services = fakeComponent.getServices();
        services.clear();
        services.add(service);
        Binding binding = this.createMatchingBinding(epr.getBinding(), fakeComponent, service, registry);
        endpoint.setBinding(binding);
        endpoint.getRequiredIntents().addAll(epr.getRequiredIntents());
        endpoint.getPolicySets().addAll(epr.getPolicySets());
        String epURI = epr.getComponent().getName() + "#service-binding(" + serviceName + "/" + serviceName + ")";
        endpoint.setURI(epURI);
        endpoint.setUnresolved(false);
        return endpoint;
    }

    private Binding createMatchingBinding(Binding matchBinding, RuntimeComponent component, ComponentService service, ExtensionPointRegistry registry) {
        QName bindingName = matchBinding.getType();
        String bindingXML = "<ns1:" + bindingName.getLocalPart() + " xmlns:ns1='" + bindingName.getNamespaceURI() + "'/>";
        StAXArtifactProcessorExtensionPoint processors = registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        StAXArtifactProcessor processor = processors.getProcessor(bindingName);
        FactoryExtensionPoint modelFactories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        ValidatingXMLInputFactory inputFactory = modelFactories.getFactory(ValidatingXMLInputFactory.class);
        StreamSource source = new StreamSource(new StringReader(bindingXML));
        ProcessorContext context = new ProcessorContext();
        try {
            XMLStreamReader reader = inputFactory.createXMLStreamReader(source);
            reader.next();
            Binding newBinding = (Binding)processor.read(reader, context);
            String callbackURI = "/" + component.getName() + "/" + service.getName();
            newBinding.setURI(callbackURI);
            BuilderExtensionPoint builders = registry.getExtensionPoint(BuilderExtensionPoint.class);
            BindingBuilder<Binding> builder = builders.getBindingBuilder(newBinding.getType());
            if (builder != null) {
                BuilderContext builderContext = new BuilderContext(registry);
                builder.build(component, service, newBinding, builderContext, true);
            }
            return newBinding;
        }
        catch (ContributionReadException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return null;
    }

    private RuntimeAssemblyFactory getAssemblyFactory(CompositeContext compositeContext) {
        ExtensionPointRegistry registry = compositeContext.getExtensionPointRegistry();
        FactoryExtensionPoint modelFactories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        return (RuntimeAssemblyFactory)modelFactories.getFactory(AssemblyFactory.class);
    }

    private void applyImplementation(RuntimeComponent component) {
        AsyncResponseHandlerImpl asyncHandler = new AsyncResponseHandlerImpl();
        component.setImplementation(asyncHandler);
        component.setImplementationProvider(asyncHandler);
    }

    private boolean isAsyncInvocation(Invocable source) {
        if (!(source instanceof RuntimeEndpointReference)) {
            return false;
        }
        RuntimeEndpointReference epr = (RuntimeEndpointReference)source;
        for (Intent intent : epr.getRequiredIntents()) {
            if (!intent.getName().equals(ASYNC_INVOKE)) continue;
            return true;
        }
        Endpoint ep = epr.getTargetEndpoint();
        for (Intent intent : ep.getRequiredIntents()) {
            if (!intent.getName().equals(ASYNC_INVOKE)) continue;
            return true;
        }
        return false;
    }

    private boolean supportsNativeAsync(Invocable source) {
        if (!(source instanceof RuntimeEndpointReference)) {
            return false;
        }
        RuntimeEndpointReference epr = (RuntimeEndpointReference)source;
        ReferenceBindingProvider provider = epr.getBindingProvider();
        if (provider instanceof EndpointReferenceAsyncProvider) {
            return ((EndpointReferenceAsyncProvider)provider).supportsNativeAsync();
        }
        return false;
    }

    protected Method getNonAsyncMethod(Method asyncMethod) {
        String methodName = asyncMethod.getName().substring(0, asyncMethod.getName().length() - 5);
        for (Method m : this.businessInterface.getMethods()) {
            if (!methodName.equals(m.getName())) continue;
            return m;
        }
        throw new IllegalStateException("No synchronous method matching async method " + asyncMethod.getName());
    }

    private ClassLoader getInterfaceClassloader() {
        return this.businessInterface.getClassLoader();
    }

    private class separateThreadInvoker
    implements Runnable {
        private AsyncInvocationFutureImpl future;
        private Method asyncMethod;
        private InvocationChain chain;
        private Object[] args;
        private Invocable invocable;
        private boolean isAsyncService;

        public separateThreadInvoker(InvocationChain chain, Object[] args, Invocable invocable, AsyncInvocationFutureImpl future, Method asyncMethod, boolean isAsyncService) {
            this.chain = chain;
            this.asyncMethod = asyncMethod;
            this.args = args;
            this.invocable = invocable;
            this.future = future;
            this.isAsyncService = isAsyncService;
        }

        @Override
        public void run() {
            try {
                if (this.isAsyncService) {
                    if (AsyncJDKInvocationHandler.this.supportsNativeAsync(this.invocable)) {
                        AsyncJDKInvocationHandler.this.invokeAsync(this.chain, this.args, this.invocable, this.future.getUniqueID());
                    } else {
                        AsyncJDKInvocationHandler.this.invoke(this.chain, this.args, this.invocable, this.future.getUniqueID());
                    }
                } else {
                    Object result = AsyncJDKInvocationHandler.this.invoke(this.chain, this.args, this.invocable);
                    Type type = null;
                    if (this.asyncMethod.getReturnType() == Future.class) {
                        Type[] types = this.asyncMethod.getGenericParameterTypes();
                        if (types.length > 0 && this.asyncMethod.getParameterTypes()[types.length - 1] == AsyncHandler.class) {
                            type = types[types.length - 1];
                        }
                    } else if (this.asyncMethod.getReturnType() == Response.class) {
                        type = this.asyncMethod.getGenericReturnType();
                    }
                    if (type instanceof ParameterizedType) {
                        Class wrapperClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                        WrapperInfo wrapperInfo = this.chain.getSourceOperation().getWrapper();
                        if (wrapperInfo != null && wrapperInfo.getOutputWrapperClass() == wrapperClass) {
                            Object wrapper = wrapperClass.newInstance();
                            for (PropertyDescriptor p : Introspector.getBeanInfo(wrapperClass).getPropertyDescriptors()) {
                                if (p.getWriteMethod() == null || !p.getWriteMethod().getParameterTypes()[0].isInstance(result)) continue;
                                p.getWriteMethod().invoke(wrapper, result);
                                result = wrapper;
                                break;
                            }
                        }
                    }
                    this.future.setResponse(result);
                }
            }
            catch (ServiceRuntimeException s) {
                Throwable e = s.getCause();
                if (e != null && e instanceof FaultException && !"AsyncResponse".equals(e.getMessage())) {
                    this.future.setWrappedFault(new AsyncFaultWrapper(s));
                }
            }
            catch (AsyncResponseException ar) {
            }
            catch (Throwable t) {
                this.future.setWrappedFault(new AsyncFaultWrapper(t));
            }
        }
    }
}

