/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation.impl;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.ws.Response;
import org.apache.tuscany.sca.core.invocation.AsyncFaultWrapper;
import org.apache.tuscany.sca.core.invocation.AsyncResponseHandler;

public class AsyncInvocationFutureImpl<V>
implements Future<V>,
Response<V>,
AsyncResponseHandler<V> {
    private final Lock lock = new ReentrantLock();
    private final Condition isDone = this.lock.newCondition();
    private volatile V response = null;
    private volatile Throwable fault = null;
    private String uniqueID = UUID.randomUUID().toString();
    private ClassLoader classLoader = null;

    protected AsyncInvocationFutureImpl() {
    }

    public static <V> AsyncInvocationFutureImpl<V> newInstance(Class<V> type, ClassLoader classLoader) {
        AsyncInvocationFutureImpl<V> future = new AsyncInvocationFutureImpl<V>();
        future.setClassLoader(classLoader);
        return future;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            V response = this.get(Long.MAX_VALUE, TimeUnit.SECONDS);
            return response;
        }
        catch (TimeoutException t) {
            throw new InterruptedException("Timed out waiting for Future to complete");
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.lock.lock();
        try {
            if (this.notSetYet()) {
                this.isDone.await(timeout, unit);
            }
            if (this.response != null) {
                V v = this.response;
                return v;
            }
            if (this.fault != null) {
                throw new ExecutionException(this.fault);
            }
            throw new TimeoutException("get on this Future timed out");
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = !this.notSetYet();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFault(Throwable e) {
        block4: {
            this.lock.lock();
            try {
                if (this.notSetYet()) {
                    this.fault = e;
                    this.isDone.signalAll();
                    break block4;
                }
                throw new IllegalStateException("setResponse() or setFault() has been called previously");
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWrappedFault(AsyncFaultWrapper w) {
        Throwable e;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            e = w.retrieveFault();
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        if (e == null) {
            throw new IllegalArgumentException("AsyncFaultWrapper did not return an Exception");
        }
        this.setFault(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResponse(V res) {
        block4: {
            this.lock.lock();
            try {
                if (this.notSetYet()) {
                    this.response = res;
                    this.isDone.signalAll();
                    break block4;
                }
                throw new IllegalStateException("setResponse() or setFault() has been called previously");
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    private boolean notSetYet() {
        return this.response == null && this.fault == null;
    }

    public Map<String, Object> getContext() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

