/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import java.util.List;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.invocation.ProxyCreationException;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactoryExtensionPoint;
import org.apache.tuscany.sca.runtime.Invocable;
import org.oasisopen.sca.ServiceReference;

public class ExtensibleProxyFactory
implements ProxyFactory {
    private ProxyFactoryExtensionPoint proxyFactories;

    public ExtensibleProxyFactory(ProxyFactoryExtensionPoint proxyFactories) {
        this.proxyFactories = proxyFactories;
    }

    public ExtensibleProxyFactory(ExtensionPointRegistry registry) {
        this.proxyFactories = registry.getExtensionPoint(ProxyFactoryExtensionPoint.class);
    }

    public static ExtensibleProxyFactory getInstance(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        return utilities.getUtility(ExtensibleProxyFactory.class);
    }

    @Override
    public <B, R extends ServiceReference<B>> R cast(B target) throws IllegalArgumentException {
        ProxyFactory interfaceFactory = this.proxyFactories.getInterfaceProxyFactory();
        ProxyFactory classFactory = this.proxyFactories.getClassProxyFactory();
        if (interfaceFactory.isProxyClass(target.getClass())) {
            return interfaceFactory.cast(target);
        }
        if (classFactory != null && classFactory.isProxyClass(target.getClass())) {
            return classFactory.cast(target);
        }
        throw new IllegalArgumentException("The target is not a callable proxy");
    }

    @Override
    public <T> T createCallbackProxy(Class<T> interfaze, List<? extends Invocable> wires) throws ProxyCreationException {
        ProxyFactory interfaceFactory = this.proxyFactories.getInterfaceProxyFactory();
        ProxyFactory classFactory = this.proxyFactories.getClassProxyFactory();
        if (interfaze.isInterface()) {
            return interfaceFactory.createCallbackProxy(interfaze, wires);
        }
        return classFactory.createCallbackProxy(interfaze, wires);
    }

    @Override
    public <T> T createProxy(ServiceReference<T> callableReference) throws ProxyCreationException {
        ProxyFactory interfaceFactory = this.proxyFactories.getInterfaceProxyFactory();
        ProxyFactory classFactory = this.proxyFactories.getClassProxyFactory();
        if (callableReference.getBusinessInterface().isInterface()) {
            return interfaceFactory.createProxy(callableReference);
        }
        return classFactory.createProxy(callableReference);
    }

    @Override
    public <T> T createCallbackProxy(ServiceReference<T> callbackReference) throws ProxyCreationException {
        ProxyFactory interfaceFactory = this.proxyFactories.getInterfaceProxyFactory();
        ProxyFactory classFactory = this.proxyFactories.getClassProxyFactory();
        if (callbackReference.getBusinessInterface().isInterface()) {
            return interfaceFactory.createCallbackProxy(callbackReference);
        }
        return classFactory.createCallbackProxy(callbackReference);
    }

    @Override
    public <T> T createProxy(Class<T> interfaze, Invocable wire) throws ProxyCreationException {
        ProxyFactory interfaceFactory = this.proxyFactories.getInterfaceProxyFactory();
        ProxyFactory classFactory = this.proxyFactories.getClassProxyFactory();
        if (interfaze.isInterface()) {
            return interfaceFactory.createProxy(interfaze, wire);
        }
        return classFactory.createProxy(interfaze, wire);
    }

    @Override
    public boolean isProxyClass(Class<?> clazz) {
        ProxyFactory interfaceFactory = this.proxyFactories.getInterfaceProxyFactory();
        ProxyFactory classFactory = this.proxyFactories.getClassProxyFactory();
        return interfaceFactory.isProxyClass(clazz) || classFactory != null && classFactory.isProxyClass(clazz);
    }
}

