/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.invocation.AsyncFaultWrapper;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvokerAsyncResponse;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.node.NodeFactory;
import org.apache.tuscany.sca.provider.EndpointAsyncProvider;
import org.apache.tuscany.sca.runtime.EndpointRegistry;
import org.apache.tuscany.sca.runtime.ExtensibleDomainRegistryFactory;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class AsyncResponseInvoker<T>
implements InvokerAsyncResponse,
Serializable {
    private static final long serialVersionUID = -7992598227671386588L;
    private transient RuntimeEndpoint requestEndpoint;
    private transient RuntimeEndpointReference responseEndpointReference;
    private T responseTargetAddress;
    private String relatesToMsgID;
    private String operationName;
    private transient MessageFactory messageFactory;
    private String bindingType = "";
    private boolean isNativeAsync;
    private String endpointURI;
    private String endpointReferenceURI;
    private String domainURI;
    private transient EndpointRegistry endpointRegistry;
    private transient ExtensionPointRegistry registry;

    public AsyncResponseInvoker(RuntimeEndpoint requestEndpoint, RuntimeEndpointReference responseEndpointReference, T responseTargetAddress, String relatesToMsgID, String operationName, MessageFactory messageFactory) {
        this.requestEndpoint = requestEndpoint;
        this.responseEndpointReference = responseEndpointReference;
        this.responseTargetAddress = responseTargetAddress;
        this.relatesToMsgID = relatesToMsgID;
        this.operationName = operationName;
        this.messageFactory = messageFactory;
        CompositeContext context = null;
        if (requestEndpoint != null) {
            this.endpointURI = requestEndpoint.getURI();
            context = requestEndpoint.getCompositeContext();
        }
        if (responseEndpointReference != null) {
            this.endpointReferenceURI = responseEndpointReference.getURI();
            context = responseEndpointReference.getCompositeContext();
        }
        if (context != null) {
            this.domainURI = context.getDomainURI();
            this.registry = context.getExtensionPointRegistry();
        }
        this.isNativeAsync = requestEndpoint.getBindingProvider() instanceof EndpointAsyncProvider && ((EndpointAsyncProvider)requestEndpoint.getBindingProvider()).supportsNativeAsync();
    }

    @Override
    public void invokeAsyncResponse(Message responseMessage) {
        responseMessage.getHeaders().put("ASYNC_RESPONSE_INVOKER", this);
        responseMessage.getHeaders().put("RELATES_TO", this.relatesToMsgID);
        if (this.isNativeAsync) {
            this.requestEndpoint.invokeAsyncResponse(responseMessage);
        } else {
            this.responseEndpointReference.invoke(responseMessage);
        }
    }

    public T getResponseTargetAddress() {
        return this.responseTargetAddress;
    }

    public void setResponseTargetAddress(T responseTargetAddress) {
        this.responseTargetAddress = responseTargetAddress;
    }

    public String getRelatesToMsgID() {
        return this.relatesToMsgID;
    }

    public void setRelatesToMsgID(String relatesToMsgID) {
        this.relatesToMsgID = relatesToMsgID;
    }

    public void invokeAsyncResponse(Object args, Map<String, Object> headers) {
        Message msg = this.messageFactory.createMessage();
        msg.setOperation(this.getOperation(args));
        if (!this.isNativeAsync && args instanceof Throwable) {
            args = new AsyncFaultWrapper((Throwable)args);
        }
        if (!this.isNativeAsync) {
            Object[] objs = new Object[]{args};
            args = objs;
        }
        msg.setTo(this.requestEndpoint);
        msg.setFrom(this.responseEndpointReference);
        if (headers != null) {
            msg.getHeaders().putAll(headers);
        }
        if (args instanceof Throwable) {
            msg.setFaultBody(args);
        } else {
            msg.setBody(args);
        }
        this.invokeAsyncResponse(msg);
    }

    private Operation getOperation(Object args) {
        if (this.isNativeAsync) {
            List<Operation> ops = this.requestEndpoint.getService().getInterfaceContract().getInterface().getOperations();
            for (Operation op : ops) {
                if (!this.operationName.equals(op.getName())) continue;
                return op;
            }
            return null;
        }
        this.operationName = "setResponse";
        if (args instanceof Throwable) {
            this.operationName = "setWrappedFault";
        }
        List<Operation> ops = this.responseEndpointReference.getReference().getInterfaceContract().getInterface().getOperations();
        for (Operation op : ops) {
            if (!this.operationName.equals(op.getName())) continue;
            return op;
        }
        return null;
    }

    public void setBindingType(String bindingType) {
        this.bindingType = bindingType;
    }

    public String getBindingType() {
        return this.bindingType;
    }

    public RuntimeEndpoint getRequestEndpoint() {
        return this.requestEndpoint;
    }

    public RuntimeEndpointReference getResponseEndpointReference() {
        return this.responseEndpointReference;
    }

    public void setResponseEndpointReference(RuntimeEndpointReference responseEndpointReference) {
        this.responseEndpointReference = responseEndpointReference;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.requestEndpoint = this.retrieveEndpoint(this.endpointURI);
        this.responseEndpointReference = this.retrieveEndpointReference(this.endpointReferenceURI);
        this.messageFactory = this.getMessageFactory();
        if (this.responseTargetAddress instanceof EndpointReference) {
            EndpointReference epr = (EndpointReference)this.responseTargetAddress;
            this.responseTargetAddress = this.retrieveEndpointReference(epr.getURI());
        }
    }

    private MessageFactory getMessageFactory() {
        return this.registry.getExtensionPoint(FactoryExtensionPoint.class).getFactory(MessageFactory.class);
    }

    private RuntimeEndpointReference retrieveEndpointReference(String uri) {
        if (uri == null) {
            return null;
        }
        if (this.endpointRegistry == null) {
            return null;
        }
        List<EndpointReference> refs = this.endpointRegistry.findEndpointReferences(uri);
        if (refs.isEmpty()) {
            return null;
        }
        return (RuntimeEndpointReference)refs.get(0);
    }

    private RuntimeEndpoint retrieveEndpoint(String uri) {
        if (uri == null) {
            return null;
        }
        if (this.endpointRegistry == null) {
            this.endpointRegistry = this.getEndpointRegistry(uri);
        }
        if (this.endpointRegistry == null) {
            return null;
        }
        return (RuntimeEndpoint)this.endpointRegistry.findEndpoint(uri).get(0);
    }

    private EndpointRegistry getEndpointRegistry(String uri) {
        ExtensionPointRegistry registry = null;
        EndpointRegistry endpointRegistry = null;
        CompositeContext context = CompositeContext.getCurrentCompositeContext();
        if (context == null && this.requestEndpoint != null) {
            context = this.requestEndpoint.getCompositeContext();
        }
        if (context != null && (endpointRegistry = this.getEndpointRegistry(registry = context.getExtensionPointRegistry())) != null) {
            this.registry = registry;
            return endpointRegistry;
        }
        for (NodeFactory factory : NodeFactory.getNodeFactories()) {
            Iterator<Endpoint> i$;
            registry = (ExtensionPointRegistry)factory.getExtensionPointRegistry();
            if (registry == null || (endpointRegistry = this.getEndpointRegistry(registry)) == null || !(i$ = endpointRegistry.findEndpoint(uri).iterator()).hasNext()) continue;
            Endpoint endpoint = i$.next();
            this.registry = registry;
            return endpointRegistry;
        }
        return null;
    }

    private EndpointRegistry getEndpointRegistry(ExtensionPointRegistry registry) {
        ExtensibleDomainRegistryFactory domainRegistryFactory = ExtensibleDomainRegistryFactory.getInstance(registry);
        if (domainRegistryFactory == null) {
            return null;
        }
        if (this.domainURI != null) {
            for (EndpointRegistry endpointRegistry : domainRegistryFactory.getEndpointRegistries()) {
                if (!this.domainURI.equals(endpointRegistry.getDomainURI())) continue;
                return endpointRegistry;
            }
        }
        EndpointRegistry endpointRegistry = (EndpointRegistry)domainRegistryFactory.getEndpointRegistries().toArray()[0];
        return endpointRegistry;
    }
}

