/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.wire;

import java.util.List;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.databinding.wire.DataTransformationInterceptor;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessor;

public class DataBindingRuntimeWireProcessor
implements RuntimeWireProcessor {
    private Mediator mediator;

    public DataBindingRuntimeWireProcessor(ExtensionPointRegistry registry) {
        this.mediator = registry.getExtensionPoint(UtilityExtensionPoint.class).getUtility(Mediator.class);
    }

    public boolean isTransformationRequired(DataType source, DataType target) {
        String targetDataBinding;
        if (source == null || target == null) {
            return false;
        }
        if (source == target) {
            return false;
        }
        if (source == null && target == null) {
            return false;
        }
        if (source == null || target == null) {
            return true;
        }
        String sourceDataBinding = source.getDataBinding();
        if (sourceDataBinding == (targetDataBinding = target.getDataBinding())) {
            return false;
        }
        if (sourceDataBinding == null || targetDataBinding == null) {
            return false;
        }
        return !sourceDataBinding.equals(targetDataBinding);
    }

    public boolean isTransformationRequired(Operation source, Operation target) {
        if (source == target) {
            return false;
        }
        if (source.isWrapperStyle() != target.isWrapperStyle()) {
            return true;
        }
        List<DataType> sourceOutputType = source.getOutputType().getLogical();
        List<DataType> targetOutputType = target.getOutputType().getLogical();
        int outputSize = sourceOutputType.size();
        if (outputSize != targetOutputType.size()) {
            return true;
        }
        for (int i = 0; i < outputSize; ++i) {
            if (!this.isTransformationRequired(sourceOutputType.get(i), targetOutputType.get(i))) continue;
            return true;
        }
        List<DataType> sourceInputType = source.getInputType().getLogical();
        List<DataType> targetInputType = target.getInputType().getLogical();
        int size = sourceInputType.size();
        if (size != targetInputType.size()) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            if (!this.isTransformationRequired(sourceInputType.get(i), targetInputType.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isTransformationRequired(InterfaceContract sourceContract, Operation sourceOperation, InterfaceContract targetContract, Operation targetOperation) {
        if (targetContract == null) {
            targetContract = sourceContract;
        }
        if (sourceContract == targetContract) {
            return false;
        }
        return this.isTransformationRequired(sourceOperation, targetOperation);
    }

    @Override
    public void process(RuntimeEndpoint endpoint) {
        InterfaceContract sourceContract = endpoint.getBindingInterfaceContract();
        InterfaceContract targetContract = endpoint.getComponentTypeServiceInterfaceContract();
        if (targetContract == null) {
            targetContract = sourceContract;
        }
        if (!sourceContract.getInterface().isRemotable()) {
            return;
        }
        List<InvocationChain> chains = endpoint.getInvocationChains();
        for (InvocationChain chain : chains) {
            Operation sourceOperation = chain.getSourceOperation();
            Operation targetOperation = chain.getTargetOperation();
            DataTransformationInterceptor interceptor = null;
            if (this.isTransformationRequired(sourceContract, sourceOperation, targetContract, targetOperation)) {
                interceptor = new DataTransformationInterceptor(endpoint, sourceOperation, targetOperation, this.mediator);
            }
            if (interceptor == null) continue;
            String phase = "service.interface";
            chain.addInterceptor(phase, interceptor);
        }
    }

    @Override
    public void process(RuntimeEndpointReference endpointReference) {
        InterfaceContract sourceContract = endpointReference.getComponentTypeReferenceInterfaceContract();
        InterfaceContract targetContract = endpointReference.getBindingInterfaceContract();
        if (targetContract == null) {
            targetContract = sourceContract;
        }
        if (sourceContract == null || !sourceContract.getInterface().isRemotable()) {
            return;
        }
        List<InvocationChain> chains = endpointReference.getInvocationChains();
        for (InvocationChain chain : chains) {
            Operation sourceOperation = chain.getSourceOperation();
            Operation targetOperation = chain.getTargetOperation();
            DataTransformationInterceptor interceptor = null;
            if (this.isTransformationRequired(sourceContract, sourceOperation, targetContract, targetOperation)) {
                interceptor = new DataTransformationInterceptor(endpointReference, sourceOperation, targetOperation, this.mediator);
            }
            if (interceptor == null) continue;
            String phase = "reference.interface";
            chain.addInterceptor(phase, interceptor);
        }
    }
}

