/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.processor;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.DataBinding;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;

public class WrapperJavaInterfaceProcessor
implements JavaInterfaceVisitor {
    private static final String JAXB_DATABINDING = "javax.xml.bind.JAXBElement";
    private DataBindingExtensionPoint dataBindingRegistry;

    public WrapperJavaInterfaceProcessor(ExtensionPointRegistry registry) {
        this.dataBindingRegistry = registry.getExtensionPoint(DataBindingExtensionPoint.class);
    }

    @Override
    public void visitInterface(JavaInterface javaInterface) throws InvalidInterfaceException {
        if (!javaInterface.isRemotable()) {
            return;
        }
        for (Operation operation : javaInterface.getOperations()) {
            DataBinding dbObj;
            WrapperHandler handler;
            WrapperInfo wrapper = operation.getWrapper();
            if (wrapper == null) continue;
            String db = wrapper.getDataBinding();
            if (db == null || JAXB_DATABINDING.equals(db)) {
                db = this.assignOperationDataBinding(operation);
            }
            WrapperHandler wrapperHandler = handler = (dbObj = this.dataBindingRegistry.getDataBinding(db)) == null ? null : dbObj.getWrapperHandler();
            if (handler != null) {
                wrapper.setInputWrapperType(handler.getWrapperType(operation, true));
                wrapper.setOutputWrapperType(handler.getWrapperType(operation, false));
            }
            if (dbObj == null || handler != null) continue;
            wrapper.setInputWrapperType(null);
            wrapper.setOutputWrapperType(null);
        }
    }

    private String assignOperationDataBinding(Operation operation) {
        HashSet<String> dbs = new HashSet<String>();
        LinkedList opDataTypes = new LinkedList();
        opDataTypes.addAll((Collection)operation.getInputType().getLogical());
        opDataTypes.add(operation.getOutputType());
        for (DataType dataType : operation.getFaultTypes()) {
            opDataTypes.add(dataType.getLogical());
        }
        for (DataType<Object> dataType : opDataTypes) {
            if (dataType == null) continue;
            String dataBinding = dataType.getDataBinding();
            if ("java:array".equals(dataBinding)) {
                dataBinding = ((DataType)dataType.getLogical()).getDataBinding();
            }
            if (dataBinding == null) continue;
            dbs.add(dataBinding);
        }
        dbs.remove("java:complexType");
        dbs.remove("java:simpleType");
        if (dbs.size() == 1) {
            String db = (String)dbs.iterator().next();
            operation.getWrapper().setDataBinding(db);
            return db;
        }
        return operation.getWrapper().getDataBinding();
    }
}

