/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.annotation.DataBinding;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;

public class DataBindingJavaInterfaceProcessor
implements JavaInterfaceVisitor {
    private DataBindingExtensionPoint dataBindingRegistry;

    public DataBindingJavaInterfaceProcessor(ExtensionPointRegistry registry) {
        this.dataBindingRegistry = registry.getExtensionPoint(DataBindingExtensionPoint.class);
    }

    @Override
    public void visitInterface(JavaInterface javaInterface) throws InvalidInterfaceException {
        if (!javaInterface.isRemotable()) {
            return;
        }
        List<Operation> operations = javaInterface.getOperations();
        this.processInterface(javaInterface, operations);
    }

    private void processInterface(JavaInterface javaInterface, List<Operation> operations) {
        Class<?> clazz = javaInterface.getJavaClass();
        DataBinding dataBinding = clazz.getAnnotation(DataBinding.class);
        String dataBindingId = null;
        boolean wrapperStyle = false;
        if (dataBinding != null) {
            dataBindingId = dataBinding.value();
            wrapperStyle = dataBinding.wrapped();
        }
        for (Operation op : javaInterface.getOperations()) {
            JavaOperation operation = (JavaOperation)op;
            if (dataBindingId != null) {
                op.setDataBinding(dataBindingId);
                op.setWrapperStyle(wrapperStyle);
            }
            Method method = operation.getJavaMethod();
            DataBinding methodDataBinding = clazz.getAnnotation(DataBinding.class);
            if (methodDataBinding == null) {
                methodDataBinding = dataBinding;
            }
            dataBindingId = null;
            wrapperStyle = false;
            if (dataBinding != null) {
                dataBindingId = dataBinding.value();
                wrapperStyle = dataBinding.wrapped();
                operation.setDataBinding(dataBindingId);
                operation.setWrapperStyle(wrapperStyle);
            }
            int i = 0;
            for (DataType d : operation.getInputType().getLogical()) {
                if (d.getDataBinding() == null) {
                    d.setDataBinding(dataBindingId);
                }
                for (Annotation a : method.getParameterAnnotations()[i]) {
                    if (a.annotationType() != org.apache.tuscany.sca.databinding.annotation.DataType.class) continue;
                    String value = ((org.apache.tuscany.sca.databinding.annotation.DataType)a).value();
                    d.setDataBinding(value);
                }
                this.dataBindingRegistry.introspectType(d, (Operation)operation);
                ++i;
            }
            if (operation.getOutputType() == null) continue;
            for (DataType d : operation.getOutputType().getLogical()) {
                if (d == null) continue;
                if (d.getDataBinding() == null) {
                    d.setDataBinding(dataBindingId);
                }
                this.dataBindingRegistry.introspectType(d, (Operation)operation);
            }
            org.apache.tuscany.sca.databinding.annotation.DataType dt = method.getAnnotation(org.apache.tuscany.sca.databinding.annotation.DataType.class);
            if (dt == null) continue;
            operation.getOutputType().getLogical().get(0).setDataBinding(dt.value());
        }
    }
}

