/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.context.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.context.ContextFactoryExtensionPoint;
import org.apache.tuscany.sca.context.PropertyValueFactory;
import org.apache.tuscany.sca.context.RequestContextFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.context.impl.RequestContextImpl;
import org.apache.tuscany.sca.core.context.impl.ServiceReferenceImpl;
import org.apache.tuscany.sca.core.invocation.ExtensibleProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.runtime.CompositeActivator;
import org.apache.tuscany.sca.runtime.EndpointReferenceBinder;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentContext;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.RequestContext;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class ComponentContextImpl
implements RuntimeComponentContext {
    private final RuntimeComponent component;
    private final CompositeContext compositeContext;
    private final CompositeActivator compositeActivator;
    private final RequestContextFactory requestContextFactory;
    private final ProxyFactory proxyFactory;
    private final AssemblyFactory assemblyFactory;
    private final JavaInterfaceFactory javaInterfaceFactory;
    private final PropertyValueFactory propertyFactory;
    private final EndpointReferenceBinder eprBinder;
    private final ExtensionPointRegistry registry;

    public ComponentContextImpl(ExtensionPointRegistry registry, CompositeContext compositeContext, RuntimeComponent component) {
        this.component = component;
        FactoryExtensionPoint factories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = factories.getFactory(AssemblyFactory.class);
        this.javaInterfaceFactory = factories.getFactory(JavaInterfaceFactory.class);
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.compositeContext = compositeContext;
        this.compositeActivator = utilities.getUtility(CompositeActivator.class);
        this.requestContextFactory = registry.getExtensionPoint(ContextFactoryExtensionPoint.class).getFactory(RequestContextFactory.class);
        this.proxyFactory = ExtensibleProxyFactory.getInstance(registry);
        this.propertyFactory = factories.getFactory(PropertyValueFactory.class);
        this.eprBinder = utilities.getUtility(EndpointReferenceBinder.class);
        this.registry = registry;
    }

    @Override
    public String getURI() {
        return this.component.getURI();
    }

    @Override
    public <B> ServiceReference<B> cast(B target) throws IllegalArgumentException {
        return this.proxyFactory.cast(target);
    }

    @Override
    public <B> B getService(Class<B> businessInterface, String referenceName) throws IllegalArgumentException {
        B service = null;
        ServiceReference<B> serviceRef = this.getServiceReference(businessInterface, referenceName);
        if (serviceRef != null) {
            service = serviceRef.getService();
        }
        return service;
    }

    @Override
    public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, String referenceName) throws IllegalArgumentException {
        for (ComponentReference ref : this.component.getReferences()) {
            if (!referenceName.equals(ref.getName())) continue;
            Multiplicity multiplicity = ref.getMultiplicity();
            if (multiplicity == Multiplicity.ZERO_N || multiplicity == Multiplicity.ONE_N) {
                throw new IllegalArgumentException("Reference " + referenceName + " has multiplicity " + (Object)((Object)multiplicity));
            }
            if (ref.getEndpointReferences().size() < 1) {
                return null;
            }
            ServiceReference<B> sr = this.getServiceReference(businessInterface, (RuntimeEndpointReference)this.getEndpointReference(ref));
            if (sr == null) {
                throw new IllegalArgumentException("Reference " + referenceName + " is null");
            }
            return sr;
        }
        throw new IllegalArgumentException("[JCA80011] Reference not found: " + referenceName);
    }

    private EndpointReference getEndpointReference(ComponentReference ref) {
        List<EndpointReference> eprs = ref.getEndpointReferences();
        if (eprs.size() == 1) {
            return eprs.get(0);
        }
        for (EndpointReference epr : eprs) {
            if (!epr.getBinding().getType().equals(SCABinding.TYPE)) continue;
            return epr;
        }
        return eprs.get(0);
    }

    private Endpoint getEndpoint(ComponentService service, String bindingName) {
        if (bindingName == null) {
            bindingName = this.getPromotedService(service).getName();
        }
        Endpoint returnEp = null;
        List<Endpoint> eps = service.getEndpoints();
        for (Endpoint ep : eps) {
            Binding binding = ep.getBinding();
            if (!bindingName.equals(binding.getName()) && binding.getName() != null) continue;
            returnEp = ep;
            break;
        }
        if (returnEp == null) {
            returnEp = eps.get(0);
        }
        return returnEp;
    }

    private ComponentService getPromotedService(ComponentService componentService) {
        Service service = componentService.getService();
        if (service instanceof CompositeService) {
            return this.getPromotedService(((CompositeService)service).getPromotedService());
        }
        return componentService;
    }

    @Override
    public <B> B getProperty(Class<B> type, String propertyName) {
        for (ComponentProperty p : this.component.getProperties()) {
            if (!propertyName.equals(p.getName())) continue;
            return this.propertyFactory.createPropertyValue(p, type);
        }
        throw new IllegalArgumentException("Property not found: " + propertyName);
    }

    public static ComponentService getSingleService(Component component) {
        List<ComponentService> services = component.getServices();
        ArrayList<ComponentService> regularServices = new ArrayList<ComponentService>();
        for (ComponentService service : services) {
            String name;
            if (service.isForCallback() || (name = service.getName()).startsWith("$") && !name.startsWith("$dynamic$")) continue;
            regularServices.add(service);
        }
        if (regularServices.size() == 0) {
            throw new ServiceRuntimeException("No service is declared on component " + component.getURI());
        }
        if (regularServices.size() != 1) {
            throw new ServiceRuntimeException("More than one service is declared on component " + component.getURI() + ". Service name is required to get the service.");
        }
        ComponentService targetService = (ComponentService)regularServices.get(0);
        return targetService;
    }

    @Override
    public <B> ServiceReference<B> createSelfReference(Class<B> businessInterface) {
        ComponentService service = ComponentContextImpl.getSingleService(this.component);
        try {
            return this.createSelfReference(businessInterface, service);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public <B> ServiceReference<B> createSelfReference(Class<B> businessInterface, String serviceName) {
        if (serviceName == null) {
            return this.createSelfReference(businessInterface);
        }
        try {
            String bindingName = null;
            int index = serviceName.indexOf(47);
            if (index != -1) {
                bindingName = serviceName.substring(index + 1);
                serviceName = serviceName.substring(0, index);
            }
            for (ComponentService service : this.component.getServices()) {
                if (!serviceName.equals(service.getName())) continue;
                Endpoint endpoint = this.getEndpoint(service, bindingName);
                if (endpoint == null) break;
                return this.getServiceReference(businessInterface, (RuntimeEndpoint)endpoint);
            }
            throw new IllegalArgumentException("Service not found: " + serviceName);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (ServiceRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public <B> ServiceReference<B> createSelfReference(Class<B> businessInterface, ComponentService service) {
        try {
            RuntimeEndpointReference ref = (RuntimeEndpointReference)this.createEndpointReference(this.component, service, null, businessInterface);
            ref.setComponent(this.component);
            return this.getServiceReference(businessInterface, ref);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    @Override
    public RequestContext getRequestContext() {
        if (this.requestContextFactory != null) {
            return this.requestContextFactory.createRequestContext(this.component);
        }
        return new RequestContextImpl(this.component);
    }

    @Override
    public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, RuntimeEndpointReference endpointReference) {
        ServiceReferenceImpl<B> result = null;
        try {
            InterfaceContract interfaceContract = endpointReference.getComponentTypeReferenceInterfaceContract();
            if (businessInterface == null) {
                businessInterface = ((JavaInterface)interfaceContract.getInterface()).getJavaClass();
            }
            RuntimeComponentReference ref = (RuntimeComponentReference)endpointReference.getReference();
            InterfaceContract refInterfaceContract = this.getInterfaceContract(interfaceContract, businessInterface);
            if (refInterfaceContract != null) {
                if (refInterfaceContract != interfaceContract) {
                    ref = (RuntimeComponentReference)ref.clone();
                    if (interfaceContract != null) {
                        ref.setInterfaceContract(interfaceContract);
                    } else {
                        ref.setInterfaceContract(refInterfaceContract);
                    }
                }
                ref.setComponent(this.component);
                result = new ServiceReferenceImpl<B>(businessInterface, endpointReference, this.component.getComponentContext().getCompositeContext());
            }
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
        return result;
    }

    @Override
    public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, RuntimeEndpoint endpoint) {
        try {
            if (businessInterface == null) {
                InterfaceContract contract = endpoint.getComponentTypeServiceInterfaceContract();
                businessInterface = ((JavaInterface)contract.getInterface()).getJavaClass();
            }
            RuntimeEndpointReference ref = (RuntimeEndpointReference)this.createEndpointReference(endpoint, businessInterface);
            ref.setComponent(this.component);
            return new ServiceReferenceImpl<B>(businessInterface, ref, this.compositeContext);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    private EndpointReference createEndpointReference(Component component, ComponentService service, String bindingName, Class<?> businessInterface) throws CloneNotSupportedException, InvalidInterfaceException {
        Endpoint endpoint = this.getEndpoint(service, bindingName);
        return this.createEndpointReference(endpoint, businessInterface);
    }

    private EndpointReference createEndpointReference(Endpoint endpoint, Class<?> businessInterface) throws CloneNotSupportedException, InvalidInterfaceException {
        Component component = endpoint.getComponent();
        ComponentService service = endpoint.getService();
        ComponentReference componentReference = this.assemblyFactory.createComponentReference();
        componentReference.setName("$self$." + service.getName());
        componentReference.setCallback(service.getCallback());
        componentReference.getTargets().add(service);
        componentReference.getPolicySets().addAll(service.getPolicySets());
        componentReference.getRequiredIntents().addAll(service.getRequiredIntents());
        componentReference.getBindings().add(endpoint.getBinding());
        InterfaceContract interfaceContract = service.getInterfaceContract();
        Service componentTypeService = service.getService();
        if (componentTypeService != null && componentTypeService.getInterfaceContract() != null) {
            interfaceContract = componentTypeService.getInterfaceContract();
        }
        interfaceContract = this.getInterfaceContract(interfaceContract, businessInterface);
        componentReference.setInterfaceContract(interfaceContract);
        componentReference.setMultiplicity(Multiplicity.ONE_ONE);
        EndpointReference endpointReference = this.assemblyFactory.createEndpointReference();
        endpointReference.setComponent(component);
        endpointReference.setReference(componentReference);
        endpointReference.setBinding(endpoint.getBinding());
        endpointReference.setUnresolved(false);
        endpointReference.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_READY_FOR_MATCHING);
        endpointReference.setTargetEndpoint(endpoint);
        componentReference.getEndpointReferences().add(endpointReference);
        ((RuntimeComponentReference)componentReference).setComponent((RuntimeComponent)component);
        ((RuntimeEndpointReference)endpointReference).bind(this.compositeContext);
        return endpointReference;
    }

    private InterfaceContract getInterfaceContract(InterfaceContract interfaceContract, Class<?> businessInterface) throws CloneNotSupportedException, InvalidInterfaceException {
        Interface interfaze;
        if (businessInterface == null) {
            return interfaceContract;
        }
        if (interfaceContract == null) {
            JavaInterfaceContract ic = this.javaInterfaceFactory.createJavaInterfaceContract();
            ic.setInterface(this.javaInterfaceFactory.createJavaInterface(businessInterface));
            return ic;
        }
        boolean compatible = false;
        if (interfaceContract != null && interfaceContract.getInterface() != null && (interfaze = interfaceContract.getInterface()) instanceof JavaInterface) {
            Class<?> cls = ((JavaInterface)interfaze).getJavaClass();
            if (businessInterface.isAssignableFrom(cls)) {
                compatible = true;
            }
            if (!compatible) {
                JavaInterfaceContract biContract = this.javaInterfaceFactory.createJavaInterfaceContract();
                JavaInterface callInterface = this.javaInterfaceFactory.createJavaInterface(businessInterface);
                biContract.setInterface(callInterface);
                if (callInterface.getCallbackClass() != null) {
                    biContract.setCallbackInterface(this.javaInterfaceFactory.createJavaInterface(callInterface.getCallbackClass()));
                }
                InterfaceContractMapper ifcm = this.registry.getExtensionPoint(InterfaceContractMapper.class);
                compatible = ifcm.isCompatibleSubset(biContract, interfaceContract);
            }
        }
        if (!compatible) {
            throw new IllegalArgumentException("Business interface " + businessInterface.getName() + " is not compatible with " + interfaceContract.getInterface());
        }
        return interfaceContract;
    }

    @Override
    public <B> Collection<B> getServices(Class<B> businessInterface, String referenceName) {
        ArrayList<B> services = new ArrayList<B>();
        Collection<ServiceReference<B>> serviceRefs = this.getServiceReferences(businessInterface, referenceName);
        for (ServiceReference<B> serviceRef : serviceRefs) {
            services.add(serviceRef.getService());
        }
        return services;
    }

    @Override
    public <B> Collection<ServiceReference<B>> getServiceReferences(Class<B> businessInterface, String referenceName) {
        try {
            for (ComponentReference ref : this.component.getReferences()) {
                if (!referenceName.equals(ref.getName())) continue;
                if (ref.getMultiplicity() == Multiplicity.ONE_ONE) {
                    throw new IllegalArgumentException("Reference " + referenceName + " is not a valid argument for getServiceReferences because it has a multiplicity of 1..1");
                }
                if (ref.getMultiplicity() == Multiplicity.ZERO_ONE) {
                    throw new IllegalArgumentException("Reference " + referenceName + " is not a valid argument for getServiceReferences because it has a multiplicity of 0..1");
                }
                ArrayList<ServiceReference<B>> serviceRefs = new ArrayList<ServiceReference<B>>();
                for (EndpointReference endpointReference : ref.getEndpointReferences()) {
                    RuntimeEndpointReference epr = (RuntimeEndpointReference)endpointReference;
                    serviceRefs.add(this.getServiceReference(businessInterface, epr));
                }
                return serviceRefs;
            }
            throw new IllegalArgumentException("Reference not found: " + referenceName);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (ServiceRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public CompositeContext getCompositeContext() {
        return this.compositeContext;
    }

    @Override
    public ExtensionPointRegistry getExtensionPointRegistry() {
        return this.getCompositeContext().getExtensionPointRegistry();
    }
}

