/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.context.impl;

import java.util.List;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.context.ThreadMessageContext;
import org.apache.tuscany.sca.core.context.impl.ServiceReferenceImpl;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class CallbackServiceReferenceImpl<B>
extends ServiceReferenceImpl<B> {
    private RuntimeEndpointReference callbackEPR;
    private List<? extends EndpointReference> callbackEPRs;
    private Endpoint resolvedEndpoint;
    private String msgID;

    public String getMsgID() {
        return this.msgID;
    }

    public CallbackServiceReferenceImpl() {
    }

    public CallbackServiceReferenceImpl(Class<B> interfaze, List<? extends EndpointReference> callbackEPRs) {
        super(interfaze, null, CallbackServiceReferenceImpl.getCompositeContext(callbackEPRs));
        this.callbackEPRs = callbackEPRs;
        this.init();
    }

    private static CompositeContext getCompositeContext(List<? extends EndpointReference> callbackEPRs) {
        if (!callbackEPRs.isEmpty()) {
            RuntimeEndpointReference epr = (RuntimeEndpointReference)callbackEPRs.get(0);
            return epr.getCompositeContext();
        }
        return null;
    }

    public void init() {
        Message msgContext = ThreadMessageContext.getMessageContext();
        this.callbackEPR = this.selectCallbackEPR(msgContext);
        if (this.callbackEPR == null) {
            throw new ServiceRuntimeException("No callback binding found for " + msgContext.getTo().toString());
        }
        this.resolvedEndpoint = msgContext.getFrom().getCallbackEndpoint();
        this.msgID = (String)msgContext.getHeaders().get("MESSAGE_ID");
    }

    @Override
    protected B createProxy() throws Exception {
        return (B)this.proxyFactory.createCallbackProxy(this);
    }

    public RuntimeEndpointReference getCallbackEPR() {
        if (this.resolvedEndpoint == null) {
            return null;
        }
        return this.cloneAndBind(this.callbackEPR);
    }

    public Endpoint getResolvedEndpoint() {
        return this.resolvedEndpoint;
    }

    private RuntimeEndpointReference selectCallbackEPR(Message msgContext) {
        Endpoint to = msgContext.getTo();
        if (to == null) {
            throw new ServiceRuntimeException("Destination for forward call is not available");
        }
        for (EndpointReference endpointReference : this.callbackEPRs) {
            if (!endpointReference.getBinding().getName().equals(to.getBinding().getName())) continue;
            return (RuntimeEndpointReference)endpointReference;
        }
        for (EndpointReference endpointReference : this.callbackEPRs) {
            if (!endpointReference.getBinding().getType().equals(to.getBinding().getType())) continue;
            return (RuntimeEndpointReference)endpointReference;
        }
        return null;
    }

    private RuntimeEndpointReference cloneAndBind(RuntimeEndpointReference endpointReference) {
        if (this.resolvedEndpoint != null) {
            try {
                RuntimeEndpointReference epr = (RuntimeEndpointReference)endpointReference.clone();
                epr.setTargetEndpoint(this.resolvedEndpoint);
                return epr;
            }
            catch (CloneNotSupportedException e) {
                throw new ServiceRuntimeException(e);
            }
        }
        return null;
    }
}

