/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.assembly.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.BindingBuilder;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.assembly.impl.EndpointImpl;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLInputFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.assembly.RuntimeAssemblyFactory;
import org.apache.tuscany.sca.core.invocation.AsyncResponseService;
import org.apache.tuscany.sca.core.invocation.ExtensibleWireProcessor;
import org.apache.tuscany.sca.core.invocation.NonBlockingInterceptor;
import org.apache.tuscany.sca.core.invocation.RuntimeInvoker;
import org.apache.tuscany.sca.core.invocation.impl.InvocationChainImpl;
import org.apache.tuscany.sca.core.invocation.impl.PhaseManager;
import org.apache.tuscany.sca.interfacedef.Compatibility;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.invocation.InterceptorAsync;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.InvokerAsyncResponse;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;
import org.apache.tuscany.sca.node.NodeFactory;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.EndpointAsyncProvider;
import org.apache.tuscany.sca.provider.EndpointProvider;
import org.apache.tuscany.sca.provider.ImplementationAsyncProvider;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.provider.OptimisingBindingProvider;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.provider.PolicyProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.EndpointRegistry;
import org.apache.tuscany.sca.runtime.EndpointSerializer;
import org.apache.tuscany.sca.runtime.ExtensibleDomainRegistryFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessor;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessorExtensionPoint;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.oasisopen.sca.ServiceRuntimeException;

public class RuntimeEndpointImpl
extends EndpointImpl
implements RuntimeEndpoint,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient CompositeContext compositeContext;
    private transient RuntimeWireProcessor wireProcessor;
    private transient ProviderFactoryExtensionPoint providerFactories;
    private transient InterfaceContractMapper interfaceContractMapper;
    private transient WorkScheduler workScheduler;
    private transient PhaseManager phaseManager;
    private transient MessageFactory messageFactory;
    private transient RuntimeInvoker invoker;
    private transient EndpointSerializer serializer;
    private transient List<InvocationChain> chains;
    private transient Map<Operation, InvocationChain> invocationChainMap = new ConcurrentHashMap<Operation, InvocationChain>();
    private transient InvocationChain bindingInvocationChain;
    private transient ServiceBindingProvider bindingProvider;
    private transient List<PolicyProvider> policyProviders;
    private String xml;
    protected InterfaceContract bindingInterfaceContract;
    protected InterfaceContract serviceInterfaceContract;
    private static final InvocationChain NULL_CHAIN = new InvocationChainImpl(null, null, false, null, false);

    public RuntimeEndpointImpl() {
        super(null);
    }

    public RuntimeEndpointImpl(ExtensionPointRegistry registry) {
        super(registry);
    }

    protected void copyFrom(RuntimeEndpointImpl copy) {
        this.xml = copy.xml;
        this.component = copy.component;
        this.service = copy.service;
        this.interfaceContract = copy.interfaceContract;
        this.serviceInterfaceContract = copy.serviceInterfaceContract;
        this.binding = copy.binding;
        this.bindingInterfaceContract = copy.interfaceContract;
        this.bindingInvocationChain = copy.bindingInvocationChain;
        this.callbackEndpointReferences = copy.callbackEndpointReferences;
        this.requiredIntents = copy.requiredIntents;
        this.policySets = copy.policySets;
        this.uri = copy.uri;
        this.remote = copy.remote;
        this.unresolved = copy.unresolved;
        this.chains = copy.chains;
        this.invocationChainMap = copy.invocationChainMap;
        this.bindingProvider = copy.bindingProvider;
        this.policyProviders = copy.policyProviders;
        if (this.compositeContext == null && copy.compositeContext != null) {
            this.bind(copy.compositeContext);
        }
    }

    @Override
    public void bind(CompositeContext compositeContext) {
        this.compositeContext = compositeContext;
        this.bind(compositeContext.getExtensionPointRegistry(), compositeContext.getEndpointRegistry());
    }

    @Override
    public void bind(ExtensionPointRegistry registry, EndpointRegistry endpointRegistry) {
        if (this.compositeContext == null) {
            this.compositeContext = new CompositeContext(registry, endpointRegistry);
        }
        this.registry = registry;
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.interfaceContractMapper = utilities.getUtility(InterfaceContractMapper.class);
        this.workScheduler = utilities.getUtility(WorkScheduler.class);
        this.wireProcessor = new ExtensibleWireProcessor(registry.getExtensionPoint(RuntimeWireProcessorExtensionPoint.class));
        this.messageFactory = registry.getExtensionPoint(FactoryExtensionPoint.class).getFactory(MessageFactory.class);
        this.invoker = new RuntimeInvoker(registry, this);
        this.phaseManager = utilities.getUtility(PhaseManager.class);
        this.serializer = utilities.getUtility(EndpointSerializer.class);
        this.providerFactories = registry.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        this.builders = registry.getExtensionPoint(BuilderExtensionPoint.class);
        this.contractBuilder = this.builders.getContractBuilder();
    }

    @Override
    public void unbind() {
        this.compositeContext = null;
        this.bindingInvocationChain = null;
        this.chains = null;
        this.bindingProvider = null;
        this.policyProviders = null;
        this.invocationChainMap.clear();
    }

    @Override
    public synchronized List<InvocationChain> getInvocationChains() {
        if (this.chains == null) {
            this.initInvocationChains();
        }
        return this.chains;
    }

    @Override
    public synchronized InvocationChain getBindingInvocationChain() {
        if (this.bindingInvocationChain == null) {
            this.bindingInvocationChain = new InvocationChainImpl(null, null, false, this.phaseManager, this.isAsyncInvocation());
            this.initServiceBindingInvocationChains();
        }
        this.getInvocationChains();
        return this.bindingInvocationChain;
    }

    @Override
    public InvocationChain getInvocationChain(Operation operation) {
        InvocationChain cached = this.invocationChainMap.get(operation);
        if (cached == null) {
            for (InvocationChain chain : this.getInvocationChains()) {
                Operation op = chain.getTargetOperation();
                if (operation.getInterface().isRemotable()) {
                    if (operation.getName().equals(op.getName())) {
                        this.invocationChainMap.put(operation, chain);
                        return chain;
                    }
                    if (!this.interfaceContractMapper.isCompatible(operation, op, Compatibility.SUBSET)) continue;
                    this.invocationChainMap.put(operation, chain);
                    return chain;
                }
                if (!this.interfaceContractMapper.isCompatible(operation, op, Compatibility.SUBSET)) continue;
                this.invocationChainMap.put(operation, chain);
                return chain;
            }
            this.invocationChainMap.put(operation, NULL_CHAIN);
            return null;
        }
        if (cached == NULL_CHAIN) {
            cached = null;
        }
        return cached;
    }

    @Override
    public Message invoke(Message msg) {
        this.getInvocationChains();
        if (this.isAsyncInvocation() && !this.getCallbackEndpointReferences().isEmpty()) {
            RuntimeEndpointReference asyncEPR = (RuntimeEndpointReference)this.getCallbackEndpointReferences().get(0);
            msg.getHeaders().put("ASYNC_CALLBACK", asyncEPR);
        }
        return this.invoker.invokeBinding(msg);
    }

    @Override
    public Object invoke(Operation operation, Object[] args) throws InvocationTargetException {
        return this.invoker.invoke(operation, args);
    }

    @Override
    public Message invoke(Operation operation, Message msg) {
        return this.invoker.invoke(operation, msg);
    }

    @Override
    public void invokeAsync(Message msg) {
        this.invoker.invokeBindingAsync(msg);
    }

    @Override
    public void invokeAsync(Operation operation, Message msg) {
        msg.setOperation(operation);
        this.invoker.invokeAsync(msg);
    }

    @Override
    public void invokeAsyncResponse(Message msg) {
        this.resolve();
        this.invoker.invokeAsyncResponse(msg);
    }

    private Contract getLeafContract(Contract contract) {
        Contract prev = null;
        Contract current = contract;
        while (current != null) {
            prev = current;
            if (current instanceof ComponentReference) {
                current = ((ComponentReference)current).getReference();
            } else if (current instanceof CompositeReference) {
                current = ((CompositeReference)current).getPromotedReferences().get(0);
            } else if (current instanceof ComponentService) {
                current = ((ComponentService)current).getService();
            } else {
                if (!(current instanceof CompositeService)) break;
                current = ((CompositeService)current).getPromotedService();
            }
            if (current != null) continue;
            return prev;
        }
        return current;
    }

    private void initInvocationChains() {
        ServiceBindingProvider provider;
        ServiceBindingProvider serviceBindingProvider;
        this.chains = new ArrayList<InvocationChain>();
        InterfaceContract sourceContract = this.getBindingInterfaceContract();
        RuntimeComponentService service = (RuntimeComponentService)this.getService();
        RuntimeComponent serviceComponent = (RuntimeComponent)this.getComponent();
        InterfaceContract targetContract = this.getComponentTypeServiceInterfaceContract();
        this.validateServiceInterfaceCompatibility();
        for (Operation operation : sourceContract.getInterface().getOperations()) {
            Operation targetOperation = this.interfaceContractMapper.map(targetContract.getInterface(), operation);
            if (targetOperation == null) {
                throw new ServiceRuntimeException("No matching operation for " + operation.getName() + " is found in service " + serviceComponent.getURI() + "#" + service.getName());
            }
            InvocationChainImpl chain = new InvocationChainImpl(operation, targetOperation, false, this.phaseManager, this.isAsyncInvocation());
            if (operation.isNonBlocking()) {
                this.addNonBlockingInterceptor(chain);
            }
            this.addServiceBindingInterceptor(chain, operation);
            this.addImplementationInterceptor(serviceComponent, service, chain, targetOperation);
            this.chains.add(chain);
            if (!targetOperation.isAsyncServer()) continue;
            this.createAsyncServerCallback();
        }
        this.wireProcessor.process(this);
        if (this.isAsyncInvocation() && this.bindingInvocationChain == null && (serviceBindingProvider = this.getBindingProvider()) instanceof EndpointAsyncProvider) {
            EndpointAsyncProvider asyncEndpointProvider = (EndpointAsyncProvider)serviceBindingProvider;
            InvokerAsyncResponse asyncResponseInvoker = asyncEndpointProvider.createAsyncResponseInvoker();
            for (InvocationChain chain : this.getInvocationChains()) {
                Invoker invoker = chain.getHeadInvoker();
                if (!(invoker instanceof InterceptorAsync)) continue;
                ((InterceptorAsync)invoker).setPrevious(asyncResponseInvoker);
            }
        }
        if ((provider = this.getBindingProvider()) != null && provider instanceof OptimisingBindingProvider) {
            ((OptimisingBindingProvider)((Object)provider)).optimiseBinding(this);
        }
    }

    @Override
    public void createAsyncServerCallback() {
        if (this.hasNativeAsyncBinding(this)) {
            return;
        }
        if (this.asyncCallbackExists(this)) {
            return;
        }
        RuntimeEndpointReference asyncEPR = this.createAsyncEPR(this);
        this.getCallbackEndpointReferences().add(asyncEPR);
        EndpointRegistry epReg = this.getEndpointRegistry(this.registry);
        if (epReg != null) {
            epReg.addEndpointReference(asyncEPR);
        }
    }

    @Override
    public RuntimeEndpointReference getAsyncServerCallback() {
        return (RuntimeEndpointReference)this.getCallbackEndpointReferences().get(0);
    }

    private boolean hasNativeAsyncBinding(RuntimeEndpoint endpoint) {
        EndpointAsyncProvider asyncProvider;
        ServiceBindingProvider provider = endpoint.getBindingProvider();
        return provider instanceof EndpointAsyncProvider && (asyncProvider = (EndpointAsyncProvider)provider).supportsNativeAsync();
    }

    private RuntimeEndpointReference createAsyncEPR(RuntimeEndpoint endpoint) {
        CompositeContext compositeContext = endpoint.getCompositeContext();
        RuntimeAssemblyFactory assemblyFactory = this.getAssemblyFactory(compositeContext);
        RuntimeEndpointReference epr = (RuntimeEndpointReference)assemblyFactory.createEndpointReference();
        epr.bind(compositeContext);
        epr.setComponent(this.component);
        ComponentReference reference = assemblyFactory.createComponentReference();
        ExtensionPointRegistry registry = compositeContext.getExtensionPointRegistry();
        FactoryExtensionPoint modelFactories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        JavaInterfaceFactory javaInterfaceFactory = modelFactories.getFactory(JavaInterfaceFactory.class);
        JavaInterfaceContract interfaceContract = javaInterfaceFactory.createJavaInterfaceContract();
        try {
            interfaceContract.setInterface(javaInterfaceFactory.createJavaInterface(AsyncResponseService.class));
        }
        catch (InvalidInterfaceException e1) {
            // empty catch block
        }
        reference.setInterfaceContract(interfaceContract);
        String referenceName = endpoint.getService().getName() + "_asyncCallback";
        reference.setName(referenceName);
        reference.setForCallback(true);
        Reference implReference = assemblyFactory.createReference();
        implReference.setInterfaceContract(interfaceContract);
        implReference.setName(referenceName);
        implReference.setForCallback(true);
        reference.setReference(implReference);
        epr.setReference(reference);
        Binding binding = this.createMatchingBinding(endpoint.getBinding(), (RuntimeComponent)endpoint.getComponent(), reference, registry);
        epr.setBinding(binding);
        epr.getRequiredIntents().addAll(endpoint.getRequiredIntents());
        epr.getPolicySets().addAll(endpoint.getPolicySets());
        RuntimeEndpoint ep = (RuntimeEndpoint)assemblyFactory.createEndpoint();
        ep.setUnresolved(false);
        epr.setTargetEndpoint(ep);
        epr.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED);
        epr.setUnresolved(false);
        String eprURI = endpoint.getComponent().getName() + "#reference-binding(" + referenceName + "/" + referenceName + ")";
        epr.setURI(eprURI);
        return epr;
    }

    private boolean asyncCallbackExists(RuntimeEndpoint endpoint) {
        return !endpoint.getCallbackEndpointReferences().isEmpty();
    }

    private Binding createMatchingBinding(Binding matchBinding, RuntimeComponent component, ComponentReference reference, ExtensionPointRegistry registry) {
        QName bindingName = matchBinding.getType();
        String bindingXML = "<ns1:" + bindingName.getLocalPart() + " xmlns:ns1='" + bindingName.getNamespaceURI() + "'/>";
        StAXArtifactProcessorExtensionPoint processors = registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        StAXArtifactProcessor processor = processors.getProcessor(bindingName);
        FactoryExtensionPoint modelFactories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        ValidatingXMLInputFactory inputFactory = modelFactories.getFactory(ValidatingXMLInputFactory.class);
        StreamSource source = new StreamSource(new StringReader(bindingXML));
        ProcessorContext context = new ProcessorContext();
        try {
            XMLStreamReader reader = inputFactory.createXMLStreamReader(source);
            reader.next();
            Binding newBinding = (Binding)processor.read(reader, context);
            newBinding.setName(reference.getName());
            BuilderExtensionPoint builders = registry.getExtensionPoint(BuilderExtensionPoint.class);
            BindingBuilder<Binding> builder = builders.getBindingBuilder(newBinding.getType());
            if (builder != null) {
                BuilderContext builderContext = new BuilderContext(registry);
                builder.build(component, reference, newBinding, builderContext, true);
            }
            return newBinding;
        }
        catch (ContributionReadException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return null;
    }

    private RuntimeAssemblyFactory getAssemblyFactory(CompositeContext compositeContext) {
        ExtensionPointRegistry registry = compositeContext.getExtensionPointRegistry();
        FactoryExtensionPoint modelFactories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        return (RuntimeAssemblyFactory)modelFactories.getFactory(AssemblyFactory.class);
    }

    @Override
    public void validateServiceInterfaceCompatibility() {
        InterfaceContract serviceContract = this.getComponentServiceInterfaceContract();
        InterfaceContract bindingContract = this.getBindingInterfaceContract();
        if (serviceContract != null && bindingContract != null) {
            boolean bindingHasCallback = bindingContract.getCallbackInterface() != null;
            try {
                if (serviceContract.getClass() != bindingContract.getClass() || serviceContract.getNormalizedWSDLContract() != null || bindingContract.getNormalizedWSDLContract() != null) {
                    this.interfaceContractMapper.checkCompatibility(this.getGeneratedWSDLContract(serviceContract), this.getGeneratedWSDLContract(bindingContract), Compatibility.SUBSET, !bindingHasCallback, false);
                } else {
                    this.interfaceContractMapper.checkCompatibility(serviceContract, bindingContract, Compatibility.SUBSET, !bindingHasCallback, false);
                }
            }
            catch (Exception ex) {
                throw new ServiceRuntimeException("Component " + this.getComponent().getName() + " Service " + this.getService().getName() + " interface is incompatible with the interface of the service binding  - " + this.getBinding().getName() + " - " + ex.getMessage() + " - [" + this.toString() + "]");
            }
        }
    }

    private void initServiceBindingInvocationChains() {
        List<PolicyProvider> pps;
        ServiceBindingProvider provider = this.getBindingProvider();
        if (provider != null && provider instanceof EndpointProvider) {
            ((EndpointProvider)provider).configure();
        }
        if ((pps = this.getPolicyProviders()) != null) {
            for (PolicyProvider p : pps) {
                PhasedInterceptor interceptor = p.createBindingInterceptor();
                if (interceptor == null) continue;
                this.bindingInvocationChain.addInterceptor(interceptor);
            }
        }
        if (this.isAsyncInvocation()) {
            for (InvocationChain chain : this.getInvocationChains()) {
                Invoker invoker = chain.getHeadInvoker();
                if (!(invoker instanceof InterceptorAsync)) continue;
                ((InterceptorAsync)invoker).setPrevious((InvokerAsyncResponse)((Object)this.bindingInvocationChain.getTailInvoker()));
            }
            ServiceBindingProvider serviceBindingProvider = this.getBindingProvider();
            if (serviceBindingProvider instanceof EndpointAsyncProvider) {
                EndpointAsyncProvider asyncEndpointProvider = (EndpointAsyncProvider)serviceBindingProvider;
                InvokerAsyncResponse asyncResponseInvoker = asyncEndpointProvider.createAsyncResponseInvoker();
                if (this.bindingInvocationChain.getHeadInvoker() instanceof InterceptorAsync) {
                    ((InterceptorAsync)this.bindingInvocationChain.getHeadInvoker()).setPrevious(asyncResponseInvoker);
                }
            }
        }
        this.bindingInvocationChain.addInvoker(this.invoker);
    }

    private void addServiceBindingInterceptor(InvocationChain chain, Operation operation) {
        List<PolicyProvider> pps = this.getPolicyProviders();
        if (pps != null) {
            for (PolicyProvider p : pps) {
                PhasedInterceptor interceptor = p.createInterceptor(operation);
                if (interceptor == null) continue;
                chain.addInterceptor(interceptor);
            }
        }
    }

    private void addNonBlockingInterceptor(InvocationChain chain) {
        ServiceBindingProvider provider = this.getBindingProvider();
        if (provider != null && !provider.supportsOneWayInvocation()) {
            chain.addInterceptor("component.service", new NonBlockingInterceptor(this.workScheduler));
        }
    }

    private void addImplementationInterceptor(Component component, ComponentService service, InvocationChain chain, Operation operation) {
        List<PolicyProvider> pps;
        ImplementationProvider provider;
        if (service.getService() instanceof CompositeService) {
            CompositeService compositeService = (CompositeService)service.getService();
            component = this.getPromotedComponent(compositeService);
            service = this.getPromotedComponentService(compositeService);
        }
        if ((provider = ((RuntimeComponent)component).getImplementationProvider()) != null) {
            Invoker invoker = null;
            RuntimeComponentService runtimeService = (RuntimeComponentService)service;
            invoker = runtimeService.getName().endsWith("_asyncCallback") ? (provider instanceof ImplementationAsyncProvider ? (Invoker)((Object)((ImplementationAsyncProvider)provider).createAsyncResponseInvoker(operation)) : provider.createInvoker((RuntimeComponentService)service, operation)) : (this.isAsyncInvocation() && provider instanceof ImplementationAsyncProvider ? (Invoker)((Object)((ImplementationAsyncProvider)provider).createAsyncInvoker((RuntimeComponentService)service, operation)) : provider.createInvoker((RuntimeComponentService)service, operation));
            chain.addInvoker(invoker);
        }
        if ((pps = ((RuntimeComponent)component).getPolicyProviders()) != null) {
            for (PolicyProvider p : pps) {
                PhasedInterceptor interceptor = p.createInterceptor(operation);
                if (interceptor == null) continue;
                chain.addInterceptor(interceptor);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RuntimeEndpointImpl copy = (RuntimeEndpointImpl)super.clone();
        copy.invoker = new RuntimeInvoker(this.registry, copy);
        return copy;
    }

    private ComponentService getPromotedComponentService(CompositeService compositeService) {
        ComponentService componentService = compositeService.getPromotedService();
        if (componentService != null) {
            Service service = componentService.getService();
            if (componentService.getName() != null && service instanceof CompositeService) {
                return this.getPromotedComponentService((CompositeService)service);
            }
            return componentService;
        }
        return null;
    }

    private Component getPromotedComponent(CompositeService compositeService) {
        ComponentService componentService = compositeService.getPromotedService();
        if (componentService != null) {
            Service service = componentService.getService();
            if (componentService.getName() != null && service instanceof CompositeService) {
                return this.getPromotedComponent((CompositeService)service);
            }
            return compositeService.getPromotedComponent();
        }
        return null;
    }

    @Override
    public synchronized ServiceBindingProvider getBindingProvider() {
        this.resolve();
        if (this.bindingProvider == null) {
            BindingProviderFactory factory = (BindingProviderFactory)this.providerFactories.getProviderFactory(this.getBinding().getClass());
            if (factory == null) {
                throw new ServiceRuntimeException("No provider factory is registered for binding " + this.getBinding().getType());
            }
            this.bindingProvider = factory.createServiceBindingProvider(this);
        }
        return this.bindingProvider;
    }

    @Override
    public synchronized List<PolicyProvider> getPolicyProviders() {
        this.resolve();
        if (this.policyProviders == null) {
            this.policyProviders = new ArrayList<PolicyProvider>();
            for (PolicyProviderFactory factory : this.providerFactories.getPolicyProviderFactories()) {
                PolicyProvider provider = factory.createServicePolicyProvider(this);
                if (provider == null) continue;
                this.policyProviders.add(provider);
            }
        }
        return this.policyProviders;
    }

    @Override
    public void setBindingProvider(ServiceBindingProvider provider) {
        this.bindingProvider = provider;
    }

    @Override
    public Contract getContract() {
        return this.getService();
    }

    @Override
    public CompositeContext getCompositeContext() {
        return this.compositeContext;
    }

    @Override
    protected void reset() {
        super.reset();
        this.xml = null;
    }

    @Override
    protected synchronized void resolve() {
        if (this.xml != null && this.component == null) {
            if (this.compositeContext == null) {
                this.compositeContext = CompositeContext.getCurrentCompositeContext();
                if (this.compositeContext != null) {
                    this.bind(this.compositeContext);
                }
            }
            if (this.serializer != null) {
                RuntimeEndpointImpl ep = (RuntimeEndpointImpl)this.serializer.readEndpoint(this.xml);
                this.copyFrom(ep);
            } else {
                for (NodeFactory factory : NodeFactory.getNodeFactories()) {
                    ExtensionPointRegistry registry = (ExtensionPointRegistry)factory.getExtensionPointRegistry();
                    if (registry == null) continue;
                    this.registry = registry;
                    UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
                    this.interfaceContractMapper = utilities.getUtility(InterfaceContractMapper.class);
                    this.serializer = utilities.getUtility(EndpointSerializer.class);
                    RuntimeEndpointImpl ep = (RuntimeEndpointImpl)this.serializer.readEndpoint(this.xml);
                    if ((ep = this.findActualEP(ep, registry)) == null) continue;
                    this.copyFrom(ep);
                    break;
                }
            }
        }
        super.resolve();
    }

    private RuntimeEndpointImpl findActualEP(RuntimeEndpointImpl ep, ExtensionPointRegistry registry) {
        EndpointRegistry endpointRegistry = this.getEndpointRegistry(registry);
        if (endpointRegistry == null) {
            return null;
        }
        Iterator<Endpoint> i$ = endpointRegistry.findEndpoint(ep.getURI()).iterator();
        if (i$.hasNext()) {
            Endpoint endpoint = i$.next();
            return (RuntimeEndpointImpl)endpoint;
        }
        return null;
    }

    private EndpointRegistry getEndpointRegistry(ExtensionPointRegistry registry) {
        ExtensibleDomainRegistryFactory domainRegistryFactory = ExtensibleDomainRegistryFactory.getInstance(registry);
        if (domainRegistryFactory == null) {
            return null;
        }
        EndpointRegistry endpointRegistry = (EndpointRegistry)domainRegistryFactory.getEndpointRegistries().toArray()[0];
        return endpointRegistry;
    }

    @Override
    public InterfaceContract getBindingInterfaceContract() {
        this.resolve();
        if (this.bindingInterfaceContract != null) {
            return this.bindingInterfaceContract;
        }
        this.bindingInterfaceContract = this.getBindingProvider().getBindingInterfaceContract();
        if (this.bindingInterfaceContract == null) {
            this.bindingInterfaceContract = this.getComponentServiceInterfaceContract();
        }
        if (this.bindingInterfaceContract == null) {
            this.bindingInterfaceContract = this.getComponentTypeServiceInterfaceContract();
        }
        return this.bindingInterfaceContract;
    }

    @Override
    public InterfaceContract getComponentTypeServiceInterfaceContract() {
        this.resolve();
        if (this.serviceInterfaceContract != null) {
            return this.serviceInterfaceContract;
        }
        if (this.service == null) {
            return this.getComponentServiceInterfaceContract();
        }
        this.serviceInterfaceContract = this.getLeafContract(this.service).getInterfaceContract();
        if (this.serviceInterfaceContract == null) {
            this.serviceInterfaceContract = this.getComponentServiceInterfaceContract();
        }
        return this.serviceInterfaceContract;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.uri = in.readUTF();
        this.xml = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getURI());
        if (this.serializer == null && this.xml != null) {
            out.writeUTF(this.xml);
        } else if (this.serializer != null) {
            out.writeUTF(this.serializer.write(this));
        } else {
            throw new IllegalStateException("No serializer is configured");
        }
    }

    @Override
    public InterfaceContract getGeneratedWSDLContract(InterfaceContract interfaceContract) {
        if (interfaceContract.getNormalizedWSDLContract() == null && this.getComponentServiceInterfaceContract() instanceof JavaInterfaceContract) {
            if (this.contractBuilder == null) {
                throw new ServiceRuntimeException("Contract builder not found while calculating WSDL contract for " + this.toString());
            }
            this.contractBuilder.build(interfaceContract, null);
        }
        return interfaceContract.getNormalizedWSDLContract();
    }
}

