/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.assembly.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.runtime.BaseEndpointRegistry;
import org.apache.tuscany.sca.runtime.EndpointListener;
import org.apache.tuscany.sca.runtime.EndpointRegistry;
import org.apache.tuscany.sca.runtime.RuntimeProperties;

public class EndpointRegistryImpl
extends BaseEndpointRegistry
implements EndpointRegistry,
LifeCycleListener {
    private final Logger logger = Logger.getLogger(EndpointRegistryImpl.class.getName());
    private List<Endpoint> endpoints = new ArrayList<Endpoint>();
    protected boolean quietLogging;

    public EndpointRegistryImpl(ExtensionPointRegistry extensionPoints, String endpointRegistryURI, String domainURI) {
        super(extensionPoints, null, endpointRegistryURI, domainURI);
        Properties runtimeProps = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class).getUtility(RuntimeProperties.class).getProperties();
        this.quietLogging = Boolean.parseBoolean(runtimeProps.getProperty("org.apache.tuscany.sca.quietLogging"));
    }

    @Override
    public synchronized void addEndpoint(Endpoint endpoint) {
        this.endpoints.add(endpoint);
        for (EndpointListener listener : this.listeners) {
            listener.endpointAdded(endpoint);
        }
        if (this.logger.isLoggable(this.quietLogging ? Level.FINE : Level.INFO)) {
            String uri = null;
            Binding b = endpoint.getBinding();
            if (b != null && (uri = b.getURI()) != null && uri.startsWith("/")) {
                uri = uri.substring(1);
            }
            String msg = "Add endpoint - " + (uri == null ? endpoint.getURI() : b.getType().getLocalPart() + " - " + uri);
            if (this.quietLogging) {
                this.logger.fine(msg);
            } else {
                this.logger.info(msg);
            }
        }
    }

    @Override
    public List<Endpoint> findEndpoint(String uri) {
        ArrayList<Endpoint> foundEndpoints = new ArrayList<Endpoint>();
        for (Endpoint endpoint : this.endpoints) {
            if (!endpoint.matches(uri)) continue;
            foundEndpoints.add(endpoint);
            this.logger.fine("Found endpoint with matching service  - " + endpoint);
        }
        return foundEndpoints;
    }

    @Override
    public synchronized void removeEndpoint(Endpoint endpoint) {
        this.endpoints.remove(endpoint);
        this.endpointRemoved(endpoint);
        if (this.logger.isLoggable(this.quietLogging ? Level.FINE : Level.INFO)) {
            String uri = null;
            Binding b = endpoint.getBinding();
            if (b != null && (uri = b.getURI()) != null && uri.startsWith("/")) {
                uri = uri.substring(1);
            }
            String msg = "Remove endpoint - " + (uri == null ? endpoint.getURI() : b.getType().getLocalPart() + " - " + uri);
            if (this.quietLogging) {
                this.logger.fine(msg);
            } else {
                this.logger.info(msg);
            }
        }
    }

    public synchronized List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public synchronized Endpoint getEndpoint(String uri) {
        for (Endpoint ep : this.endpoints) {
            String epURI = ep.getComponent().getURI() + "#" + ep.getService().getName() + "/" + ep.getBinding().getName();
            if (epURI.equals(uri)) {
                return ep;
            }
            if (ep.getBinding().getName() != null && !ep.getBinding().getName().equals(ep.getService().getName()) || !(epURI = ep.getComponent().getURI() + "#" + ep.getService().getName()).equals(uri)) continue;
            return ep;
        }
        return null;
    }

    public synchronized void updateEndpoint(String uri, Endpoint endpoint) {
        Endpoint oldEndpoint = this.getEndpoint(uri);
        if (oldEndpoint == null) {
            throw new IllegalArgumentException("Endpoint is not found: " + uri);
        }
        this.endpoints.remove(oldEndpoint);
        this.endpoints.add(endpoint);
        for (EndpointListener listener : this.listeners) {
            listener.endpointUpdated(oldEndpoint, endpoint);
        }
    }

    @Override
    public synchronized void start() {
    }

    @Override
    public synchronized void stop() {
        Iterator<Endpoint> i = this.endpoints.iterator();
        while (i.hasNext()) {
            Endpoint ep = i.next();
            i.remove();
            this.endpointRemoved(ep);
        }
        this.endpointreferences.clear();
        this.listeners.clear();
    }
}

