/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceHelper;

public class DefaultFactoryExtensionPoint
implements FactoryExtensionPoint {
    private ExtensionPointRegistry registry;
    private Map<Class<?>, Object> factories = new ConcurrentHashMap();

    public DefaultFactoryExtensionPoint(ExtensionPointRegistry extensionPointRegistry) {
        this.registry = extensionPointRegistry;
    }

    @Override
    public void addFactory(Object factory) {
        Class<?>[] interfaces = factory.getClass().getInterfaces();
        if (interfaces.length == 0) {
            Class<?> sc = factory.getClass().getSuperclass();
            if (sc != Object.class) {
                this.factories.put(sc, factory);
            }
        } else {
            for (int i = 0; i < interfaces.length; ++i) {
                this.factories.put(interfaces[i], factory);
            }
        }
    }

    @Override
    public void removeFactory(Object factory) {
        Class<?>[] interfaces = factory.getClass().getInterfaces();
        if (interfaces.length == 0) {
            Class<?> sc = factory.getClass().getSuperclass();
            if (sc != Object.class) {
                this.factories.remove(sc);
            }
        } else {
            for (int i = 0; i < interfaces.length; ++i) {
                this.factories.remove(interfaces[i]);
            }
        }
    }

    private ClassLoader setContextClassLoader(final ClassLoader classLoader) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                return tccl;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getFactory(Class<T> factoryInterface) {
        Object factory = this.factories.get(factoryInterface);
        if (factory != null) return factoryInterface.cast(factory);
        try {
            ServiceDeclaration factoryDeclaration = this.registry.getServiceDiscovery().getServiceDeclaration(factoryInterface);
            if (factoryDeclaration != null) {
                try {
                    factory = ServiceHelper.newInstance(this.registry, factoryDeclaration);
                }
                catch (NoSuchMethodException e) {
                    factory = ServiceHelper.newInstance(factoryDeclaration.loadClass(), FactoryExtensionPoint.class, (Object)this);
                }
                this.factories.put(factoryInterface, factory);
                return factoryInterface.cast(factory);
            }
            if (factoryInterface.isInterface()) return null;
            if (!Modifier.isAbstract(factoryInterface.getModifiers())) return null;
            Method newInstanceMethod = factoryInterface.getDeclaredMethod("newInstance", new Class[0]);
            ClassLoader tccl = this.setContextClassLoader(factoryInterface.getClassLoader());
            try {
                factory = newInstanceMethod.invoke(null, new Object[0]);
                this.factories.put(factoryInterface, factory);
                T t = factoryInterface.cast(factory);
                return t;
            }
            catch (Exception e) {
                T t2 = null;
                return t2;
            }
            finally {
                this.setContextClassLoader(tccl);
            }
        }
        catch (Exception e2) {
            throw new IllegalArgumentException(e2);
        }
    }
}

