/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.scanner.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.scanner.ContributionScanner;

public class DirectoryContributionScanner
implements ContributionScanner {
    private static final Logger logger = Logger.getLogger(DirectoryContributionScanner.class.getName());
    private ContributionFactory contributionFactory;

    public DirectoryContributionScanner(ContributionFactory contributionFactory) {
        this.contributionFactory = contributionFactory;
    }

    @Override
    public String getContributionType() {
        return "application/vnd.tuscany.folder";
    }

    @Override
    public List<Artifact> scan(Contribution contribution) throws ContributionReadException {
        File directory = this.directory(contribution);
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        List<String> artifactURIs = this.scanContributionArtifacts(contribution);
        for (String uri : artifactURIs) {
            try {
                File file = new File(directory, uri);
                Artifact artifact = this.contributionFactory.createArtifact();
                artifact.setURI(uri);
                artifact.setLocation(file.toURI().toURL().toString());
                artifacts.add(artifact);
            }
            catch (MalformedURLException e) {
                throw new ContributionReadException(e);
            }
        }
        contribution.getTypes().add(this.getContributionType());
        return artifacts;
    }

    private List<String> scanContributionArtifacts(Contribution contribution) throws ContributionReadException {
        File directory = this.directory(contribution);
        ArrayList<String> artifacts = new ArrayList<String>();
        HashSet<File> visited = new HashSet<File>();
        try {
            DirectoryContributionScanner.traverse(artifacts, directory, directory, visited);
        }
        catch (IOException e) {
            throw new ContributionReadException(e);
        }
        return artifacts;
    }

    private static void traverse(List<String> fileList, File file, File root, Set<File> visited) throws IOException {
        try {
            File dir;
            if (file.isFile()) {
                fileList.add(root.toURI().relativize(file.toURI()).toString());
            } else if (file.isDirectory() && !visited.contains(dir = file.getCanonicalFile())) {
                File[] files;
                visited.add(dir);
                String uri = root.toURI().relativize(file.toURI()).toString();
                if (uri.endsWith("/")) {
                    uri = uri.substring(0, uri.length() - 1);
                }
                fileList.add(uri);
                for (File f : files = file.listFiles()) {
                    if (f.getName().startsWith(".")) continue;
                    DirectoryContributionScanner.traverse(fileList, f, root, visited);
                }
            }
        }
        catch (AccessControlException e) {
            logger.log(Level.WARNING, "Error traversing file:" + file.getPath());
        }
    }

    private File directory(Contribution contribution) throws ContributionReadException {
        File file;
        URI uri = null;
        try {
            uri = new URI(contribution.getLocation());
            file = new File(uri);
        }
        catch (URISyntaxException e) {
            throw new ContributionReadException(e);
        }
        catch (IllegalArgumentException e) {
            return new File(uri.getPath());
        }
        if (!file.exists() || !file.isDirectory()) {
            throw new ContributionReadException(contribution.getLocation());
        }
        return file;
    }
}

